<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateSocialAreas extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('social_areas', function (Blueprint $table) {
            $table->increments('id');
            $table->string('name_social_area');
            $table->boolean('monday')->default(0);
            $table->boolean('tuesday')->default(0);
            $table->boolean('wendsday')->default(0);
            $table->boolean('thursday')->default(0);
            $table->boolean('friday')->default(0);
            $table->boolean('saturday')->default(0);
            $table->boolean('sunday')->default(0);
            $table->string('name_file',70)->nullable();
            $table->string('url_file',100)->nullable();
            $table->string('type_file',70)->nullable();
            $table->string('size_file',70)->nullable();
            $table->double('cost')->nullable();
            $table->integer('days_reserve_stay')->nullable();
            $table->string('color',15);
            $table->softDeletes();
            $table->timestamps();

        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('social_areas');
    }
}
