<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateColonyMembers extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('colony_members', function (Blueprint $table) {
            $table->increments('id')->unsigned();
            $table->integer('colony_id')->unsigned()->index();
            $table->foreign('colony_id')->references('id')->on('colonies')->onDelete('cascade');
            $table->string('member_colony_name',60);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::drop('permissions');
    }
}
