<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateUsersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('users', function (Blueprint $table) {
            $table->increments('id');
            $table->string('name');
            $table->string('email',90)->unique()->nullable();
            $table->string('password');
            $table->bigInteger('phone_resident')->nullable();
            $table->integer('street_id')->unsigned()->index()->nullable();
            $table->foreign('street_id')->references('id')->on('streets')->onDelete('cascade');
            $table->boolean('active')->default(1);
            $table->boolean('debt_permission')->default(1);
            $table->boolean('reservation_permission')->default(1);
            $table->boolean('hidden')->default(0);
            $table->rememberToken();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('users');
    }
}