<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateExpenses extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('expenses', function (Blueprint $table) {
            $table->increments('id');
            $table->integer('category')->unsigned()->index();
            $table->foreign('category')->references('id')->on('expense_categories')->onDelete('cascade');
            $table->string('description',70)->nullable();
            $table->double('amount',10,4);
            $table->date('accounting_date');
            $table->date('capture_date');
            $table->string('voucher_name')->nullable();
            $table->string('url_voucher')->nullable();
            $table->string('voucher_type')->nullable();
            $table->string('voucher_size')->nullable();
            $table->integer('payment_type')->unsigned()->index();
            $table->foreign('payment_type')->references('id')->on('payment_types')->onDelete('cascade');
            $table->integer('month')->unsigned()->index();
            $table->foreign('month')->references('id')->on('months')->onDelete('cascade');
            $table->softDeletes();
            $table->timestamps();

        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('expenses');
    }
}
