<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateReservations extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('reservations', function (Blueprint $table) {
            $table->increments('id');
            $table->string('title',60);
            $table->date('date');
            $table->time('time_start');
            $table->time('time_end');
            $table->string('color',7);
            $table->integer('residence_id')->unsigned()->index();
            $table->foreign('residence_id')->references('id')->on('streets')->onDelete('cascade');
            $table->string('voucher_name')->nullable();
            $table->string('url_voucher')->nullable();
            $table->string('voucher_type')->nullable();
            $table->string('voucher_size')->nullable();
            $table->integer('payment_type')->unsigned()->index();
            $table->foreign('payment_type')->references('id')->on('payment_types')->onDelete('cascade');
            $table->double('cost')->nullable();
            $table->date('limit_date')->nullable();
            $table->integer('reservation_status')->unsigned()->index();
            $table->foreign('reservation_status')->references('id')->on('status')->onDelete('cascade');
            $table->integer('social_area')->unsigned()->index();
            $table->foreign('social_area')->references('id')->on('social_areas')->onDelete('cascade');
            $table->softDeletes();
            $table->timestamps();

        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('reservations');
    }
}
