<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateAccountsReceivables extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('accounts_receivables', function (Blueprint $table) {

            $table->increments('id');
            $table->integer('category')->unsigned()->index();
            $table->foreign('category')->references('id')->on('income_categories')->onDelete('cascade');
            $table->double('debt',10,4);
            $table->double('to_pay',10,4);
            $table->integer('month')->unsigned()->index();
            $table->foreign('month')->references('id')->on('months')->onDelete('cascade');
            $table->integer('residence')->unsigned()->index();
            $table->foreign('residence')->references('id')->on('streets')->onDelete('cascade');
            $table->softDeletes();
            $table->timestamps();

        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('accounts_receivables');
    }
}
