<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateGuardSchedule extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('guard_schedules', function (Blueprint $table) {

            $table->increments('id');
            $table->integer('guard_id')->unsigned()->index();
            $table->foreign('guard_id')->references('id')->on('guard_infos')->onDelete('cascade');
            $table->integer('days')->unsigned()->index();
            $table->foreign('days')->references('id')->on('days_guards')->onDelete('cascade');
            $table->time('time_in');
            $table->time('time_out');
            $table->string('schedule',20);
            $table->softDeletes();
            $table->timestamps();

        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('guard_schedules');
    }
}
