<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateAccountsToPay extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('accounts_to_pay', function (Blueprint $table) {

            $table->increments('id');
            $table->integer('category')->unsigned()->index();
            $table->foreign('category')->references('id')->on('expense_categories')->onDelete('cascade');
            $table->string('description',70)->nullable();
            $table->double('debt',10,4);
            $table->double('to_pay',10,4);
            $table->date('capture_date');
            $table->softDeletes();
            $table->timestamps();


        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('accounts_to_pay');
    }
}
