<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateAccountsToPayExpenses extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
         Schema::create('accounts_topay_expenses', function (Blueprint $table) {

            $table->increments('id');
            $table->integer('id_expense')->unsigned()->index();
            $table->foreign('id_expense')->references('id')->on('expenses')->onDelete('cascade');
            $table->integer('id_account_topay')->unsigned()->index();
            $table->foreign('id_account_topay')->references('id')->on('accounts_to_pay')->onDelete('cascade');
            $table->double('paid',10,4);
            $table->softDeletes();
            $table->timestamps();


        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('accounts_topay_expenses');
    }
}
