<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateTableVisits extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('visits', function (Blueprint $table) {

            $table->increments('id');
            $table->string('name',40);
            $table->integer('type')->unsigned()->index();
            $table->foreign('type')->references('id')->on('employes_types')->onDelete('cascade');
            $table->integer('residence_id')->unsigned()->index();
            $table->foreign('residence_id')->references('id')->on('streets')->onDelete('cascade');
            $table->string('file_name')->nullable();
            $table->string('url_file')->nullable();
            $table->string('file_type')->nullable();
            $table->string('file_size')->nullable();
            $table->softDeletes();
            $table->timestamps();

        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('visits');
    }
}
