<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateTableDiscussionsUsers extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('discussions_residence', function (Blueprint $table) {
            $table->increments('id')->unsigned();
            $table->integer('id_discussions')->unsigned()->index();
            $table->foreign('id_discussions')->references('id')->on('discussions')->onDelete('cascade');
            $table->integer('id_residence')->unsigned()->index();
            $table->foreign('id_residence')->references('id')->on('streets')->onDelete('cascade');
            $table->integer('status')->unsigned()->index();
            $table->foreign('status')->references('id')->on('status')->onDelete('cascade');
            $table->integer('id_discussions_options')->unsigned()->index();
            $table->foreign('id_discussions_options')->references('id')->on('discussions_options')->onDelete('cascade');
            $table->string('comments',60)->nullable();
            $table->softDeletes();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::drop('discussions_users');
    }
}
