<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreatePayments extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('payments', function (Blueprint $table) {

            $table->increments('id');
            $table->string('description',50)->nullable();
            $table->string('reason_reject',60)->nullable();
            $table->double('amount',10,4);
            $table->integer('residence')->unsigned()->index();
            $table->foreign('residence')->references('id')->on('streets')->onDelete('cascade');
            $table->date('capture_date');
            $table->date('payment_date')->nullable();
            $table->integer('payment_type')->unsigned()->index()->nullable();
            $table->foreign('payment_type')->references('id')->on('payment_types')->onDelete('cascade');
            $table->string('name_file',70)->nullable();
            $table->string('url_file',100)->nullable();
            $table->string('type_file',70)->nullable();
            $table->string('size_file',70)->nullable();
            $table->integer('month')->unsigned()->index();
            $table->foreign('month')->references('id')->on('months')->onDelete('cascade');
            $table->integer('status')->unsigned()->index();
            $table->foreign('status')->references('id')->on('status')->onDelete('cascade');
            $table->softDeletes();
            $table->timestamps();

        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('payments');
    }
}
