<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateTransferAccounts extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('transfer_accounts', function (Blueprint $table) {

            $table->increments('id');
            $table->integer('source_account')->unsigned()->index();
            $table->foreign('source_account')->references('id')->on('accounts')->onDelete('cascade');
            $table->integer('destination_account')->unsigned()->index();
            $table->foreign('destination_account')->references('id')->on('accounts')->onDelete('cascade');
            $table->string('description',60);
            $table->date('date');
            $table->double('amount',10,4);
            $table->softDeletes();
            $table->timestamps();

        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('transfer_accounts');
    }
}
