<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreatePaymentsPerAccountReceivables extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('payments_account_receivables', function (Blueprint $table) {

            $table->increments('id');
            $table->integer('id_payment')->unsigned()->index();
            $table->foreign('id_payment')->references('id')->on('payments')->onDelete('cascade');
            $table->integer('id_account_receivables')->unsigned()->index();
            $table->foreign('id_account_receivables')->references('id')->on('accounts_receivables')->onDelete('cascade');
            $table->double('paid',10,4);
            $table->softDeletes();
            $table->timestamps();

        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('payments_account_receivables');
    }
}
