<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateAccessColony extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('access_colonies', function (Blueprint $table) {

            $table->increments('id');
            $table->string('name');
            $table->date('date');
            $table->dateTime('check_in')->nullable();
            $table->dateTime('check_out')->nullable();
            $table->integer('type')->unsigned()->index();
            $table->foreign('type')->references('id')->on('access_types')->onDelete('cascade');
            $table->integer('residence_id')->unsigned()->index();
            $table->foreign('residence_id')->references('id')->on('streets')->onDelete('cascade');
            $table->integer('event_id')->unsigned()->index()->nullable();
            $table->foreign('event_id')->references('id')->on('reservations')->onDelete('cascade');
            $table->integer('guest_id')->unsigned()->index()->nullable();
            $table->foreign('guest_id')->references('id')->on('guest')->onDelete('cascade');
            $table->integer('employe_id')->unsigned()->index()->nullable();
            $table->foreign('employe_id')->references('id')->on('employes')->onDelete('cascade');
            $table->string('file_name')->nullable();
            $table->string('url_file')->nullable();
            $table->string('file_type')->nullable();
            $table->string('file_size')->nullable();
            $table->softDeletes();
            $table->timestamps();

        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('access_colonies');
    }
}
