<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateAccounts extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('accounts', function (Blueprint $table) {

            $table->increments('id');
            $table->string('name',20);
            $table->string('description',60);
            $table->integer('account_type')->unsigned()->index();
            $table->foreign('account_type')->references('id')->on('account_types')->onDelete('cascade');
            $table->integer('status')->unsigned()->index();
            $table->foreign('status')->references('id')->on('status')->onDelete('cascade');
            $table->double('balance',10,4);
            $table->string('bank_name',50)->nullable();
            $table->string('number_account',30)->nullable();
            $table->string('branch_office',20)->nullable();
            $table->string('CLABE',50)->nullable();
            $table->string('card',30)->nullable();
            $table->string('titular',50)->nullable();
            $table->string('email',50)->nullable();
            $table->string('member_colony',50)->nullable();
            $table->softDeletes();
            $table->timestamps();

        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('accounts');
    }
}
