$(document).ready(function() {
           
    /* calendario de eventos */
    $('#calendar').fullCalendar({
                
        defaultView: 'month',
        lang: 'es',
        
        /* función que evita que se pueda seleccionar mese atras del actual y da el limite de meses en futuro que puede avanzar */      
        viewRender: function(currentView){
            var minDate = moment(),
            maxDate = moment().add(3,'months');
            // Past
            if (minDate >= currentView.start && minDate <= currentView.end) {
                $(".fc-prev-button").prop('disabled', true); 
                $(".fc-prev-button").addClass('fc-state-disabled'); 
            }
            else {
                $(".fc-prev-button").removeClass('fc-state-disabled'); 
                $(".fc-prev-button").prop('disabled', false); 
            }
            // Future
            if (maxDate >= currentView.start && maxDate <= currentView.end) {
                $(".fc-next-button").prop('disabled', true); 
                $(".fc-next-button").addClass('fc-state-disabled'); 
            } else {
                $(".fc-next-button").removeClass('fc-state-disabled'); 
                $(".fc-next-button").prop('disabled', false); 
            }
        },
        /* termina función que evita que se pueda seleccionar mese atras del actual y da el limite de meses en futuro que puede avanzar */
                
        header: {
            left: 'prev,next today',
            center: 'title',
            right: 'month,basicWeek,basicDay'
        },

        navLinks: true, // can click day/week names to navigate views
        editable: true,
        selectable: true,
        selectHelper: true,

        select: function(start){
            start = moment(start.format());
            //$('#date_start').val(start.format('YYYY-MM-DD'));
            $('#responsive-modal').modal('show');
            $('#day_select').val(start.format('dddd'));
        },

        events: BASEURL + '/eventguard',

        //selectOverlap:false,

        eventClick: function(event, jsEvent, view){
     
            $('#fieldguestadd').empty();
            $('#fieldguestadd2').empty();
            $("#btnaddg").show();
            var date_start = $.fullCalendar.moment(event.start).format('YYYY-MM-DD HH:mm:ss');
            /*var date_start = $.fullCalendar.moment(event.start).format('YYYY-MM-DD');
            var time_start = $.fullCalendar.moment(event.start).format('HH:mm:ss');*/
            var date_end = $.fullCalendar.moment(event.end).format('YYYY-MM-DD HH:mm:ss');

            $('#modal-event #delete').attr('data-id', event.id);
            $('#modal-event #update').attr('data-id', event.id);
            $('#modal-event #_title').val(event.title);
            $('#modal-event #_social_area').val(event.name_social_area);
            $('#modal-event #_date_start').val(date_start);
            //$('#modal-event #_time_start').val(time_start);
            $('#modal-event #_date_end').val(date_end);
            $('#modal-event #_color').val(event.color);
            $('#modal-event #voucher').attr("href", event.url_voucher);
            $('#modal-event #_residence').val(event.name_street);
            $('#modal-event #_number').val(event.number);
                    
            if(event.reservation_status == 2)
            {
                text = '<div class="alert alert-warning">Aun no ha sido aprobada por el administrador.</div>';
                $('#message_status').append(text);
            }
            else
            {
                $('#message_status').empty();
            }

            $.get('/ajax/guests/'+event.id, function(data){
                                                     
                if(data == 1)
                {
                    $("#btnaddg").hide();
                }
                else
                {
                    next = 0;
                    $.each(data, function(index, subcatObj){
                        next++;
                        camp = '<li>'+subcatObj.name_guest+'</li>';
                        $('#fieldguestadd2').append(camp);

                    });
                }
                       
            });

        $('#modal-event').modal('show');

        }
            
    });

    /* calendario de empleados */
    $('#calendar2').fullCalendar({
                
        defaultView: 'month',
        lang: 'es',
                
        viewRender: function(currentView){
            var minDate = moment(),
            maxDate = moment().add(3,'months');
            // Past
            if (minDate >= currentView.start && minDate <= currentView.end) {
                $(".fc-prev-button").prop('disabled', true); 
                $(".fc-prev-button").addClass('fc-state-disabled'); 
            }
            else {
                $(".fc-prev-button").removeClass('fc-state-disabled'); 
                $(".fc-prev-button").prop('disabled', false); 
            }
            // Future
            if (maxDate >= currentView.start && maxDate <= currentView.end) {
                $(".fc-next-button").prop('disabled', true); 
                $(".fc-next-button").addClass('fc-state-disabled'); 
            } else {
                $(".fc-next-button").removeClass('fc-state-disabled'); 
                $(".fc-next-button").prop('disabled', false); 
            }
        },
                
        header: {
            left: 'prev,next today',
            enter: 'title',
            right: 'month,basicWeek,basicDay'
        },

        navLinks: true, // can click day/week names to navigate views
        editable: true,
        selectable: true,
        selectHelper: true,

        select: function(start){

            start = moment(start.format());
            //$('#date_start').val(start.format('YYYY-MM-DD'));
            $('#responsive-modal').modal('show');
            $('#day_select').val(start.format('dddd'));
 
        },

        events: BASEURL + '/eventworkers',

        //selectOverlap:false,

        eventClick: function(event, jsEvent, view){

          
            var date_start = $.fullCalendar.moment(event.start).format('YYYY-MM-DD HH:mm:ss');
            /*var date_start = $.fullCalendar.moment(event.start).format('YYYY-MM-DD');
            var time_start = $.fullCalendar.moment(event.start).format('HH:mm:ss');*/
            var date_end = $.fullCalendar.moment(event.end).format('YYYY-MM-DD HH:mm:ss');
                    
            $('#modal-worker #title').val(event.title);
            $('#modal-worker #date_start').val(date_start);
            $('#modal-worker #date_end').val(date_end);
            $('#modal-worker #color').val(event.color);
            $('#modal-worker #residence').val(event.name_street);
            $('#modal-worker #number').val(event.number);
            $('#modal-worker #employe_name').val(event.name_employe);
            $('#modal-worker').modal('show');
        }
            
    });

   
});
