@extends('master')
@section('content')

<style>
.form-control[readonly]
{
    cursor:pointer!important;
}
.manita
{
    cursor:pointer;
}
</style>
<!--BREADCRUMB-->
<div class="row">
                
    <!--Sección-->
    <div class="col-md-9">
        <div id="page-title">
            <h2>Visitas</h2>
            <p>Registrar tus visitas</p>
        </div>
    </div>
                
    <!--Fecha-->
    @include('date')
</div><!--BREADCRUMB END-->

@if ($errors->has('error'))
    <div class="alert alert-danger">
        <ul>    
            <li>{{ $errors->first('error') }}</li>         
        </ul>
    </div>                                             
@endif
@include('sessionmessage')

@if ($modal == 1)
    <input type="hidden" id="QR" value="1" />      
@else
    <input type="hidden" id="QR" value="0" />                               
@endif


<!-- FORM -->
<div class="panel">
    <div class="panel-body">
        <h3 class="title-hero">
            Agregar visita
            <div class="header-buttons" style="padding-top:5px;">
                 @if ($errors->has('error') || $errors->has('name') || $errors->has('visit_type') || $errors->has('date_end') || $errors->has('file') 
                    || $errors->has('date') || $errors->has('file1'))
                    <a href="#" id="btnabrir" class="btn btn-md btn-danger" data-toggle="collapse" data-target="#demo-2" aria-expanded="true"><i id="iconagregar" class="glyph-icon icon-minus"></i></a>
                @else
                    @if($abierto == 1)
                        <a href="#" id="btnabrir" class="btn btn-md btn-danger" data-toggle="collapse" data-target="#demo-2" aria-expanded="true"><i id="iconagregar" class="glyph-icon icon-minus"></i></a>
                    @else
                        <a href="#" id="btnabrir" class="btn btn-md btn-danger collapsed" data-toggle="collapse" data-target="#demo-2" aria-expanded="true"><i id="iconagregar" class="glyph-icon icon-plus"></i></a>
                    @endif
                @endif
            </div>
           
        </h3>
                    
        <div class="example-box-wrapper">
            <div class="row">
                {!! Form::open(['method' => 'POST', 'action' => 'AccessColonyController@store',  'enctype' => 'multipart/form-data','id' => 'formaccess']) !!}
                <div class="col-md-12">

                @if ($errors->has('error') || $errors->has('name') || $errors->has('visit_type') || $errors->has('date_end') || $errors->has('file') 
                    || $errors->has('date') || $errors->has('file1'))
                    <div id="demo-2" class="collapse in" aria-expanded="true">
                @else
                    @if($abierto == 1)
                        <div id="demo-2" class="collapse in" aria-expanded="true">
                    @else
                        <div id="demo-2" class="collapse" aria-expanded="true">
                    @endif
                @endif
                        <div class="form-horizontal pad15L pad15R bordered-row">
                                       
                            <div class="form-group remove-border">
                              
                                <div class="col-md-4">
                                    <div class="row">
                                        <label class="col-sm-4 control-label">Nombre:*</label>
                                        <div class="col-sm-8 form-group{{ $errors->has('name') ? ' has-error' : '' }}">
                                            <input type="text" class="form-control" id="name" name="name" value="{{old('name')}}" placeholder="Nombre..." required>
                                            @if ($errors->has('name'))
                                                <span class="help-block">
                                                    <strong>{{ $errors->first('name') }}</strong>
                                                </span>
                                            @endif
                                        </div>
                                    </div>
                                </div>

                                <div class="col-md-4">
                                    <div class="row">
                                        <label class="col-sm-4 control-label">Tipo:*</label>
                                        <div class="col-sm-8 form-group{{ $errors->has('visit_type') ? ' has-error' : '' }}">
                                            <select class="form-control" id="visit_type" name="visit_type" required>-->
                                                <option value="">-Selecciona-</option>
                                                @foreach($type as $types)
                                                    @if(old('visit_type') == $types->name)
                                                        <option value="{{$types->name}}" selected>{{$types->name_type}}</option>
                                                    @else
                                                        <option value="{{$types->name}}">{{$types->name_type}}</option>
                                                    @endif
                                                @endforeach
                                            </select>
                                        </div>
                                    </div>
                                </div>
                           
                                <div class="col-md-4" style="display:none;" id="recurrentefecha">

                                    <div class="row">
                                        <label class="col-sm-4 control-label">Fecha finalización:</label>
                                            <div class="col-sm-8 form-group{{ $errors->has('date_end') ? ' has-error' : '' }}">
                                                <div class="input-prepend input-group"  >
                                                    <span class="add-on input-group-addon">
                                                        <i class="glyph-icon icon-calendar"></i>
                                                    </span>
                                                    @if(old('date'))
                                                        <input type="text" class="bootstrap-datepicker form-control manita" autocomplete="off" id="date_end" name="date_end" value="{{old('date_end')}}" pattern="^\d{4}([\-/.])(0?[1-9]|1[0-2])\1(3[01]|[12][0-9]|0?[1-9])$" title="aaaa-mm-dd" >
                                                    @else
                                                        <input type="text" class="bootstrap-datepicker form-control manita" autocomplete="off" id="date_end" name="date_end" value=""  pattern="^\d{4}([\-/.])(0?[1-9]|1[0-2])\1(3[01]|[12][0-9]|0?[1-9])$" title="aaaa-mm-dd" >
                                                    @endif
                                                </div>
                                                @if ($errors->has('date_end'))
                                                    <span class="help-block">
                                                        <strong>{{ $errors->first('date_end') }}</strong>
                                                    </span>
                                                @endif
                                            </div>
                                    </div>
                                </div>

                                <div class="col-md-4" style="display:none;" id="eventualfecha">

                                    <div class="row">
                                        <label class="col-sm-4 control-label">Fecha:*</label>
                                        <div class="col-sm-8 form-group{{ $errors->has('date') ? ' has-error' : '' }}">
                                            <div class="input-prepend input-group"  >
                                                <span class="add-on input-group-addon">
                                                    <i class="glyph-icon icon-calendar"></i>
                                                </span>
                                                @if(old('date'))
                                                    <input type="text" class="bootstrap-datepicker form-control manita" autocomplete="off" id="date" name="date" value="{{old('date')}}" pattern="^\d{4}([\-/.])(0?[1-9]|1[0-2])\1(3[01]|[12][0-9]|0?[1-9])$" title="aaaa-mm-dd" required>
                                                @else
                                                    <input type="text" class="bootstrap-datepicker form-control manita" autocomplete="off" id="date" name="date" value="{!! date('Y-m-d')!!}"  pattern="^\d{4}([\-/.])(0?[1-9]|1[0-2])\1(3[01]|[12][0-9]|0?[1-9])$" title="aaaa-mm-dd" required>
                                                @endif
                                            </div>
                                            @if ($errors->has('date'))
                                                <span class="help-block">
                                                    <strong>{{ $errors->first('date') }}</strong>
                                                </span>
                                            @endif
                                        </div>
                                    </div>
                                </div>
                                                                            
                            </div>

                            <!-- campos para tipo recurrente -->

                            <div id="recurrente" style="display:none;">
                                
                                <div class="form-group">

                                    <div class="col-md-8">
                                        <div class="row">
                                            <label class="col-sm-2 control-label">Días:*</label>
                                                                    
                                            <div class="col-sm-10">
                                                <label class="checkbox-inline">
                                                    @if(old('monday') == "option1")
                                                        <input type="checkbox" id="monday" name="monday" value="option1" checked>
                                                    @else
                                                        <input type="checkbox" id="monday" name="monday" value="option1">
                                                    @endif
                                                        Lunes
                                                </label>
                                                <label class="checkbox-inline">
                                                    @if(old('tuesday') == "option2")
                                                        <input type="checkbox" id="tuesday" name="tuesday" value="option2" checked>
                                                    @else
                                                        <input type="checkbox" id="tuesday" name="tuesday" value="option2">
                                                    @endif
                                                        Martes
                                                </label>
                                                <label class="checkbox-inline">
                                                    @if(old('wendsday') == "option3")
                                                        <input type="checkbox" id="wendsday" name="wendsday" value="option3" checked>
                                                    @else
                                                        <input type="checkbox" id="wendsday" name="wendsday" value="option3">
                                                    @endif
                                                        Miércoles
                                                </label>
                                                <label class="checkbox-inline">
                                                    @if(old('thursday') == "option4")
                                                        <input type="checkbox" id="thursday" name="thursday" value="option4" checked>
                                                    @else
                                                        <input type="checkbox" id="thursday" name="thursday" value="option4">
                                                    @endif
                                                        Jueves
                                                </label>
                                                <label class="checkbox-inline">
                                                    @if(old('friday') == "option5")
                                                        <input type="checkbox" id="friday" name="friday" value="option5" checked>
                                                    @else
                                                        <input type="checkbox" id="friday" name="friday" value="option5">
                                                    @endif
                                                        Viernes
                                                </label>
                                                <label class="checkbox-inline">
                                                    @if(old('saturday') == "option6")
                                                        <input type="checkbox" id="saturday" name="saturday" value="option6" checked>
                                                    @else
                                                        <input type="checkbox" id="saturday" name="saturday" value="option6">
                                                    @endif
                                                        Sábado
                                                </label>
                                                <label class="checkbox-inline">
                                                    @if(old('sunday') == "option7")
                                                        <input type="checkbox"  id="sunday" name="sunday" value="option7" checked>
                                                    @else
                                                        <input type="checkbox"  id="sunday" name="sunday" value="option7">
                                                    @endif
                                                        Domingo
                                                </label>
                                            </div>
                                        </div>
                                    </div>
                                                        
                                    <div class="col-md-4">
                                        <div class="row">
                                            <label class="col-sm-4 control-label">
                                            <span class="bs-badge badge-info tooltip-button" data-toggle="tooltip" data-placement="top" title="Se pueden subir archivos: jpg, jpeg y png.Tamaño maximo del archivo 5 mb.">?</span> Subir foto:</label>
                                            <div class="col-sm-8 form-group{{ $errors->has('file') ? ' has-error' : '' }}">
                                                <div class="fileinput fileinput-new" data-provides="fileinput">
                                                    <span class="btn btn-primary btn-file">
                                                    <span class="fileinput-new">Seleccionar archivo</span>
                                                    <span class="fileinput-exists">Cambiar</span>
                                                        <input type="file" id="file" name="file" value="{{old('file')}}" accept="image/jpg,image/jpeg,image/png">
                                                    </span>
                                                    <span class="fileinput-filename"></span>
                                                    <a href="#" class="close fileinput-exists" data-dismiss="fileinput" style="float: none">×</a>
                                                </div>
                                                @if ($errors->has('file'))
                                                    <span class="help-block">
                                                        <strong>{{ $errors->first('file') }}</strong>
                                                    </span>
                                                @endif
                                                <input type="hidden" id="imageName" name="imageName" value=""/>
                                                <input type="hidden" id="contentType" name="contentType" value=""/>
                                                <input type="hidden" id="imageData" name="imageData" value=""/>
                                                <input type="hidden" id="sizeData" name="sizeData" value=""/>
                                            </div>
                                        </div>
                                    </div> 

                                </div>

                            </div>

                            <!-- campos para tipo eventual -->

                            <div id="eventual" style="display:none;">
                                
                                <div class="form-group">
                                                        
                                    <div class="col-md-4">
                                        <div class="row">
                                            <label class="col-sm-4 control-label">
                                            <span class="bs-badge badge-info tooltip-button" data-toggle="tooltip" data-placement="top" title="Se pueden subir archivos: jpg, jpeg y png.Tamaño maximo del archivo 5 mb.">?</span> Subir foto:</label>
                                            <div class="col-sm-8 form-group{{ $errors->has('file1') ? ' has-error' : '' }}">
                                                <div class="fileinput fileinput-new" data-provides="fileinput">
                                                    <span class="btn btn-primary btn-file">
                                                    <span class="fileinput-new">Seleccionar archivo</span>
                                                    <span class="fileinput-exists">Cambiar</span>
                                                        <input type="file" id="file1" name="file1" value="{{old('file1')}}" accept="image/jpg,image/jpeg,image/png">
                                                    </span>
                                                    <span class="fileinput-filename"></span>
                                                    <a href="#" class="close fileinput-exists" data-dismiss="fileinput" style="float: none">×</a>
                                                </div>
                                                @if ($errors->has('file1'))
                                                    <span class="help-block">
                                                        <strong>{{ $errors->first('file1') }}</strong>
                                                    </span>
                                                @endif
                                                <input type="hidden" id="imageName2" name="imageName2" value=""/>
                                                <input type="hidden" id="contentType2" name="contentType2" value=""/>
                                                <input type="hidden" id="imageData2" name="imageData2" value=""/>
                                                <input type="hidden" id="sizeData2" name="sizeData2" value=""/>
                                            </div>
                                        </div>
                                    </div>

                                </div>
                            </div>
                                                        
                        </div>
                        
                        <div class="row">
                            <div class="col-md-12">
                                <p style="font-size:12px;"><em>(*) Estos campos son requeridos.</em></p>
                            </div>
                        </div>

                        <div class="button-pane mrg20T">
                            <button id="acept" class="btn btn-success">Agregar</button>
                            <div style="display:none;">
                                <button type="submit" id="aceptvisit" class="btn btn-success"></button>
                            </div>
                        </div>

                    </div>
                
                </div>
                {!! Form::close() !!}
            </div>

        </div>
    </div>
</div>
<!-- TERMINA FORM -->

<!-- TABLA -->
<div class="panel">
    <div class="panel-body">
        <h3 class="title-hero">
            Visitas
        </h3>

        @if(empty($visit))

        @else

            <div class="example-box-wrapper">

                <div id="datatable-example_wrapper" class="dataTables_wrapper form-inline no-footer">
                                
                    <div class="remove-columns">
                        <table cellpadding="0" cellspacing="0" border="0" class="table table-striped table-bordered dataTable table-condensed">
                            <thead class="cf">
                                <tr role="row">
                                    <th class="tab-center">Foto</th>
                                    <th class="tab-center">Nombre</th>
                                    <th class="tab-center">Tipo</th>
                                    <th class="tab-center"></th>
                                </tr>
                            </thead>

                            <tbody>
                            @foreach($visit as $visits)
                                        
                                <tr role="row" id="tablevisit">
                                    <td data-title="Foto" class="tab-center va-tab">
                                        @if(empty($visits->url_file))
                                            <img src="/assets/image-resources/id_avatar.png" class="">
                                        @else
                                            <img src="{{$visits->url_file}}" class="" width="50px" height="50px">
                                        @endif
                                    </td>
                                    <td data-title="Nombre" class="tab-center va-tab">{{$visits->vname}}</td>
                                    <td data-title="Tipo" class="tab-center va-tab">{{$visits->name_type}}</td>
                                    <td data-title="Editar" class="tab-center va-tab">
                                        @if($visits->name_type == "Recurrente")
                                        <div style="display:inline-block">
                                            <a href="{{ action('AccessColonyController@edit', $visits->id)}}">
                                                <i class="glyph-icon icon-pencil pad5R"></i>
                                            </a>
                                        </div>
                                        <div style="display:inline-block">
                                            <a href="" style="display:inline-block"  data-toggle="modal" id="deletevisitbtn{{$a++}}" data-target="#deletevisit" value="{{$visits->id}}">
                                                <i class="glyph-icon icon-trash pad5L"></i>
                                            </a>
                                        </div>
                                        @else
                                        <div style="display:inline-block">
                                            <a href="" style="display:inline-block"  data-toggle="modal" id="aprobevisitbtn{{$b++}}" data-target="#aprovevisit" value="{{$visits->id}}">
                                                <i class="glyph-icon icon-check pad5R"></i>
                                            </a>
                                        </div>
                                        <div style="display:inline-block">
                                            <a href="{{ action('AccessColonyController@edit', $visits->id)}}">
                                                <i class="glyph-icon icon-pencil pad5R"></i>
                                            </a>
                                        </div>
                                        <div style="display:inline-block">
                                            <a href="" style="display:inline-block"  data-toggle="modal" id="deletevisitbtn{{$a++}}" data-target="#deletevisit" value="{{$visits->id}}">
                                                <i class="glyph-icon icon-trash pad5L"></i>
                                            </a>
                                        </div>
                                        @endif
                                    </td>
                                </tr>
                            @endforeach
                            </tbody>
                        </table>
                    </div>

                    <div class="row">

                        <div class="col-sm-6">
                            <div class="dataTables_paginate paging_bootstrap" id="datatable-example_paginate">
                                                
                                <ul class="pagination">
                                    {!! $visit->render() !!}        
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

        @endif

    </div>
</div>

<!--- VENTANA MODAL CONFIRMAR ELIMINAR ======-->
<div id="deletevisit" class="modal fade ag-img" tabindex="-1" role="dialog" aria-labelledby="myLargeModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-md">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
                    <h4 class="modal-title">Eliminar visitante</h4>
            </div>
            <div class="modal-body">

                @if(empty($visit))

                @else

                <p>¿Estas seguro que deseas borrar este visitante?</p>
                {!! Form::open(['method' => 'DELETE', 'action' => ['AccessColonyController@destroy', $visits->id]]) !!}
                    <input type="hidden" id="idbtneliminar" name="id" value=""/>             
            </div>
            <div class="modal-footer">
                <button type="submit" id="aceptareliminar" class="btn btn-eliminar">Eliminar</button>
                {!! Form::close()!!}
                @endif
            </div>
        </div>
    </div>
</div>
<!--- TERMINA VENTANA MODAL CONFIRMAR ELIMINAR ======-->        

<!--- VENTANA MODAL AUTORIZAR ACCESO ======-->
<div id="aprovevisit" class="modal fade ag-img" tabindex="-1" role="dialog" aria-labelledby="myLargeModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-md">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
                    <h4 class="modal-title">Autorizar acceso</h4>
            </div>
            <div class="modal-body">


                {!! Form::open(['method' => 'POST', 'action' => 'VisitController@store', 'id' => 'formaprovevisit']) !!}
                    <input type="hidden" id="idbtnaprove" name="id" value=""/>
                    <div class="row">
                        <div class="col-md-8 col-md-offset-2">
                            <div class="row">
                                <label for="" class="col-sm-4 control-label">Fecha:</label>
                                <div class="col-sm-8">
                                    <div class="input-prepend input-group">
                                        <span class="add-on input-group-addon">
                                            <i class="glyph-icon icon-calendar"></i>
                                        </span>

                                        <input type="text" class="bootstrap-datepicker form-control manita" id="date_aprove" name="date_aprove" value="{!! date('Y-m-d')!!}" pattern="^\d{4}([\-/.])(0?[1-9]|1[0-2])\1(3[01]|[12][0-9]|0?[1-9])$" title="aaaa-mm-dd" data-date-format="mm/dd/yy" required> 
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>             
            </div>
            <div class="modal-footer">
                <button type="submit" id="" class="btn btn-success">Autorizar</button>
                {!! Form::close()!!}
              
            </div>
        </div>
    </div>
</div>
<!--- TERMINA VENTANA MODAL AUTORIZAR ACCESO  ======-->     

<!--- VENTANA MODAL QR ======-->
<div id="QRmodal" class="modal fade ag-img" tabindex="-1" role="dialog" data-backdrop="static" data-keyboard="false" aria-labelledby="myLargeModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-md">
        <div class="modal-content">
            <div class="modal-header">
                <!--<button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>-->
                    <h4 class="modal-title">QR de acceso</h4>
            </div>
            <div class="modal-body">
                <div class="row">
                    <div class="col-md-12">
                        <p>
                            @if($u)
                            <img src="{{$u}}" id="imagenqr" width="100%" height="100%">
                            <!--<button id="descargarqr" type="button" value="{{$n}}" class="btn btn-success">Descargar</button>-->
                            <button onclick="downloadImage('{{$u}}', '{{$n}}')" class="btn btn-success" >Descargar</button>

                            @else
                            @endif
                        </p>
 
                    </div>
                </div>             
            </div>
            <div class="modal-footer">
                <button type="button" id="cerrarQR" data-dismiss="modal" class="btn btn-success">Cerrar</button>
                
              
            </div>
        </div>
    </div>
</div>
<!--- TERMINA VENTANA MODAL QR  ======-->     

{!! Html::script('vendor/compress.js/src/Compress.js') !!}
{!! Html::script('vendor/compress.js/index.js') !!}
{!! Html::script('js/validaciones.js') !!}           


<script>

function downloadImage(url, name){
      fetch(url)
        .then(resp => resp.blob())
        .then(blob => {
            const url = window.URL.createObjectURL(blob);
            const a = document.createElement('a');
            a.style.display = 'none';
            a.href = url;
            // the filename you want
            a.download = name;
            document.body.appendChild(a);
            a.click();
            window.URL.revokeObjectURL(url);
        })
        .catch(() => alert('Error al descargar.'));
}

$(document).ready(function() { 
    
    //// qr 
    $('#descargarqr').on('click', function(e){
        
        e.preventDefault(); 
        var uri = $('#descargarqr').val();
        //alert(uri);
        window.open('/download/'+uri,'_blank');
    });

    $('#cerrarQR').on('click', function(){

            window.location.href = location.origin+'/access_colony/create?abierto=1';
                
            
    });

    if($("#QR").val() == 1)
    {
        $("#QRmodal").modal('show');
    }

    /////


    $('#date').datepicker({
    
        minDate: '0d',
    
    });

    $('#date_aprove').datepicker({
    
        minDate: '0d',
    
    });

    

    $('#date_end').datepicker({
    
        minDate: '0d',
    
    });

    

    /// NO PERMITIR ESCRIBIR NADA ////
    $('#date').keypress(function(tecla){

        if(tecla.charCode < 48 || tecla.charCode > 57)return false; 
        if ((tecla.charCode < 97 || tecla.charCode > 122)//letras mayusculas
                && (tecla.charCode < 65 || tecla.charCode > 90) //letras minusculas
                && (tecla.charCode != 45) //retroceso
                && (tecla.charCode != 241) //ñ
                 && (tecla.charCode != 209) //Ñ
                 && (tecla.charCode != 32) //espacio
                 && (tecla.charCode != 225) //á
                 && (tecla.charCode != 233) //é
                 && (tecla.charCode != 237) //í
                 && (tecla.charCode != 243) //ó
                 && (tecla.charCode != 250) //ú
                 && (tecla.charCode != 193) //Á
                 && (tecla.charCode != 201) //É
                 && (tecla.charCode != 205) //Í
                 && (tecla.charCode != 211) //Ó
                 && (tecla.charCode != 218) //Ú
 
                )
                return false;

    });

    $('#date_end').keypress(function(tecla){

        if(tecla.charCode < 48 || tecla.charCode > 57)return false; 
        if ((tecla.charCode < 97 || tecla.charCode > 122)//letras mayusculas
                && (tecla.charCode < 65 || tecla.charCode > 90) //letras minusculas
                && (tecla.charCode != 45) //retroceso
                && (tecla.charCode != 241) //ñ
                 && (tecla.charCode != 209) //Ñ
                 && (tecla.charCode != 32) //espacio
                 && (tecla.charCode != 225) //á
                 && (tecla.charCode != 233) //é
                 && (tecla.charCode != 237) //í
                 && (tecla.charCode != 243) //ó
                 && (tecla.charCode != 250) //ú
                 && (tecla.charCode != 193) //Á
                 && (tecla.charCode != 201) //É
                 && (tecla.charCode != 205) //Í
                 && (tecla.charCode != 211) //Ó
                 && (tecla.charCode != 218) //Ú
 
                )
                return false;

    });



  


    $("#visit_type").on('change', function(){


        if($("#visit_type").val() == "recurrente")
        {
            $("#eventual").hide();
            $("#eventualfecha").hide();
            $("#recurrente").show("slow");
            $("#recurrentefecha").show("slow");

            $("#date").attr("required",false);

        }
        else if($("#visit_type").val() == "eventual")
        {
            $("#recurrente").hide();
            $("#recurrentefecha").hide();
            $("#eventual").show("slow");
            $("#eventualfecha").show("slow");

            $("#date").attr("required",true);
        }
            
    });



    if($("#visit_type").val() == "recurrente")
    {
        $("#eventual").hide();
        $("#eventualfecha").hide();
        $("#recurrente").show("slow");
        $("#recurrentefecha").show("slow");

        $("#date").attr("required",false);

    }
    else if($("#visit_type").val() == "eventual")
    {
        $("#recurrente").hide();
        $("#recurrentefecha").hide();
        $("#eventual").show("slow");
        $("#eventualfecha").show("slow");

        $("#date").attr("required",true);
    }

    $("#acept").on('click', function(){
        
        if($("#visit_type option:selected").attr("value") == "recurrente")
        {
            
            if($("#monday").prop('checked') || $("#tuesday").prop('checked') || $("#wendsday").prop('checked') || $("#thursday").prop('checked') || $("#friday").prop('checked') || $("#saturday").prop('checked') || $("#sunday").prop('checked') )
            {
                $("#aceptvisit").click();
            }
            else
            {
                alert("Tienes que seleccionar al menos un día.");
            }
            
        }
        else
        {

            $("#aceptvisit").click();
            
        }
    });

    $('tr#tablevisit').each(function(i){
        
        $('#deletevisitbtn'+i).on('click', function(){
                
            var id =  $('#deletevisitbtn'+i).attr("value");
            $('#idbtneliminar').attr('value',id);

        }); 

        $('#aprobevisitbtn'+i).on('click', function(){
                
            var id =  $('#aprobevisitbtn'+i).attr("value");
            $('#idbtnaprove').attr('value',id);

        });      
    });
            
   comprimirImagen('file');
   comprimirImagen2('file1');


});

</script>

@include('footer')



@endsection