@extends('master')
@section('content')
<style>

.colmnnueva{

    border-bottom:solid 2px #ff0000!important;
    padding-top: 20px!important;

}
.encabezadonuevo {

    color: #4b5056!important;
    background-color: #f9fafe!important;
    border-color: #dfe8f1!important;
    font-weight: bold!important;
    vertical-align: bottom!important;
    border-bottom-width: 2px!important;
    border-bottom-style: solid!important;
}
.ui-state-hover a,
.ui-state-hover a:hover,
.ui-state-hover a:link,
.ui-state-hover a:visited,
.ui-state-focus a,
.ui-state-focus a:hover,
.ui-state-focus a:link,
.ui-state-focus a:visited {
    color: #bcbcbc;
    text-decoration: none;
}
.ui-state-active,
.ui-state-active,
.ui-state-active {
    border: 1px solid #bcbcbc;
    background: #ffffff url(images/ui-bg_glass_65_ffffff_1x400.png) 50% 50% repeat-x;
    font-weight: bold;
    color: #bcbcbc;
    cursor:pointer;
}
.ui-state-active a,
.ui-state-active a:link,
.ui-state-active a:visited {
    color: #bcbcbc;
    text-decoration: none;
}



</style>
<!--BREADCRUMB-->
<div class="row">
                
    <!--Sección-->
    <div class="col-md-9">
        <div id="page-title">
            <h2>Estado de cuenta</h2>
            <p>Total de las cuentas por cobrar de los residentes</p>
        </div>
    </div>
                
    <!--Fecha-->
    @include('date')

</div><!--BREADCRUMB END-->
  


@include('sessionmessage')   

@if ($errors->has('error'))
    <div class="alert alert-danger">
        <ul>    
            <li>{{ $errors->first('error') }}</li>         
        </ul>
    </div>                                             
@endif


            
<div class="row">
    <div class="col-md-12">
        <div class="panel">
            <div class="panel-body">
                <h3 class="title-hero">
                    Estado de cuenta
                </h3>
                <div class="example-box-wrapper">
                    <div class="remove-columns">

                        {!! Form::open(['method' => 'GET', 'action' => 'AccountStatusController@index', 'id' => 'formestadocuenta']) !!}
                            <div style="padding-bottom:25px;"class="form-horizontal pad15L pad15R bordered-row">

                                <div class="form-group remove-border">
                                    <div class="col-md-4">
                                        <div class="row">
                                            <label class="col-sm-4 control-label">Residencia:</label>
                                            <div class="col-sm-8">
                                                <input type="text" class="form-control" id="searchstreet" value="" placeholder="Calle/piso">
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-8">
                                        <div class="row">
                                            <button class="btn btn-alt btn-hover btn-primary">
                                            <span>Filtrar</span>
                                                <i class="glyph-icon icon-arrow-right"></i>
                                            </button>
                                            <a href="{{ action('AccountStatusController@index')}}" class="btn btn-alt btn-hover btn-default">
                                            <span>Eliminar filtro</span>
                                                <i class="glyph-icon icon-arrow-right"></i>
                                                    </a>
                                                </div>
                                            </div>
                                                
                                            <input type="hidden" class="form-control" id="street" name="filtro" value="" placeholder="Calle">
                                        </div>

                                </div>
                        {!! Form::close() !!}

                     
                        <table class="table table-condensed">
                           
                            <tbody>
                                    <tr class="font-black"  style="font-size:18px;">
                                        <td class="colmnnueva" class="colmnnueva" colspan="6" style="text-align: right; padding-left: 10px;">
                                            <span><strong>TOTAL</span></strong>
                                            <span><strong>${{number_format($total->pay, 2, '.', ',')}}</span></strong>
                                        </td>
                                    </tr>
                                    <tr  class="desaparecer">
                                        <th class="encabezadonuevo">Residencia</th>
                                        <th class="encabezadonuevo tab-center ">Pago adelantado</th>
                                        <th class="encabezadonuevo tab-center ">Por pagar</th>
                                        <th class="encabezadonuevo tab-center">Vencido</th>
                                        <th class="encabezadonuevo tab-center">Al corriente</th>
                                        <th class="encabezadonuevo tab-center">% Vencido</th>
                                       
                                    </tr>

                               

                                @if(empty($estado))

                                @else

                                    @foreach($estado as $estados)
                                        <tr role="row" id="treventos{{$e++}}" style="cursor:pointer;">
                                            
                                            <td id="eventostd" data-title="Residencia">{{$estados->name_street}} {{$estados->number}}
                                            
                                            </td>
                                            <td class="tab-center" data-title="Pago adelantado">
                                                @if(is_null($estados->pago))
                                                    @if(is_null($estados->monto))
                                                        $0
                                                    @else
                                                        ${{$estados->monto}}
                                                    @endif
                                                @else
                                                    @if(is_null($estados->monto))
                                                        ${{$estados->pago}}
                                                    @else
                                                        ${{$t = $estados->monto - $estados->pago}}
                                                    @endif
                                                @endif
                                            </td>
                                            <td class="tab-center" data-title="Por pagar">
                                                @if(is_null($estados->pay))
                                                    $0
                                                @else
                                                    ${{$estados->pay}}
                                                @endif
                                            </td>
                                            <td class="tab-center" data-title="Vencido">
                                                @if(is_null($estados->pasado))
                                                    $0
                                                @else
                                                    ${{$estados->pasado}}
                                                @endif
                                            </td>
                                            <td class="tab-center" data-title="Al corriente">
                                                @if(is_null($estados->vigente))
                                                    $0
                                                @else
                                                    ${{$estados->vigente}}
                                                @endif  
                                            </td>
                                            <td class="tab-center" data-title="% Vencido">
                                                @if(is_null($estados->pasado))
                                                    %0.00
                                                @else
                                                    @if($estados->pay == 0)
                                                        %0.00
                                                    @else
                                                        %{{ number_format(($estados->pasado*100)/$estados->pay,2)}}
                                                    @endif
                                                @endif
                                            </td>
                                            <td style="display:none;">
                                                {!! Form::open(['method' => 'GET', 'action' => 'AccountToPayAdminController@index', 'id' => 'formenviar'.$e]) !!}
                                                    <input type="hidden" name="streetnumber" value="{{$estados->street_id}}"/>
                                                    <input type="hidden" name="estatus" value="{{$stado->id}}"/>
                                                    <button type="submit" id="btneventos{{$e}}" style="display:none;">Ver</button>
                                                {!! Form::close() !!}
                                            </td>
                                        </tr>
                                    @endforeach  

                                @endif                              

                                  
                            </tbody>
                        </table>
                       
                    </div>

                    <div class="row">
                        <div class="col-sm-6 col-sm-offset-6">
                            <div class="dataTables_paginate paging_bootstrap" id="datatable-example_paginate">
                                <ul class="pagination">
                                   {!! $estado->render() !!}
                                </ul>
                            </div>
                        </div>
                    </div>

                </div>
            </div>
        </div>
    </div>
</div>
            

@include('footer')  

<script type="text/javascript" src="../../../../../assets/jquery-ui-1.12.1/jquery-ui.min.js"></script>

<script>

$(document).ready(function() { 
    $('#searchstreet').autocomplete({
        minLenght:1,
        autoFocus:true,
        source: '/getstreets',
        select: function( event, ui ) {
                         
            $('#street').val(ui.item.id);
           
        }

    }); 

    
    

    $('td#eventostd').each(function(i){
       
        $('#treventos'+i).on('click', function(){
         
            var n = i+1;
            $("#formenviar"+n).submit();
            
        });
        
    });
}); 
</script>


@endsection

