@extends('master')
@section('content')


<!--BREADCRUMB-->
<div class="row">
                
    <!--Sección-->
    <div class="col-md-9">
        <div id="page-title">
            <h2>Bancos y cajas</h2>
            <p>Ve el detalle de bancos y cajas</p>
        </div>
    </div>
                
    <!--Fecha-->
    @include('date')

</div><!--BREADCRUMB END-->

      
@include('sessionmessage') 

@if($errors->has('error'))
    <div class="alert alert-danger">
        <ul>    
            <li>{{ $errors->first('error') }}</li>         
        </ul>
    </div>                                             
@endif

<div class="row">
    <div class="col-md-12">
        <div class="panel">
            <div class="panel-body">
                <h3 class="title-hero">
                    <strong>{{$account->description}}</strong>
                </h3>
                <div class="example-box-wrapper">
                    <div class="remove-columns">
                        <table class="table table-condensed table-striped">
                            <thead>
                                <tr>
                                    <th>Fecha</th>
                                    <th class="tab-center">Descripción</th>
                                    <th class="tab-center">Residente</th>
                                    <th class="tab-center">Cargo</th>
                                    <th class="tab-center">Abonos</th>
                                    <th class="tab-center">Saldo</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($detalle as $key => $detalles)
                                    <tr id="">
                                        
                                        <input type="hidden" id="{{$a++}}"/>
                                        <td data-title="Fecha">{{$fecha= substr($detalles->fecha,0,11)}}&nbsp;</td>
                                        <td data-title="Descripción" class="tab-center">
                                            {{$detalles->description}}&nbsp;
                                        </td>
                                        @if(is_numeric($detalles->name_street))
                                            <td data-title="Residente" class="tab-center">&nbsp;</td>
                                            @if(is_numeric($detalles->source_account))
                                                @if($detalles->source_account == $accountid)
                                                    <td data-title="Cargo" class="tab-center">${{number_format($detalles->amount, 2, '.', ',')}}&nbsp;</td>
                                                    <td data-title="Abonos" class="tab-center">&nbsp;</td>
                                                    <input type="hidden" id="cargo{{$a}}" value="{{$detalles->amount}}">
                                                @else
                                                    <td data-title="Cargo" class="tab-center">&nbsp;</td>
                                                    <td data-title="Abonos" class="tab-center">${{number_format($detalles->amount, 2, '.', ',')}}&nbsp;</td>
                                                    <input type="hidden" id="abono{{$a}}" value="{{$detalles->amount}}">
                                                @endif
                                            @else
                                                <td data-title="Cargo" class="tab-center">${{number_format($detalles->amount, 2, '.', ',')}}&nbsp;</td>
                                                <td data-title="Abonos" class="tab-center">&nbsp;</td>
                                                <input type="hidden" id="cargo{{$a}}" value="{{$detalles->amount}}">
                                            @endif
                                        @else
                                            <td data-title="Residente" class="tab-center">{{$detalles->name_street}} {{$detalles->number}}&nbsp;</td>
                                            @if(is_numeric($detalles->source_account))
                                                @if($detalles->source_account == $accountid)
                                                    <td data-title="Cargo" class="tab-center">&nbsp;</td>
                                                    <td data-title="Abonos" class="tab-center">${{number_format($detalles->amount, 2, '.', ',')}}&nbsp;</td>
                                                    <input type="hidden" id="abono{{$a}}" value="{{$detalles->amount}}">
                                                @else
                                                    <td data-title="Cargo" class="tab-center">${{number_format($detalles->amount, 2, '.', ',')}}&nbsp;</td>
                                                    <td data-title="Abonos" class="tab-center">&nbsp;</td>
                                                    <input type="hidden" id="cargo{{$a}}" value="{{$detalles->amount}}">
                                                @endif
                                            @else
                                                <td data-title="Cargo" class="tab-center">&nbsp;</td>
                                                <td data-title="Abonos" class="tab-center">${{number_format($detalles->amount, 2, '.', ',')}}&nbsp;</td>
                                                <input type="hidden" id="abono{{$a}}" value="{{$detalles->amount}}">
                                            @endif
                                        @endif
                                        @if($a == 1)
                                            @if(is_numeric($detalles->name_street))
                                                @if(is_numeric($detalles->source_account))
                                                    @if($detalles->source_account == $accountid)
                                                        <td data-title="Saldo" class="tab-center">${{number_format($total = $account->original_balance - $detalles->amount  , 2, '.', ',')}}</td>
                                                    @else
                                                        <td data-title="Saldo" class="tab-center">${{number_format($total = $account->original_balance + $detalles->amount  , 2, '.', ',')}}</td>
                                                    @endif
                                                @else
                                                    <td data-title="Saldo" class="tab-center">${{number_format($total = $account->original_balance - $detalles->amount  , 2, '.', ',')}}</td>
                                                @endif
                                            @else
                                                @if(is_numeric($detalles->source_account))
                                                    @if($detalles->source_account == $accountid)
                                                        <td data-title="Saldo" class="tab-center">${{number_format($total = $account->original_balance + $detalles->amount  , 2, '.', ',')}}</td>
                                                    @else
                                                        <td data-title="Saldo" class="tab-center">${{number_format($total = $account->original_balance - $detalles->amount  , 2, '.', ',')}}</td>
                                                    @endif
                                                @else
                                                    <td data-title="Saldo" class="tab-center">${{number_format($total = $account->original_balance + $detalles->amount  , 2, '.', ',')}}</td>
                                                @endif
                                            @endif

                                        @else
                                            @if(is_numeric($detalles->name_street))
                                                @if(is_numeric($detalles->source_account))
                                                    @if($detalles->source_account == $accountid)
                                                    <!-- resta -->
                                                        <td data-title="Saldo" class="tab-center">${{number_format($total = $total - $detalles->amount, 2, '.', ',')}}</td>
                                                    @else
                                                    <!-- suma -->
                                                        <td data-title="Saldo" class="tab-center">${{number_format($total = $total + $detalles->amount, 2, '.', ',')}}</td>

                                                    @endif
                                                @else
                                                    <!-- resta -->
                                                    <td data-title="Saldo" class="tab-center">${{number_format($total = $total - $detalles->amount, 2, '.', ',')}}</td>
                                                @endif
                                            @else
                                                @if(is_numeric($detalles->source_account))
                                                    @if($detalles->source_account == $accountid)
                                                    <!-- resta -->
                                                        <td data-title="Saldo" class="tab-center">${{number_format($total = $total + $detalles->amount, 2, '.', ',')}}</td>
                                                    @else
                                                    <!-- suma -->
                                                        <td data-title="Saldo" class="tab-center">${{number_format($total = $total - $detalles->amount, 2, '.', ',')}}</td>

                                                    @endif
                                                @else
                                                    <!-- resta -->
                                                    <td data-title="Saldo" class="tab-center">${{number_format($total = $total + $detalles->amount, 2, '.', ',')}}</td>
                                                @endif
                                            @endif
                                        @endif
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>

                    <div class="button-pane mrg20T">
                    
                        <a type="button" href="{{url('/bank')}}" id="" class="btn btn-default">Regresar</a>
                                
                    </div>

                    <div class="row">
                        <div class="col-sm-6 col-sm-offset-6">
                            <div class="dataTables_paginate paging_bootstrap" id="datatable-example_paginate">
                                <ul class="pagination">
                                  
                                </ul>
                            </div>
                        </div>
                    </div>

                </div>
            </div>
        </div>
    </div>
</div>




@include('footer')

@endsection