@extends('master')
@section('content')

@include('date')

@include('sessionmessage')

@include('error')


<div class="col-md-12">
    <div class="col-md-12" style="background-color:#fff; padding:10px 20px; margin-bottom:10px;">
        <span class="caption-subject" style="float: left; display: inline-block; padding: 12px 0;">Cuentas</span>

        <div class="actions">
            <div class="btn-group">
                            
            </div>
        </div>
    </div>
            
    <div class="col-md-12" style="background-color:#fff; padding:30px; margin-bottom:20px;">
        <div class="portlet">
            <div class="portlet-title">
                <div class="caption">
                    <span class=""> </span>
                </div>
            </div>
            
            {!! Form::open(['method' => 'POST', 'action' => 'AccountController@store', 'id' => 'formaccount']) !!}
            <div class="col-lg-12 col-md-12 login-container bs-reset">
                
                <div class="row">
                    <div class="col-md-4 col-sm-4">
                        
                        <label for="form_control_1">Tipo de cuenta</label>
                        <select class="form-control" id="account_type" name="account_type" value="{{old('account_type')}}" required>
                            <option value="">-selecciona-</option>
                            @foreach($account_type as $account_types)
                                <option value="{{$account_types->id}}">{{$account_types->account_name}}</option>
                            @endforeach
                        </select>
                        @if ($errors->has('account_type'))
                            <span class="help-block">
                                <strong>{{ $errors->first('account_type') }}</strong>
                            </span>
                        @endif

                    </div>
                    <div class="col-md-4 col-sm-4">
                                    
                        <label for="form_control_1">Descripción</label>
                        <input type="text" autocomplete="off" id="description" name="description"  class="form-control" value="{{old('description')}}" required>
                        @if ($errors->has('description'))
                            <span class="help-block">
                                <strong>{{ $errors->first('description') }}</strong>
                            </span>
                        @endif
                    </div>

                    <div class="col-md-4 col-sm-4">
                        
                        <label for="form_control_1">Saldo</label>
                        <input type="text" autocomplete="off" id="balance" name="balance"  pattern="^([0-9]*)|([0-9]*\.?[0-9]{2})$" title="solo numeros,solo 2 decimales" maxlength="12" class="form-control" value="{{old('balance')}}" required>
                        @if ($errors->has('balance'))
                            <span class="help-block">
                                <strong>{{ $errors->first('balance') }}</strong>
                            </span>
                        @endif
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-4 col-sm-4">
                                   
                        <label for="form_control_1">Persona encargada</label>
                        <input type="text" autocomplete="off" id="member_colony" name="member_colony"  maxlength="60" class="form-control" value="{{old('member_colony')}}" required>
                        @if ($errors->has('member_colony'))
                            <span class="help-block">
                                <strong>{{ $errors->first('member_colony') }}</strong>
                            </span>
                        @endif
                    </div>
                </div>
  
                <div id="bankinfo" style="display:none;">
                    <div class="row">
                        <div class="col-md-4 col-sm-4">
                                
                            <label for="form_control_1">Nombre del banco</label>
                            <input type="text" autocomplete="off" id="bank_name" name="bank_name" maxlength="50" class="form-control" value="{{old('bank_name')}}" required>
                            @if ($errors->has('bank_name'))
                                <span class="help-block">
                                    <strong>{{ $errors->first('bank_name') }}</strong>
                                </span>
                            @endif

                        </div>

                        <div class="col-md-4 col-sm-4">
               
                            <label for="form_control_1">No. de cuenta</label>
                            <input type="text" autocomplete="off"  id="number_account" name="number_account" maxlength="25" class="form-control" value="{{old('number_account')}}" required>
                            @if ($errors->has('number_account'))
                                <span class="help-block">
                                    <strong>{{ $errors->first('number_account') }}</strong>
                                </span>
                            @endif

                        </div>

                        <div class="col-md-4 col-sm-4">
                                    
                            <label for="form_control_1">Sucursal</label>
                            <input type="text" autocomplete="off"  id="branch_office" name="branch_office"  maxlength="20" class="form-control" value="{{old('branch_office')}}" required>
                            @if ($errors->has('branch_office'))
                                <span class="help-block">
                                    <strong>{{ $errors->first('branch_office') }}</strong>
                                </span>
                            @endif

                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-4 col-sm-4">
                                    
                            <label for="form_control_1">CLABE</label>
                            <input type="text" autocomplete="off" id="CLABE" name="CLABE"  maxlength="18" class="form-control" value="{{old('CLABE')}}" required>
                            @if ($errors->has('CLABE'))
                                <span class="help-block">
                                    <strong>{{ $errors->first('CLABE') }}</strong>
                                </span>
                            @endif

                        </div>

                        <div class="col-md-4 col-sm-4">
                                    
                            <label for="form_control_1">Tarjeta</label>
                            <input type="text" autocomplete="off" id="card" name="card" value="{{old('card')}}" pattern="^(?:4\d([\- ])?\d{6}\1\d{5}|(?:4\d{3}|5[1-5]\d{2}|6011)([\- ])?\d{4}\2\d{4}\2\d{4})$" title="XXXX-XXXX-XXXX-XXXX" maxlength="19"  class="form-control" required>
                            @if ($errors->has('card'))
                                <span class="help-block">
                                    <strong>{{ $errors->first('card') }}</strong>
                                </span>
                            @endif

                        </div>

                        <div class="col-md-4 col-sm-4">
                                   
                            <label for="form_control_1">Titular</label>
                            <input type="text" autocomplete="off" id="titular" name="titular"  value="{{old('titular')}}" maxlength="30"  class="form-control" required>
                            @if ($errors->has('titular'))
                                <span class="help-block">
                                    <strong>{{ $errors->first('titular') }}</strong>
                                </span>
                            @endif

                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-4 col-sm-4">
                                    
                            <label for="form_control_1">Correo</label>
                            <input type="email" autocomplete="off" id="email" name="email" value="{{old('email')}}"  maxlength="60" class="form-control" required>
                            @if ($errors->has('email'))
                                <span class="help-block">
                                    <strong>{{ $errors->first('email') }}</strong>
                                </span>
                            @endif

                         </div>
                    </div>
                </div>


                <div class="row">
                    <div class="col-md-12">
                        <button type="submit" class="btn btn-sm green dropdown-toggle">Guardar</button>
                    </div>
                </div>

            {!! Form::close() !!}
                            
                    
                </div>
            </div>

        </div>
    </div>
</div>


@include('footer')


<script>

    $("#account_type").on('change', function(){

        if($("#account_type").val() == 1)
        {
            $("#bankinfo").show();
            $("#bank_name").attr("required", true);
            $("#number_account").attr("required", true);
            $("#branch_office").attr("required", true);
            $("#CLABE").attr("required", true);
            $("#card").attr("required", true);
            $("#titular").attr("required", true);
            $("#email").attr("required", true);
            $("#member_colony").attr("required", true);
        }
        else
        {
            $("#bankinfo").hide();
            $("#bank_name").attr("required",false);
            $("#number_account").attr("required",false);
            $("#branch_office").attr("required",false);
            $("#CLABE").attr("required",false);
            $("#card").attr("required",false);
            $("#titular").attr("required",false);
            $("#email").attr("required",false);
            $("#member_colony").attr("required",false);
        }
        
    });

    $('#balance').keypress(function(evt){
        //if(tecla.charCode < 48 || tecla.charCode > 57) return false;
        var charCode = (evt.which) ? evt.which : evt.keyCode;
        if (charCode != 46 && charCode > 31 && (charCode < 48 || charCode > 57))
        return false;
        //return true;
    });

    $('#CLABE').keypress(function(evt){
        //if(tecla.charCode < 48 || tecla.charCode > 57) return false;
        var charCode = (evt.which) ? evt.which : evt.keyCode;
        if (charCode != 46 && charCode > 31 && (charCode < 48 || charCode > 57))
        return false;
        //return true;
    });

</script>



@endsection