@extends('master')
@section('content')

<!--BREADCRUMB-->
<div class="row">
                
    <!--Sección-->
    <div class="col-md-9">
        <div id="page-title">
            <h2>Bancos y cajas</h2>
            <p>Edita los bancos y cajas</p>
        </div>
    </div>
                
    <!--Fecha-->
    @include('date')

</div><!--BREADCRUMB END-->

@include('sessionmessage')
@if ($errors->has('error'))
    <div class="alert alert-danger">
        <ul>    
            <li>{{ $errors->first('error') }}</li>         
        </ul>
    </div>                                             
@endif


<div class="panel">
    <div class="panel-body">
        <h3 class="title-hero">
            Editar cuenta
        </h3>
                    
        <div class="example-box-wrapper">
            <div class="row">
               {!! Form::model($account , ['method' => 'PATCH', 'action' => ['AccountController@update', $account->id]]) !!}
                <div class="col-md-12">
                                
                        <div class="">
                            <div class="form-horizontal pad15L pad15R bordered-row">

                                <div class="form-group remove-border">
                                                
                                    <div class="col-md-4">
                                        <div class="row">
                                            <label class="col-sm-4 control-label">
                                                Tipo de cuenta:*</label>
                                            <div class="col-sm-8 form-group{{ $errors->has('account_type') ? ' has-error' : '' }}">
                                                <select class="form-control" id="account_type" name="account_type" value="{{old('account_type')}}" required>
                                                    @foreach($account_type as $account_types)
                                                        @if($account->account_type == $account_types->id)
                                                            <option value="{{$account_types->id}}" selected>{{$account_types->account_name}}</option>
                                                        @else
                                                            <option value="{{$account_types->id}}">{{$account_types->account_name}}</option>
                                                        @endif
                                                    @endforeach
                                                </select>
                                                @if ($errors->has('account_type'))
                                                  <span class="help-block">
                                                    <strong>{{ $errors->first('account_type') }}</strong>
                                                  </span>
                                                @endif
                                            </div>
                                        </div>
                                    </div>
                                                
                                </div>
                                                
                                <div class="form-group">

                                    <div class="col-md-4">
                                        <div class="row">
                                            <label class="col-sm-4 control-label">
                                                Descrip.:*</label>
                                            <div class="col-sm-8 form-group{{ $errors->has('description') ? ' has-error' : '' }}">
                                                <input type="text" class="form-control" autocomplete="off" id="description" name="description"  class="form-control" value="{{$account->description}}" required placeholder="Descripción">
                                                @if ($errors->has('description'))
                                                    <span class="help-block">
                                                        <strong>{{ $errors->first('description') }}</strong>
                                                    </span>
                                                @endif
                                            </div>
                                            
                                        </div>
                                    </div>
                                                
                                    <div class="col-md-4">
                                        <div class="row">
                                            <label class="col-sm-4 control-label">
                                                Saldo:</label>
                                            <div class="col-sm-8 form-group{{ $errors->has('balance') ? ' has-error' : '' }}">
                                                <div class="input-group">
                                                    <span class="input-group-addon">$</span>
                                                    <input type="text" class="form-control" autocomplete="off" id="balance"  pattern="^([0-9]*)|([0-9]*\.?[0-9]{2})$" title="solo numeros,solo 2 decimales" maxlength="12" class="form-control" value="{{$account->balance}}" readonly="readonly">
                                                    <!--<span class="input-group-addon">.00</span>-->
                                                </div>
                                                @if ($errors->has('balance'))
                                                    <span class="help-block">
                                                        <strong>{{ $errors->first('balance') }}</strong>
                                                    </span>
                                                @endif
                                            </div>
                                        </div>
                                    </div>
                                                
                                    

                                </div>
                                 

                                <div id="bankinfo" style="display:none;">           
                                    <div class="form-group">

                                        <div class="col-md-4">
                                            <div class="row">
                                                <label class="col-sm-4 control-label">
                                                    Banco:*
                                                </label>
                                                <div class="col-sm-8 form-group{{ $errors->has('bank_name') ? ' has-error' : '' }}">
                                                    <input type="text" autocomplete="off" id="bank_name" name="bank_name" maxlength="50" class="form-control"  value="{{$account->bank_name}}" placeholder="Banco..." required>
                                                    @if ($errors->has('bank_name'))
                                                      <span class="help-block">
                                                        <strong>{{ $errors->first('bank_name') }}</strong>
                                                      </span>
                                                    @endif
                                                </div>
                                                
                                            </div>
                                        </div>
                                                    
                                        <div class="col-md-4">
                                            <div class="row">
                                                <label class="col-sm-4 control-label">
                                                    No. de cuenta:*
                                                </label>
                                                <div class="col-sm-8 form-group{{ $errors->has('number_account') ? ' has-error' : '' }}">
                                                    <input type="text" autocomplete="off"  id="number_account" name="number_account" maxlength="25" class="form-control" value="{{$account->number_account}}" placeholder="No. de cuenta..." required>
                                                    @if ($errors->has('number_account'))
                                                      <span class="help-block">
                                                        <strong>{{ $errors->first('number_account') }}</strong>
                                                      </span>
                                                    @endif
                                                </div>
                                                
                                            </div>
                                        </div>
                                                    
                                        <div class="col-md-4">
                                            <div class="row">
                                                <label class="col-sm-4 control-label">
                                                    Cuenta CLABE:*
                                                </label>
                                                <div class="col-sm-8 form-group{{ $errors->has('CLABE') ? ' has-error' : '' }}">
                                                    <input type="text" autocomplete="off" id="CLABE" name="CLABE"  maxlength="18" class="form-control" value="{{$account->CLABE}}" placeholder="Cuenta CLABE..." required>
                                                    @if ($errors->has('CLABE'))
                                                      <span class="help-block">
                                                        <strong>{{ $errors->first('CLABE') }}</strong>
                                                      </span>
                                                    @endif
                                                </div>
                                                
                                            </div>
                                        </div>

                                    </div>
                                                
                                    <div class="form-group">

                                        <div class="col-md-4">
                                            <div class="row">
                                                <label class="col-sm-4 control-label">
                                                    No. de tarjeta:
                                                </label>
                                                <div class="col-sm-8 form-group{{ $errors->has('card') ? ' has-error' : '' }}">
                                                    <input type="text" autocomplete="off" id="card" name="card" maxlength="19"  value="{{$account->card}}" class="form-control" placeholder="No. de tarjeta...">
                                                    @if ($errors->has('card'))
                                                      <span class="help-block">
                                                        <strong>{{ $errors->first('card') }}</strong>
                                                      </span>
                                                    @endif
                                                </div>
                                                
                                            </div>
                                        </div>
                                                    
                                        <div class="col-md-4">
                                            <div class="row">
                                                <label class="col-sm-4 control-label">
                                                    Sucursal:
                                                </label>
                                                <div class="col-sm-8 form-group{{ $errors->has('branch_office') ? ' has-error' : '' }}">
                                                    <input type="text" autocomplete="off"  id="branch_office" name="branch_office"  maxlength="40" class="form-control" value="{{$account->branch_office}}" placeholder="Sucursal...">
                                                    @if ($errors->has('branch_office'))
                                                      <span class="help-block">
                                                        <strong>{{ $errors->first('branch_office') }}</strong>
                                                      </span>
                                                    @endif
                                                </div>
                                                
                                            </div>
                                        </div>
                                                    
                                        <div class="col-md-4">
                                            <div class="row">
                                                <label class="col-sm-4 control-label">
                                                    <span class="bs-badge badge-info tooltip-button" data-toggle="tooltip" data-placement="top" title="Correo electrónico donde se pueden enviar comprobantes de pago">?</span> Correo:
                                                </label>
                                                <div class="col-sm-8 form-group{{ $errors->has('email') ? ' has-error' : '' }}">
                                                    <input type="email" autocomplete="off" id="email" name="email" value="{{$account->email}}"   maxlength="60" class="form-control" placeholder="Correo electrónico...">
                                                    @if ($errors->has('email'))
                                                      <span class="help-block">
                                                        <strong>{{ $errors->first('email') }}</strong>
                                                      </span>
                                                    @endif
                                                </div>

                                            </div>
                                        </div>

                                    </div>
                                </div>

                            </div>

                            <div class="row" >
                                    <div class="col-md-12">
                                        <p style="font-size:12px;"><em>(*) Estos campos son requeridos.</em></p>
                                    </div>
                                </div>

                            <div class="button-pane mrg20T">
                                <a href="{{url('/bank')}}" class="btn btn-default">Cancelar</a>
                                <button class="btn btn-success">Guardar</button>
                            </div>
                        </div>

                    
                </div>
                {!! Form::close() !!}

            </div>
        </div>
    </div>
</div>

@include('footer')

<script>

    if($("#account_type").val() == 1)
    {
        $("#bankinfo").show();
        $("#bank_name").attr("required", true);
        $("#number_account").attr("required", true);
        $("#CLABE").attr("required", true);
        $("#member_colony").attr("required", true);
    }
    else
    {
        $("#bankinfo").hide();
        $("#bank_name").attr("required",false);
        $("#number_account").attr("required",false);
        $("#CLABE").attr("required",false);
        $("#member_colony").attr("required",false);
    }

    $("#account_type").on('change', function(){

        if($("#account_type").val() == 1)
        {
            $("#bankinfo").show();
            $("#bank_name").attr("required", true);
            $("#number_account").attr("required", true);
            $("#CLABE").attr("required", true);
            $("#member_colony").attr("required", true);
        }
        else
        {
            $("#bankinfo").hide();
            $("#bank_name").attr("required",false);
            $("#number_account").attr("required",false);
            $("#CLABE").attr("required",false);
            $("#member_colony").attr("required",false);
        }
        
    });

    $('#balance').keypress(function(evt){
        //if(tecla.charCode < 48 || tecla.charCode > 57) return false;
        var charCode = (evt.which) ? evt.which : evt.keyCode;
        if (charCode != 46 && charCode > 31 && (charCode < 48 || charCode > 57))
        return false;
        //return true;
    });

    $('#CLABE').keypress(function(evt){
        //if(tecla.charCode < 48 || tecla.charCode > 57) return false;
        var charCode = (evt.which) ? evt.which : evt.keyCode;
        if (charCode != 46 && charCode > 31 && (charCode < 48 || charCode > 57))
        return false;
        //return true;
    });

</script>

@endsection