@extends('layouts.app')

@section('content')
<div class="container">
            <div class="row">
                <div class="col-md-12">
            @if (count($errors) > 0)
                <div class="alert alert-danger">
                    <ul>
                        @foreach ($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
            @endif
                </div>
            </div>
            <div class="row">
                <div class="col-md-4">
                    <!-- FORMULARIO 1 -->
                    <div class="content">
                        <!-- DATOS DE INGRESO -->
                        <form method="POST" action="{{ route('register') }}">
                            <div class="login-form">
                                {!! csrf_field() !!}
                                    
                                <h3 class="form-title font-green">Datos de acceso</h3>
                                <!-- CAMPOS DEL FORMULARIO -->
                                <div class="form-group">
                                    <!--ie8, ie9 no soporta html5 placeholder, se coloca el titulo para sustituir el placeholder-->
                                    <label class="control-label visible-ie8 visible-ie9">Usuario</label>
                                    <input class="form-control form-control-solid placeholder-no-fix" type="text" autocomplete="off" placeholder="Usuario" name="email" value="{{ old('email')}}" /> 
                                </div>
                                <div class="form-group">
                                    <label class="control-label visible-ie8 visible-ie9">Contraseña</label>
                                    <input class="form-control form-control-solid placeholder-no-fix" type="password" autocomplete="off" placeholder="Contraseña" name="password" /> 
                                </div>
                                <div class="form-group">
                                    <label class="control-label visible-ie8 visible-ie9">Confirmar contraseña</label>
                                    <input class="form-control form-control-solid placeholder-no-fix" type="password" autocomplete="off" placeholder="Confirmar contraseña" name="password_confirmation" /> 
                                </div>
                            </div>
                    </div>
                </div>
                <div class="col-md-4">
                    <!-- FORMULARIO 2 -->
                    <div class="content">
                        <!-- DATOS DE INGRESO -->
                        <div class="login-form">
                            <h3 class="form-title font-green">Colonia</h3>
                                <!-- CAMPOS DEL FORMULARIO -->
                                <div class="form-group">
                                    <!--ie8, ie9 no soporta html5 placeholder, se coloca el titulo para sustituir el placeholder-->
                                    <label class="control-label visible-ie8 visible-ie9">Nombre de la colonia</label>
                                    <input class="form-control form-control-solid placeholder-no-fix" type="text" autocomplete="off" placeholder="Nombre de la colonia" name="nombre_colonia" value="{{ old('nombre_colonia') }}" /> 
                                </div>
                                <div class="form-group">
                                    <label class="control-label visible-ie8 visible-ie9">Contraseña</label>
                                    <select class="form-control" id="form_control_1" name="paquete" value="{{ old('paquete') }}" style="margin-top: 15px;">
                                        <option value="{{ old('paquete') }}">Paquete</option>
                                       
                                     </select>
                                </div>
                        </div>
                    </div>

                </div>
                <div class="col-md-4">
                    <!-- FORMULARIO 3 -->
                    <div class="content">
                        <!-- DATOS DE INGRESO -->
                        <div class="login-form">
                            <h3 class="form-title font-green">Información personal</h3>
                                <!-- CAMPOS DEL FORMULARIO -->
                                <div class="form-group">
                                    <!--ie8, ie9 no soporta html5 placeholder, se coloca el titulo para sustituir el placeholder-->
                                    <label class="control-label visible-ie8 visible-ie9">Nombre</label>
                                    <input class="form-control form-control-solid placeholder-no-fix" type="text" autocomplete="off" placeholder="Nombre" name="nombre" value="{{ old('nombre') }}" /> 
                                </div>
                                <div class="form-group">
                                    <label class="control-label visible-ie8 visible-ie9">Apellido Paterno</label>
                                    <input class="form-control form-control-solid placeholder-no-fix" type="text" autocomplete="off" placeholder="Apellido Paterno" name="apellido_paterno" value="{{ old('apellido_paterno') }}" /> 
                                </div>
                                <div class="form-group">
                                    <label class="control-label visible-ie8 visible-ie9">Apellido Materno</label>
                                    <input class="form-control form-control-solid placeholder-no-fix" type="text" autocomplete="off" placeholder="Apellido Materno" name="apellido_materno" value="{{ old('apellido_materno') }}" /> 
                                </div>
                                <div class="form-group">
                                    <label class="control-label visible-ie8 visible-ie9">Teléfono</label>
                                    <input class="form-control form-control-solid placeholder-no-fix" type="text" autocomplete="off" placeholder="Teléfono" name="telefono" value="{{ old('telefono') }}" /> 
                                </div>
                        
                        </div>
                    </div>
                    <div class="form-actions">
                        <button type="submit" class="btn green btn-block uppercase">Crear cuenta</button>
                        <a href="redirect">FB Login</a>
                    </div>

                        </form>
                </div>
            </div>
    </div>

@endsection
