@extends('master')
@section('content')

<div class="page-content-wrapper">
    <!-- BEGIN CONTENT BODY -->
    <div class="page-content">
    	<!-- BEGIN PAGE BAR -->
        <div class="page-bar">
            <ul class="page-breadcrumb">
                <li>
                    <a href="">Configuración</a>
                    <i class="fa fa-circle"></i>
                </li>
             	<li>
                     <span>Cuenta de depósito</span>
                </li>
            </ul>
            <div class="page-toolbar">
                <div class="pull-right btn-sm">
                    <i class="icon-calendar"></i>&nbsp;
                        <script>
                            var meses = new Array ("Enero","Febrero","Marzo","Abril","Mayo","Junio","Julio","Agosto","Septiembre","Octubre","Noviembre","Diciembre");
                            var diasSemana = new Array("Domingo","Lunes","Martes","Miércoles","Jueves","Viernes","Sábado");
                            var f=new Date();
                            document.write(diasSemana[f.getDay()] + ", " + f.getDate() + " de " + meses[f.getMonth()] + " de " + f.getFullYear());
                        </script>
                </div>
            </div>
        </div>
        <!-- END PAGE BAR -->
        <!-- BEGIN PAGE TITLE-->
        <h3 class="page-title"><a href="{{ url('/configurations') }}"><i class="icon-arrow-left"></i></a>Configuración</h3>

        <!-- END PAGE TITLE-->
        <!-- END PAGE HEADER-->
        <!-- BEGIN DASHBOARD STATS 1-->
        <div class="clearfix"></div>

        <div class="row">
            <div class="col-md-12">
                @if (Session::has('message'))
                   <div class="alert alert-danger">
                        <p>
                            {{ Session::get('message') }}
                        </p>
                     </div>
                @endif
            </div>
         </div>

        <div class="col-md-10">
            <div class="col-md-12" style="background-color:#fff; padding:10px 20px; margin-bottom:10px;">
                <span class="caption-subject" style="float: left; display: inline-block; padding: 12px 0;">Editar cuenta de depósito</span>

            
                <div class="actions">
                    <div class="btn-group">
                            
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-md-12">
                    @if (count($errors) > 0)
                        <div class="alert alert-danger">
                            <ul>
                                @foreach ($errors->all() as $error)
                                    <li>{{ $error }}</li>
                                 @endforeach
                            </ul>
                            </div>
                         @endif
                    </div>
                </div>
                <div class="col-md-12" style="background-color:#fff; padding:30px; margin-bottom:20px;">
                    <div class="portlet">
                        <div class="portlet-title">
                            <div class="caption">
                                <span class=""> </span>
                            </div>
                        </div>
                       {!! Form::model($accountInfo , ['method' => 'PATCH', 'action' => ['AccountInfoController@update', $accountInfo->id]]) !!}
                        <div class="col-lg-12 col-md-12 login-container bs-reset">
                    <div class="login-content">
                        <form action="javascript:;" class="login-form" method="post">
                            <div class="row">
                                <div class="col-md-4 col-sm-4">
                                    <div class="form-group form-md-line-input has-info form-md-floating-label">
                                        <div class="input-group left-addon">
                                            <input type="text" autocomplete="off" id="bank_name" name="bank_name" value="{{ $accountInfo->bank_name }}"  maxlength="50" class="form-control" required>
                                                <label for="form_control_1">Nombre del banco</label>
                                            @if ($errors->has('bank_name'))
                                                <span class="help-block">
                                                    <strong>{{ $errors->first('bank_name') }}</strong>
                                                </span>
                                            @endif
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-4 col-sm-4">
                                    <div class="form-group form-md-line-input has-info form-md-floating-label">
                                        <div class="input-group left-addon">
                                            <input type="text" autocomplete="off" id="amount" name="amount" pattern="^([0-9]*)|([0-9]*\.?[0-9]{2})$" title="solo numeros,solo 2 decimales" maxlength="12" value="{{ $accountInfo->amount }}" class="form-control" required>
                                                <label for="form_control_1">Monto</label>
                                            @if ($errors->has('amount'))
                                                <span class="help-block">
                                                    <strong>{{ $errors->first('amount') }}</strong>
                                                </span>
                                            @endif
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-4 col-sm-4">
                                    <div class="form-group form-md-line-input has-info form-md-floating-label">
                                        <div class="input-group left-addon">
                                            <input type="text" autocomplete="off"  id="number_account" name="number_account" placeholder="" value="{{ $accountInfo->number_account }}" maxlength="25" class="form-control" required>
                                                <label for="form_control_1">No. de cuenta</label>
                                             @if ($errors->has('number_account'))
                                                <span class="help-block">
                                                    <strong>{{ $errors->first('number_account') }}</strong>
                                                </span>
                                            @endif
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-4 col-sm-4">
                                    <div class="form-group form-md-line-input has-info form-md-floating-label">
                                        <div class="input-group left-addon">
                                            <input type="text" autocomplete="off"  id="branch_office" name="branch_office"  value="{{ $accountInfo->branch_office }}" maxlength="20" class="form-control" required>
                                                <label for="form_control_1">Sucursal</label>
                                             @if ($errors->has('branch_office'))
                                                <span class="help-block">
                                                    <strong>{{ $errors->first('branch_office') }}</strong>
                                                </span>
                                            @endif
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-4 col-sm-4">
                                    <div class="form-group form-md-line-input has-info form-md-floating-label">
                                        <div class="input-group left-addon">
                                            <input type="text" autocomplete="off" id="CLABE" name="CLABE" value="{{ $accountInfo->CLABE }}" maxlength="18" class="form-control" required>
                                                <label for="form_control_1">CLABE</label>
                                             @if ($errors->has('CLABE'))
                                                <span class="help-block">
                                                    <strong>{{ $errors->first('CLABE') }}</strong>
                                                </span>
                                            @endif
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-4 col-sm-4">
                                    <div class="form-group form-md-line-input has-info form-md-floating-label">
                                        <div class="input-group left-addon">
                                            <input type="text" autocomplete="off" id="card" name="card" value="{{ $accountInfo->card }}" pattern="^(?:4\d([\- ])?\d{6}\1\d{5}|(?:4\d{3}|5[1-5]\d{2}|6011)([\- ])?\d{4}\2\d{4}\2\d{4})$" title="XXXX-XXXX-XXXX-XXXX" maxlength="19" class="form-control" required>
                                                <label for="form_control_1">Tarjeta</label>
                                             @if ($errors->has('card'))
                                                <span class="help-block">
                                                    <strong>{{ $errors->first('card') }}</strong>
                                                </span>
                                            @endif
                                        </div>
                                    </div>
                                </div>
                                
                            </div>
                            <div class="row">
                                <div class="col-md-4 col-sm-4">
                                    <div class="form-group form-md-line-input has-info form-md-floating-label">
                                        <div class="input-group left-addon">
                                            <input type="text" autocomplete="off" id="titular" name="titular" value="{{ $accountInfo->titular }}" maxlength="30"  class="form-control" required>
                                                <label for="form_control_1">Titular</label>
                                             @if ($errors->has('titular'))
                                                <span class="help-block">
                                                    <strong>{{ $errors->first('titular') }}</strong>
                                                </span>
                                            @endif
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-4 col-sm-4">
                                    <div class="form-group form-md-line-input has-info form-md-floating-label">
                                        <div class="input-group left-addon">
                                            <input type="email" autocomplete="off" id="email" name="email" value="{{ $accountInfo->email }}" maxlength="60" class="form-control" required>
                                                <label for="form_control_1">Correo</label>
                                             @if ($errors->has('email'))
                                                <span class="help-block">
                                                    <strong>{{ $errors->first('email') }}</strong>
                                                </span>
                                            @endif
                                        </div>
                                    </div>
                                </div>
                            </div>
                                <div class="row">
                                    <div class="col-md-12">
                                        <button type="submit" class="btn btn-sm green dropdown-toggle">Guardar</button>
                                    </div>
                                </div>
                    {!! Form::close() !!}
                            
                    
                    </div>
                </div>

      
            </div>
        </div>
        </div>
        
		

	</div>

</div>

<script>
    $('#amount').keypress(function(evt){
        //if(tecla.charCode < 48 || tecla.charCode > 57) return false;
        var charCode = (evt.which) ? evt.which : evt.keyCode;
        if (charCode != 46 && charCode > 31 && (charCode < 48 || charCode > 57))
        return false;
        //return true;
    });
    $('#CLABE').keypress(function(evt){
        //if(tecla.charCode < 48 || tecla.charCode > 57) return false;
        var charCode = (evt.which) ? evt.which : evt.keyCode;
        if (charCode != 46 && charCode > 31 && (charCode < 48 || charCode > 57))
        return false;
        //return true;
    });

</script>


@endsection