@extends('master')
@section('content')

<!--BREADCRUMB-->
<div class="row">
    <!--Sección-->
    <div class="col-md-9">
        <div id="page-title">
            <h2>Información</h2>
            <p>Revisa información de la mesa directiva y cuentas de pago.</p>
        </div>
    </div>
                
    @include('date')

</div><!--#BREADCRUMB END-->

@include('error')

<div class="row">
    <div class="col-md-12">
        <div class="panel">
            <div class="panel-body">
                
                <h3 class="title-hero">
                    Información del residencial
                   
                </h3>
                <div class="example-box-wrapper">
                    <div class="remove-columns">
                        <table class="table table-condensed table-striped">
                            <thead>
                                <tr>
                                    <th>Nombre del residencial</th>
                                    <th>Presidente</th>
                                    <th>Tesorero</th>
                                    <th>Secretario</th>
                                    <th>Vocales</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($colony as $colonies)
                                <tr>
                                    <td data-title="Nombre" style="word-break:break-all">{{$colonies->colony_name}}&nbsp;</td>
                                    <td data-title="Presidente" style="word-break:break-all">{{$colonies->president_colony_name}}&nbsp;</td>
                                    <td data-title="Tesorero" style="word-break:break-all">{{$colonies->treasurer_colony_name}}&nbsp;</td>
                                    <td data-title="Secretario" style="word-break:break-all">{{$colonies->secretary_colony_name}}&nbsp;</td>
                                    <td data-title="Vocales" style="word-break:break-all">
                                        <ul>
                                            @foreach($member as $members)
                                                <li>{{$members->member_colony_name}}</li>
                                            @endforeach
                                        </ul>&nbsp;
                                    </td> 
                                </tr>
                                @endforeach
                             </tbody>
                        </table>
                    </div>
                </div>
                
            </div>
        </div>
    </div>
</div>


<div class="row">
    <div class="col-md-12">
        <div class="panel">
            <div class="panel-body">
                <h3 class="title-hero">
                    Información de cuentas
                </h3>
                <div class="example-box-wrapper">
                    <div class="remove-columns">
                        <table class="table table-condensed table-striped">
                            <thead>
                                <tr>
                                    <th>Banco</th>
                                    <th>No. de cuenta</th>
                                    <th class="tab-center">Sucursal</th>
                                    <th class="tab-center">CLABE</th>
                                    <th class="tab-center">No. de tarjeta</th>
                                    <th class="tab-center">Correo</th>
                                </tr>
                            </thead>
                            <tbody>
                                @if(empty($account))
                                        
                                @else
                                    @foreach($account as $accounts)
                                        <tr id="traccount">
                                            <td data-title="Banco" style="word-break:break-all">{{ $accounts->bank_name }}&nbsp;</td>
                                            <td data-title="Descripción" style="word-break:break-all">{{ $accounts->number_account }}&nbsp;</td>
                                            <td data-title="Sucursal" class="tab-center" style="word-break:break-all">{{ $accounts->branch_office }}&nbsp;</td>
                                            <td data-title="CLABE" class="tab-center" style="word-break:break-all">{{ $accounts->CLABE }}&nbsp;</td>
                                            <td data-title="Tarjeta" class="tab-center" style="word-break:break-all">{{ $accounts->card }}&nbsp;</td>
                                            <td data-title="Correo" class="tab-center" style="word-break:break-all">{{ $accounts->email }}&nbsp;</td>
                                        </tr>
                                    @endforeach
                                @endif
                                           
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>


<div class="row">
    <div class="col-md-12">
                
        <div class="panel">
            <div class="panel-body">
                <h3 class="title-hero">
                    Información de guardias
                </h3>
                            
                <div class="example-box-wrapper">
                    @foreach($guard_info as $guard_infos)
                    <input type="hidden" value="{{$a++}}"/>
                        <div class="panel-group" id="accordionguard">
                            <div class="panel">
                                <div class="panel-heading">
                                    <h4 class="panel-title">
                                        <a data-toggle="collapse" data-parent="#accordion" href="#collapse{{$a}}">
                                            {{$guard_infos->name_guard}}
                                        </a>
                                    </h4>
                                </div>
                                <div id="collapse{{$a}}" class="panel-collapse collapse">
                                    <div class="panel-body">
                                        <div class="row">
                                            <div class="col-md-12">
                                                <table cellpadding="0" cellspacing="0" border="0" class="table table-striped table-condensed">
                                                    <thead>
                                                        <tr>
                                                            <th class="tab-center">Día</th>
                                                            <th class="tab-center">Horario</th>
                                                        </tr>
                                                    </thead>

                                                    <tbody>
                                                        @foreach($guard_s as $guard)
                                                            @if($guard->guard_id == $guard_infos->id)
                                                                <tr>
                                                                    <td class="va-tab">
                                                                        <input type="text" class="form-control" id="" placeholder="Lunes" value="{{$guard->days}}" disabled>
                                                                    </td>
                                                                    <td class="tab-center">
                                                                        <input type="text" class="form-control" id="" placeholder="{{$guard->schedule}}" disabled>
                                                                    </td>
                                                                </tr>
                                                            @endif
                                                        @endforeach     
                                                    </tbody>
                                                </table>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    @endforeach
                </div>
                            
            </div>

        </div>
                            
    </div>
</div>
@include('footer')
@endsection
