@extends('master')
@section('content')


<!--BREADCRUMB-->
<div class="row">
                
    <!--Sección-->
    <div class="col-md-9">
        <div id="page-title">
            <h2>Configuración</h2>
            <p>Información del residencial y configuración del sistema</p>
        </div>
    </div>
                
    <!--Fecha-->
    @include('date')

</div><!--BREADCRUMB END-->

@if ($errors->has('error'))
    <div class="alert alert-danger">
        <ul>    
            <li>{{ $errors->first('error') }}</li>         
        </ul>
    </div>                                             
@endif
@include('sessionmessage')

<div class="panel">
    <div class="panel-body">
        <h3 class="title-hero">
            Editar información del residencial
        </h3>
                    
        <div class="example-box-wrapper">
            <div class="row">
                {!! Form::model($colony , ['method' => 'PATCH', 'action' => ['ColonyController@update', $colony->id]]) !!}
                    <div class="col-md-12">
                       
                                
                            <div class="">
                                <div class="form-horizontal pad15L pad15R bordered-row">

                                    <div class="form-group remove-border">
                                                
                                        <div class="col-md-4">
                                            <div class="row">
                                                <label class="col-sm-4 control-label">
                                                    Residencial:*</label>
                                                <div class="col-sm-8 form-group{{ $errors->has('colony_name') ? ' has-error' : '' }}">
                                                    <input type="text" class="form-control" id="colony_name" name="colony_name" maxlength="60" value="{{ $colony->colony_name }}" placeholder="Residencial.." required>
                                                    @if ($errors->has('colony_name'))
                                                      <span class="help-block">
                                                        <strong>{{ $errors->first('colony_name') }}</strong>
                                                      </span>
                                                    @endif
                                                </div>
                                            </div>
                                        </div>
                                                
                                        <div class="col-md-4">
                                            <div class="row">
                                                <label class="col-sm-4 control-label">
                                                    Presidente:*</label>
                                                <div class="col-sm-8 form-group{{ $errors->has('president_colony_name') ? ' has-error' : '' }}">
                                                    <input type="text" class="form-control" id="president_colony_name" name="president_colony_name" value="{{ $colony->president_colony_name }}" placeholder="Nombre del presidente..." >
                                                    @if ($errors->has('president_colony_name'))
                                                      <span class="help-block">
                                                        <strong>{{ $errors->first('president_colony_name') }}</strong>
                                                      </span>
                                                    @endif
                                                </div>
                                            </div>
                                        </div>
                                                
                                    </div>
                                                
                                    <div class="form-group">

                                        <div class="col-md-4">
                                            <div class="row">
                                                <label class="col-sm-4 control-label">
                                                    Tesorero:</label>
                                                <div class="col-sm-8">
                                                    <input type="text" class="form-control" id="treasurer_colony_name" name="treasurer_colony_name" value="{{ $colony->treasurer_colony_name }}" placeholder="Nombre del tesorero...">
                                                </div>
                                            </div>
                                        </div>
                                                
                                        <div class="col-md-4">
                                            <div class="row">
                                                <label class="col-sm-4 control-label">
                                                    Secretario:</label>
                                                <div class="col-sm-8">
                                                    <input type="text" class="form-control" id="secretary_colony_name" name="secretary_colony_name" value="{{ $colony->secretary_colony_name }}" placeholder="Nombre del secretario...">
                                                </div>
                                            </div>
                                        </div>

                                        <div class="col-md-4">
                                            <div class="row">
                                                <label class="col-sm-4 control-label">
                                                    Vocales:</label>
                                                    <div class="col-sm-8">
                                                        @foreach($member as $members)
                                                            <div class="input-group form-guess" id="member_colony_name_edit{{$a++}}">
                                                                <span class="input-group-addon addon-inside btn-danger msg-warning" id="deletefieldedit{{$a}}">
                                                                    <i class="glyph-icon icon-times" ></i>
                                                                </span>

                                                                <input type="text" id="member_colony" name="member_colony_name_edit[]" value="{{$members->member_colony_name}}" class="form-control" required>
                                                                <input type="hidden" name="id_member_colony[]" value="{{$members->id}}" />
                                                            </div>
                                                        @endforeach
                                                        
                                           

                                                        <div class="input-group form-guess">
                                                            <span class="input-group-addon addon-inside btn-primary">
                                                                <i class="glyph-icon icon-plus" id="btnaddmember"></i>
                                                            </span>
                                                            <input type="text" class="form-control" id="member_colony_name" name="member_colony_name[]" value="" placeholder="Nombre del vocal">
                                                        </div>
                                                        <div id="memberfield">
                                                        </div>

                                                    </div>
                                            </div>
                                        </div>
                                    </div>
                                                
                                </div>

                                <div class="row" >
                                    <div class="col-md-12">
                                        <p style="font-size:12px;"><em>(*) Estos campos son requeridos.</em></p>
                                    </div>
                                </div>

                                <div class="button-pane mrg20T">
                                    <a href="{{action('ConfigMasterController@index', ['i' => 1])}}" class="btn btn-default">Cancelar</a>
                                    <button class="btn btn-success">Guardar</button>
                                </div>
                            </div>

                        
                    </div>
                {!! Form::close() !!}
            </div>
        </div>
    </div>
</div>


@include('footer')  
{!! Html::script('js/colony.js') !!}
@endsection
