
@foreach($config as $configs)
<div class="row">

    <!-- CONFIGURACION -->
    <div class="col-md-6">
        <div class="panel">
            <div class="panel-body">
                
                <h3 class="title-hero">
                    Configuración
                    {!! Form::open(['method' => 'GET', 'action' => ['ConfigController@edit', $configs->id]]) !!}
                        <div class="header-buttons">
                            <input type="hidden" name="tconfiguracion" value="1"/>
                            <button type="submit" class="btn btn-xs btn-warning">Editar</button>
                        </div>
                    {!! Form::close() !!} 
                </h3>
                <div class="example-box-wrapper">
                    <div class="">
                        <table class="table table-condensed" style="">
                            <tbody>
                                <tr>
                                    <td><strong>Aportación mensual:</strong></td>
                                    <td>{{$contribution}}</td>
                                </tr>
                                <tr>
                                    <td><strong>Múltiples aportaciones:</strong></td>
                                    <td>
                                        @if($configs->multiple_contributions == 1)
                                             Activo   
                                        @else
                                            Desactivado
                                        @endif
                                    </td>
                                </tr>
                                <tr>
                                    <td><strong>Meses permitidos de reserva:</strong></td>
                                    <td>{{$configs->max_reservation_months}}</td>
                                </tr>
                                    <td><strong>Mostrar adeudo a residentes:</strong></td>
                                    <td>
                                        @if($configs->show_debt_resident == 1)
                                            Activo
                                        @else
                                            Desactivado
                                        @endif
                                    </td>
                                <tr>
                                    <td><strong>Restricción de morosos:</strong></td>
                                    <td>
                                        @if($configs->access_debtor == 1)
                                            Activo
                                        @else
                                            Desactivado
                                        @endif
                                    </td>
                                </tr>
                                <tr>
                                    <td><strong>Días de crédito:</strong></td>
                                    <td>{{$configs->days_to_be_debtor}}</td>
                                </tr>
                                <tr>
                                    <td><strong>Recargos por falta de pago:</strong></td>
                                    <td>
                                        @if($configs->charge_no_pay == 1)
                                            Activo
                                        @else
                                            Desactivado
                                        @endif
                                    </td>
                                </tr>
                                <tr>
                                    <td><strong>Acceso a discusiones:</strong></td>
                                    <td>
                                        @if($configs->discussion_debtor == 1)
                                            Activo
                                        @else
                                            Desactivado
                                        @endif
                                    </td>
                                </tr>
                                <!-- #Limite de eventos por casa-->
                                <tr>
                                    <td><strong>Limite de reservas la mes:</strong></td>
                                    <td>
                                        @if($configs->limit_events == 1)
                                             Activo   
                                        @else
                                            Desactivado
                                        @endif
                                    </td>
                                </tr>
                                <!-- Fin de Limite de eventos por casa -->
                            </tbody>
                        </table>

                       
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- TERMINA CONFIGURACION -->

    <!-- NOTIFICACIONES -->
    <div class="col-md-6">
        <div class="panel">
            <div class="panel-body">
                <h3 class="title-hero">
                    Notificaciones
                    {!! Form::open(['method' => 'GET', 'action' => ['ConfigController@edit', $configs->id]]) !!}
                        <div class="header-buttons">
                            <input type="hidden" name="tconfiguracion" value="2"/>
                            <button type="submit" class="btn btn-xs btn-warning" id="">Editar</button>
                        </div>
                    {!! Form::close() !!}
                </h3>
                <div class="example-box-wrapper">
                    <div class="">
                        <table class="table table-condensed">
                            <tbody>
                                <tr>
                                    <td><strong>Correo de registro de pago:</strong></td>
                                    <td>
                                        @if($configs->send_mail == 1)
                                            Activo
                                        @else
                                            Desactivado
                                        @endif
                                    </td>
                                </tr>
                                <tr>
                                    <td><strong>Correo de recordatorio de pago:</strong></td>
                                    <td>
                                        @if($configs->reminder_email == 1)
                                            Activo
                                        @else
                                            Desactivado
                                        @endif
                                    </td>
                                </tr>
                                <tr>
                                    <td><strong>Correo de cancelación de reservación:</strong></td>
                                    <td>
                                        @if($configs->email_cancel_reservation == 1)
                                            Activo
                                        @else
                                            Desactivado
                                        @endif
                                    </td>
                                </tr>
                                <tr>
                                    <td><strong>Correo de recargo por falta de pago:</strong></td>
                                    <td>
                                        @if($configs->email_charge == 1)
                                            Activo
                                        @else
                                            Desactivado
                                        @endif
                                    </td>
                                </tr>
                                <tr>
                                    <!--<td><strong>Correo de aportación extraordinaria:</strong></td>
                                    <td>
                                        @if($configs->email_extraordinary_account == 1)
                                            Activo
                                        @else
                                            Desactivado
                                        @endif
                                    </td>-->
                                    <td>&nbsp;</td>
                                    <td>&nbsp;</td>
                                </tr>
                                <tr>
                                    <td>&nbsp;</td>
                                    <td>&nbsp;</td>
                                </tr>
                               
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- TERMINA NOTIFIACIONES -->

</div>

<div class="row">
    <div class="col-md-6">
        <div class="panel">
            <div class="panel-body">
                <h3 class="title-hero">
                    Permisos de guardia para registro de
                    {!! Form::open(['method' => 'GET', 'action' => ['ConfigController@edit', $configs->id]]) !!}
                        <div class="header-buttons">
                            <input type="hidden" name="tconfiguracion" value="3"/>
                            <button type="submit" class="btn btn-xs btn-warning">Editar</button>
                        </div>
                    {!! Form::close() !!} 
                </h3>
                <div class="example-box-wrapper">
                    <div class="">
                        <table class="table table-condensed">
                            <tbody>
                                <tr> 
                                    <td><strong>Invitados:</strong></td> 
                                    <td>
                                        @if($configs->guard_guest == 1)
                                            Activo
                                        @else
                                            Desactivado
                                        @endif
                                    </td>
                                </tr>
                                <tr>
                                    <td><strong>Visitantes:</strong></td>
                                    <td>
                                        @if($configs->guard_visit == 1)
                                            Activo
                                        @else
                                            Desactivado
                                        @endif
                                    </td>
                                </tr>
                                <tr>
                                    <td><strong>Empleados:</strong></td>
                                    <td>
                                        @if($configs->guard_employe == 1)
                                            Activo
                                        @else
                                            Desactivado
                                        @endif
                                    </td>
                                </tr>
                         
                            </tbody>
                        </table>
                     
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
      
@endforeach
