
@if(empty($config))
    <div class="portlet box red">
        <div class="portlet-title">
            <div class="caption">
                Configuración de sistema<i class="fa fa-cogs"></i> 
            </div>
            <div class="tools">
                <a href="javascript:;" class="collapse" data-original-title="" title=""> </a>
                <a href="javascript:;" class="reload" data-original-title="" title=""> </a>
            </div>
        </div>
        <div class="portlet-body">
           
                <div class="btn-group">
                    @can('create', App\Config::class)
                        <button type="submit" class="btn btn-sm green dropdown-toggle"><a style="text-decoration:none;color:white;" href="{{ action('ConfigController@create')}}">Agregar</a>
                        </button>
                    @endcan
                </div>
            
        </div>
    </div>
@else      
    <div class="portlet">
        <div class="portlet box red">
            <div class="portlet-title">
                <div class="caption">
                    Configuración de sistema<i class="fa fa-cogs"></i> 
                </div>
                <div class="tools">
                    <a href="javascript:;" class="collapse" data-original-title="" title=""> </a>
                    <a href="javascript:;" class="reload" data-original-title="" title=""> </a>
                </div>
            </div>
            <div class="portlet-body">
                <div class="table-responsive">
                    <table class="table">
                        <thead>
                            <tr>
                                <td>Envio de correo</td>
                                <td>Acceso a morosos</td>
                                <td>Meses de reserva</td>
                                <td>Días para ser moroso</td>
                                <td></td>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($config as $configs)
                                <tr>
                                    <td>
                                        @if($configs->send_mail == 1)
                                            Activo
                                        @else
                                            Desactivado
                                        @endif
                                    </td>
                                    <td>
                                        @if($configs->acces_debtor == 1)
                                            Activo
                                        @else
                                            Desactivado
                                        @endif
                                    </td>
                                    <td>{{$configs->max_reservation_months}}</td>
                                    <td>{{$configs->days_to_be_debtor}}</td>
                                    <td align="center"> 
                                        @can('edit', App\Config::class)
                                            {!! Form::open(['method' => 'GET', 'action' => ['ConfigController@edit', $configs->id]]) !!}
                                                <div style="display:inline-block">
                                                    <button type="submit" class="btn btn-success"><i class="glyph-icon icon-pencil"></i></button>
                                                </div>
                                            {!! Form::close() !!} 
                                        @endcan 
                                    </td>                     
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
@endif
            