@extends('master')
@section('content')


<!--BREADCRUMB-->
<div class="row">
                
    <!--Sección-->
    <div class="col-md-9">
        <div id="page-title">
            <h2>Plantilla de correo</h2>
            <p>Activa la plantilla de correo</p>
        </div>
    </div>
                
    <!--Fecha-->
    @include('date')

</div><!--BREADCRUMB END-->
            

@if(empty($email_template))
<div class="panel">
    <div class="panel-body">
        <h3 class="title-hero">
            Nueva plantilla de correo
            <div class="header-buttons">
                <a href="#" class="btn btn-xs btn-danger" data-toggle="collapse" data-target="#demo-2" aria-expanded="true"><i class="glyph-icon icon-plus"></i></a>
            </div>
        </h3>

        {!! Form::open(['method' => 'POST', 'action' => 'EmailTemplateController@store', 'id' => 'formemailtemplate']) !!}
        <div class="example-box-wrapper">
            <div class="row">

                <div class="col-md-12">
                    <div id="demo-2" class="collapse" aria-expanded="true">
                                
                        <div class="">
                            <div class="form-horizontal pad15L pad15R bordered-row">

                                <div class="form-group remove-border">
                                                
                                    <div class="col-md-4">
                                        <div class="row">
                                            <label class="col-sm-4 control-label">
                                                Mensaje:
                                            </label>
                                            <div class="col-sm-8">
                                                <textarea id="email_message" name="email_message" rows="3" class="form-control textarea-no-resize" required></textarea>
                                            </div>
                                        </div>
                                    </div>
          
                                </div>

                            </div>

                            <div class="button-pane mrg20T">
                                <button class="btn btn-success">Guardar</button>
                            </div>
                        </div>

                    </div>
                </div>

            </div>
        </div>
        {!! Form::close() !!}

    </div>
</div>
@else
<div class="row">
    <div class="col-md-12">
        <div class="panel">
            <div class="panel-body">
                <h3 class="title-hero">
                    Notificaciones
                </h3>
                <div class="example-box-wrapper">
                    <div class="remove-columns">
                        <table class="table table-condensed table-striped">
                            <thead>
                                <tr>
                                    <th>Mensaje</th>
                                    <th>Acción</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($email_template as $email_templates)
                                <tr>
                                    <td data-title="Mensaje">{{$email_templates->email_message}}</td>
                                    <td data-title="Acción" class="tab-center">
                                        <a href="{{ action('EmailTemplateController@edit', $email_templates->id)}}">
                                            <i class="glyph-icon icon-pencil pad5R"></i>
                                        </a>
                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endif

@endsection