@extends('master')
@section('content')

<!--BREADCRUMB-->
<div class="row">
                
    <!--Sección-->
    <div class="col-md-9">
        <div id="page-title">
            <h2>Lista de guardias</h2>
            <p>Registra los guardias y sus horarios</p>
        </div>
    </div>
                
    <!--Fecha-->
    @include('date')
</div><!--BREADCRUMB END-->
@if ($errors->has('error'))
    <div class="alert alert-danger">
        <ul>    
            <li>{{ $errors->first('error') }}</li>         
        </ul>
    </div>                                             
@endif
@include('sessionmessage')         

<div class="panel">
    <div class="panel-body">
        <h3 class="title-hero">
            Agregar guardias
            <div class="header-buttons" style="padding-top:5px;">
                @if ($errors->has('error') || $errors->has('days') || $errors->has('name_guard')  || $errors->has('schedule'))
                    <a href="#" id="btnabrir" class="btn btn-md btn-danger" data-toggle="collapse" data-target="#demo-2" aria-expanded="true"><i id="iconagregar" class="glyph-icon icon-minus"></i></a>
                @else
                    @if($abierto == 1)
                         <a href="#" id="btnabrir" class="btn btn-md btn-danger" data-toggle="collapse" data-target="#demo-2" aria-expanded="true"><i id="iconagregar" class="glyph-icon icon-minus"></i></a>
                    @else
                        <a href="#" id="btnabrir" class="btn btn-md btn-danger collapsed" data-toggle="collapse" data-target="#demo-2" aria-expanded="true"><i id="iconagregar" class="glyph-icon icon-plus"></i></a>
                    @endif
                @endif
            </div>
        </h3>
        
        {!! Form::open(['method' => 'POST', 'action' => 'GuardInfoController@store', 'id' => 'formguardinfo']) !!}          
        <div class="example-box-wrapper">
            <div class="row">
                <div class="col-md-12">
                    @if ($errors->has('error') || $errors->has('days') || $errors->has('name_guard')  || $errors->has('schedule'))  
                        <div id="demo-2" class="collapse in" aria-expanded="true">     
                       
                    @else
                        @if($abierto == 1)
                            <div id="demo-2" class="collapse in" aria-expanded="true">  
                        @else
                            <div id="demo-2" class="collapse" aria-expanded="true">
                        @endif
                         
                    @endif
                                
                        <div class="form-horizontal pad15L pad15R bordered-row">

                            <div class="form-group remove-border">

                                <div class="col-md-4">
                                    <div class="row">
                                        <label class="col-sm-4 control-label">
                                            Nombre:*
                                        </label>
                                        <div class="col-sm-8 form-group{{ $errors->has('name_guard') ? ' has-error' : '' }}">
                                            <input type="text" class="form-control" id="name_guard" name="name_guard" value="{{old('name_guard')}}" maxlength="50" placeholder="Nombre del guardia..." required>
                                            @if ($errors->has('name_guard'))
                                              <span class="help-block">
                                                <strong>{{ $errors->first('name_guard') }}</strong>
                                              </span>
                                            @endif
                                        </div>
                                    </div>
                                </div>
                                        
                                <div class="col-md-4">
                                    <div class="row">
                                        <label class="col-sm-4 control-label">
                                            Teléfono:
                                        </label>
                                        <div class="col-sm-8 form-group{{ $errors->has('phone') ? ' has-error' : '' }}">
                                            <input type="text" class="form-control" id="phone" name="phone" value="{{old('phone')}}" pattern="^[0-9]{7,20}$" title="7-20 dígitos" maxlength="20" placeholder="Teléfono del guardia...">
                                            @if ($errors->has('phone'))
                                              <span class="help-block">
                                                <strong>{{ $errors->first('phone') }}</strong>
                                              </span>
                                            @endif
                                        </div>
                                    </div>
                                </div>

                            </div>

                            <div class="form-group">

                                <div class="row" id="daysadd" style="display:none;">
                                    <select id="days" name="" class="form-control">         
                                        <option value="">-Selecciona</option>
                                        @foreach($day as $days)
                                            <option value="{{$days->id}}">{{$days->days}}</option>
                                        @endforeach
                                    </select>
                                </div>

                                <div class="row">
                                    @if ($errors->has('error') || $errors->has('days') || $errors->has('name_guard')  || $errors->has('schedule'))
                                    
                                        @foreach(old('days') as $key => $d)
                                        <input type="hidden" value="{{$b++}}" />
                                        <div id="fieldguestc{{$b}}" class="row returnold">
                                            
                                            <div class="col-md-4 mrg10B">
                                                <div class="row">
                                                    <label for="" class="col-sm-4 col-md-4 control-label">Día:*</label>
                                                    <div class="col-sm-8 col-md-8 form-group{{ $errors->has('days') ? ' has-error' : '' }}" id="">
                                                        <select id="" name="days[]" class="form-control" required>
                                                            <option value="">-Selecciona</option>
                                                            @foreach($day as $days)
                                                                @if($days->id == $d)
                                                                    <option value="{{$days->id}}" selected>{{$days->days}}</option>
                                                                @else
                                                                    <option value="{{$days->id}}">{{$days->days}}</option>
                                                                @endif
                                                            @endforeach
                                                        </select>
                                                        @if ($errors->has('days'))
                                                          <span class="help-block">
                                                            <strong>{{ $errors->first('days') }}</strong>
                                                          </span>
                                                        @endif
                                                    </div>
                                                </div>
                                            </div>
  
                                            <div class="col-md-4 mrg10B">
                                                <div class="row">
                                                    <label for="" class="col-sm-4 col-md-5 control-label">Horario:* </label>
                                                    <div class="col-sm-8 col-md-7 form-group{{ $errors->has('schedule') ? ' has-error' : '' }}">
                                                        <input type="text" class="form-control" id="" name="schedule[]" placeholder="Ej. 8:00 am-8:00 pm" required>
                                                        @if ($errors->has('schedule'))
                                                          <span class="help-block">
                                                            <strong>{{ $errors->first('schedule') }}</strong>
                                                          </span>
                                                        @endif  
                                                    </div>
                                                </div>
                                            </div> 
                                            <div class="col-md-4">
                                                <div class="row">
                                                    <div class="col-sm-2">
                                                        <a href="#" class="btn btn-success" id="deletefieldc{{$b}}">
                                                            <i class="glyph-icon icon-times">
                                                            </i>
                                                        </a>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        @endforeach
                                        
                                        

                                        

                                    @else
                                        <div class="col-md-4 mrg10B">
                                            <div class="row">
                                                <label for="" class="col-sm-4 col-md-4 control-label">Día:*</label>
                                                <div class="col-sm-8 col-md-8 mrg0A form-group{{ $errors->has('days') ? ' has-error' : '' }}">
                                                    <select id="" name="days[]" class="form-control" required>
                                                        <option value="">-Selecciona</option>
                                                        @foreach($day as $days)
                                                            @if($days->id == old('days'))
                                                                <option value="{{$days->id}}" selected>{{$days->days}}</option>
                                                            @else
                                                                <option value="{{$days->id}}">{{$days->days}}</option>
                                                            @endif
                                                        @endforeach
                                                    </select>
                                                    @if ($errors->has('days'))
                                                      <span class="help-block">
                                                        <strong>{{ $errors->first('days') }}</strong>
                                                      </span>
                                                    @endif
                                                </div>
                                            </div>
                                        </div>

                                        <div class="col-md-4 mrg10B">
                                            <div class="row">
                                                <label class="col-sm-4 col-md-5 control-label">Horario:* <span class="bs-badge badge-info tooltip-button" data-toggle="tooltip" data-placement="top" title="Escribir el horario en el siguiente formato 0:00 (am-pm) - 0:00 (am-pm)">?</span></label>
                                                <div class="col-sm-8 col-md-7 form-group{{ $errors->has('schedule') ? ' has-error' : '' }}">
                                                    <input type="text" class="form-control" id="schedule" name="schedule[]" value="" placeholder="Ej. 8:00 am-8:00 pm" required>  
                                                    @if ($errors->has('schedule'))
                                                      <span class="help-block">
                                                        <strong>{{ $errors->first('schedule') }}</strong>
                                                      </span>
                                                    @endif
                                                </div>
                                            </div>
                                        </div>
                                        
                                    @endif

                                    <div class="col-md-4 mrg10B" id="btnag">
                                        <div class="row">
                                            <div class="col-sm-2">
                                                <a href="#" class="btn btn-success" id="btnaddd"><i class="glyph-icon icon-plus"></i></a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                    
                                <div class="row" id="adddaysshow">

                                   
                                
                                </div>


                               
                               

                            </div>


                            

                        </div>
                         <div class="row" >
                                <div class="col-md-12">
                                    <p style="font-size:12px;"><em>(*) Estos campos son requeridos.</em></p>
                                </div>
                            </div>
   
                            <div class="button-pane mrg20T">
                              
                                <button type="submit" class="btn btn-success">Agregar guardia</button>
                            </div>

                        
                                        
                    </div>
                </div>

            </div>
        </div>
        {!! Form::close() !!}
    </div>
</div>
                    
<div class="row">
    <div class="col-md-12">
                
        <div class="panel">
            <div class="panel-body">
                <h3 class="title-hero">
                    Guardias
                </h3>
                            
                <div class="example-box-wrapper">
                    @foreach($guard_info as $guard_infos)
                    <input type="hidden" value="{{$a++}}"/>
                        <div class="panel-group" id="accordionguard">
                            <div class="panel">
                                <div class="panel-heading">
                                    <h4 class="panel-title">
                                        <a data-toggle="collapse" data-parent="#accordion" href="#collapse{{$a}}">
                                            {{$guard_infos->name_guard}}
                                                <div class="float-right">
                                                   
                                                    <a href="{{ action('GuardInfoController@edit',$guard_infos->id)}}" class="icon-separator2">
                                                        <i class="glyph-icon icon-pencil"></i>
                                                    </a>

                                                    <a href="#" class="icon-separator2" id="btndeleteguard{{$a}}" value="{{$guard_infos->id}}" data-toggle="modal" data-target="#deleteguard">
                                                        <i class="glyph-icon icon-trash"></i>
                                                    </a>
                                                </div>
                                        </a>
                                    </h4>
                                </div>
                                @if($a == 1)
                                    <div id="collapse{{$a}}" class="panel-collapse collapse in">
                                @else
                                    <div id="collapse{{$a}}" class="panel-collapse collapse">
                                @endif
                                    <div class="panel-body">
                                        <div class="row">
                                            <div class="col-md-12">
                                                <table cellpadding="0" cellspacing="0" border="0" class="table table-striped table-condensed">
                                                    <thead>
                                                        <tr>
                                                            <th class="tab-center">Día</th>
                                                            <th class="tab-center">Horario</th>
                                                        </tr>
                                                    </thead>

                                                    <tbody>
                                                        @foreach($guard_s as $guard)
                                                            @if($guard->guard_id == $guard_infos->id)
                                                                <tr>
                                                                    <td class="va-tab">
                                                                        <input type="text" class="form-control" id="" placeholder="Lunes" value="{{$guard->days}}" disabled>
                                                                    </td>
                                                                    <td class="tab-center">
                                                                        <input type="text" class="form-control" id="" placeholder="{{$guard->schedule}}" disabled>
                                                                    </td>
                                                                </tr>
                                                            @endif
                                                        @endforeach     
                                                    </tbody>
                                                </table>
                                            </div>
                                            <!--<div class="col-md-6">
                                                <table cellpadding="0" cellspacing="0" border="0" class="table table-striped table-condensed">
                                                    <thead>
                                                        <tr>
                                                            <th class="tab-center">Día</th>
                                                            <th class="tab-center">Horario</th>
                                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                        <tr>
                                                            <td class="va-tab">
                                                                <input type="text" class="form-control" id="" placeholder="Jueves" disabled>
                                                            </td>
                                                            <td class="tab-center">
                                                                <input type="text" class="form-control" id="" placeholder="8:00 - 20:00" disabled>
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <td class="va-tab">
                                                                <input type="text" class="form-control" id="" placeholder="Viernes" disabled>
                                                            </td>
                                                            <td class="tab-center">
                                                                <input type="text" class="form-control" id="" placeholder="8:00 - 20:00" disabled>
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <td class="va-tab">
                                                                <input type="text" class="form-control" id="" placeholder="Sábado" disabled>
                                                            </td>
                                                            <td class="tab-center">
                                                                <input type="text" class="form-control" id="" placeholder="8:00 - 20:00" disabled>
                                                            </td>
                                                        </tr>
                                                    </tbody>
                                                </table>
                                            </div>-->
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    @endforeach
                </div>
                            
            </div>

        </div>
                            
    </div>
</div>

@include('footer')

<script type="text/javascript" src="../../../assets/widgets/accordion-ui/accordion.js"></script>
<script type="text/javascript">
    /* jQuery UI Accordion */

    $(function() { "use strict";
        $(".accordion").accordion({
            heightStyle: "content"
        });
    });

    $(function() { "use strict";
        $("#accordion-hover")
                .accordion({
                    event: 'mouseover',
                    heightStyle: 'auto'
                });
    });
</script>
{!! Html::script('js/guardinfo.js') !!}

<!--- VENTANA MODAL CONFIRMAR ELIMINAR ======-->
<div id="deleteguard" class="modal fade ag-img" tabindex="-1" role="dialog" aria-labelledby="myLargeModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-md">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
                    <h4 class="modal-title">Eliminar guardia</h4>
            </div>
            <div class="modal-body">

                @if(empty($guard_infos))

                @else
                {!! Form::open(['method' => 'DELETE', 'action' => ['GuardInfoController@destroy', $guard_infos->id]]) !!}
                    <input type="hidden" id="deleteguardid" name="id" value="">  
                    <p style="padding-left:20px; padding-right:20px;">¿Esta seguro que desea eliminar este guardia?</p>

            </div>
            <div class="modal-footer">
              
                <button type="submit" class="btn btn-default">Eliminar</button>
                {!! Form::close()!!}
                @endif
            </div>
        </div>
    </div>
</div>
<!--- TERMINA VENTANA MODAL CONFIRMAR ELIMINAR ======--> 

@endsection