@extends('master')
@section('content')

<style>
.form-control[readonly]
{
    cursor:pointer!important;
}
.manita
{
    cursor:pointer;
}
</style>
<!--BREADCRUMB-->
<div class="row">
                
    <!--Sección-->
    <div class="col-md-9">
        <div id="page-title">
            <h2>Mensaje de inicio</h2>
            <p>Muestra a todos los residentes un mensaje en el dashboard</p>
        </div>
    </div>
                
    <!--Fecha-->
    @include('date')           

</div><!--BREADCRUMB END-->


<div class="panel">
    <div class="panel-body">
        <h3 class="title-hero">
            Editar mensaje de inicio   
        </h3>
            
        {!! Form::model($popup , ['method' => 'PATCH', 'action' => ['PopupController@update', $popup->id]]) !!}     
            <div class="example-box-wrapper">
                <div class="row">

                    <div class="col-md-12">
                           
                        <div class="">
                            <div class="form-horizontal pad15L pad15R bordered-row">

                                <div class="form-group remove-border">
                                                
                                    <div class="col-md-4">
                                        <div class="row">
                                            <label class="col-sm-4 control-label">
                                                Mensaje:*
                                            </label>
                                            <div class="col-sm-8 form-group{{ $errors->has('popup_message') ? ' has-error' : '' }}">
                                                <textarea  rows="3" class="form-control textarea-no-resize" name="popup_message" required>{{$popup->popup_message}}</textarea>
                                                @if ($errors->has('popup_message'))
                                                  <span class="help-block">
                                                    <strong>{{ $errors->first('popup_message') }}</strong>
                                                  </span>
                                                @endif
                                            </div>
                                        </div>
                                    </div>
                                                
                                    <div class="col-md-4">
                                        <div class="row">
                                            <label class="col-sm-4 control-label">
                                                Fecha de inicio:*
                                            </label>
                                            <div class="col-sm-8 form-group{{ $errors->has('start') ? ' has-error' : '' }}">
                                                <div class="input-prepend input-group">
                                                    <span class="add-on input-group-addon">
                                                        <i class="glyph-icon icon-calendar"></i>
                                                    </span>
                                                    <input type="text" class="bootstrap-datepicker form-control manita" value="{{$popup->start}}" id="start" name="start" {!! $datesvalidation !!} title="aaaa-mm-dd" required>
                                                </div>
                                                @if ($errors->has('start'))
                                                  <span class="help-block">
                                                    <strong>{{ $errors->first('start') }}</strong>
                                                  </span>
                                                @endif
                                            </div>
                                        </div>
                                    </div>
                                                
                                    <div class="col-md-4">
                                        <div class="row">
                                            <label class="col-sm-4 control-label">
                                                Fecha final:*
                                            </label>
                                            <div class="col-sm-8 form-group{{ $errors->has('end') ? ' has-error' : '' }}">
                                                <div class="input-prepend input-group">
                                                    <span class="add-on input-group-addon">
                                                        <i class="glyph-icon icon-calendar"></i>
                                                    </span>
                                                    <input type="text" class="bootstrap-datepicker form-control manita" value="{{$popup->end}}" id="end" name="end" {!! $datesvalidation !!} title="aaaa-mm-dd" required>
                                                </div>
                                                @if ($errors->has('end'))
                                                  <span class="help-block">
                                                    <strong>{{ $errors->first('end') }}</strong>
                                                  </span>
                                                @endif
                                            </div>
                                        </div>
                                    </div>
                                            
                                                
                                </div>

                            </div>

                            <div class="row" >
                                    <div class="col-md-12">
                                        <p style="font-size:12px;"><em>(*) Estos campos son requeridos.</em></p>
                                    </div>
                                </div>

                            <div class="button-pane mrg20T">
                                <button href="{{url('configuration/popup')}}" class="btn btn-default">Cancelar</button>
                                <button class="btn btn-success">Guardar</button>
                            </div>
                        </div>

                        
                    </div>
                
                </div>
            </div>
        {!! Form::close() !!}
    </div>
</div>
<script>
$(document).ready(function() { 

    $('#start').datepicker({
    
        minDate: '0d',
    
    });

    $('#end').datepicker({
    
        minDate: '0d',
    
    });

    $('#start').keypress(function(tecla){
    
       if(tecla.charCode < 48 || tecla.charCode > 57)return false;
       if ((tecla.charCode < 97 || tecla.charCode > 122)//letras mayusculas
                && (tecla.charCode < 65 || tecla.charCode > 90) //letras minusculas
                && (tecla.charCode != 45) //retroceso
                && (tecla.charCode != 241) //ñ
                 && (tecla.charCode != 209) //Ñ
                 && (tecla.charCode != 32) //espacio
                 && (tecla.charCode != 225) //á
                 && (tecla.charCode != 233) //é
                 && (tecla.charCode != 237) //í
                 && (tecla.charCode != 243) //ó
                 && (tecla.charCode != 250) //ú
                 && (tecla.charCode != 193) //Á
                 && (tecla.charCode != 201) //É
                 && (tecla.charCode != 205) //Í
                 && (tecla.charCode != 211) //Ó
                 && (tecla.charCode != 218) //Ú
 
              )
        return false; 

    });

    $('#end').keypress(function(tecla){
    
       if(tecla.charCode < 48 || tecla.charCode > 57)return false;
       if ((tecla.charCode < 97 || tecla.charCode > 122)//letras mayusculas
                && (tecla.charCode < 65 || tecla.charCode > 90) //letras minusculas
                && (tecla.charCode != 45) //retroceso
                && (tecla.charCode != 241) //ñ
                 && (tecla.charCode != 209) //Ñ
                 && (tecla.charCode != 32) //espacio
                 && (tecla.charCode != 225) //á
                 && (tecla.charCode != 233) //é
                 && (tecla.charCode != 237) //í
                 && (tecla.charCode != 243) //ó
                 && (tecla.charCode != 250) //ú
                 && (tecla.charCode != 193) //Á
                 && (tecla.charCode != 201) //É
                 && (tecla.charCode != 205) //Í
                 && (tecla.charCode != 211) //Ó
                 && (tecla.charCode != 218) //Ú
 
              )
        return false; 

    });
});

</script>

@endsection