@extends('master')
@section('content')

{!! Html::style('vendor/bootstrap-colorpicker/css/bootstrap-colorpicker.min.css') !!}
@include('date')

         <div class="col-md-10">
            <div class="col-md-12" style="background-color:#fff; padding:10px 20px; margin-bottom:10px;">
                <span class="caption-subject" style="float: left; display: inline-block; padding: 12px 0;">Crear area social</span>

            
                <div class="actions">
                    <div class="btn-group">
                            
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-md-12">
                    @if (count($errors) > 0)
                        <div class="alert alert-danger">
                            <ul>
                                @foreach ($errors->all() as $error)
                                    <li>{{ $error }}</li>
                                 @endforeach
                            </ul>
                            </div>
                         @endif
                    </div>
                </div>
                <div class="row">
                            <div class="col-md-12">
                                @if (Session::has('message'))
                                    <div class="alert alert-danger">
                                        <p>
                                           {{ Session::get('message') }}
                                        </p>
                                    </div>
                                @endif
                            </div>
                        </div>
                <div class="col-md-12" style="background-color:#fff; padding:30px; margin-bottom:20px;">
                    <div class="portlet">
                        <div class="portlet-title">
                            <div class="caption">
                                <span class=""> </span>
                            </div>
                        </div>
                    {!! Form::open(['method' => 'POST', 'action' => 'SocialAreaController@store', 'enctype' => 'multipart/form-data' , 'id' => 'formsocialarea']) !!}
                        <div class="col-lg-12 col-md-12 login-container bs-reset">
                    <div class="login-content">
                        <form action="javascript:;" class="login-form" method="post">
                            <div class="row">
                                <div class="col-md-4 col-sm-4">
                                    <div class="form-group form-md-line-input has-info form-md-floating-label">
                                        <div class="input-group left-addon">
                                            <label for="form_control_1">Nombre área social</label>
                                            <input type="text" autocomplete="off" id="name_social_area" name="name_social_area" maxlength="50" class="form-control" required>
                                                
                                            @if ($errors->has('name_social_area'))
                                                <span class="help-block">
                                                    <strong>{{ $errors->first('name_social_area') }}</strong>
                                                </span>
                                            @endif
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-4 col-sm-4">
                                    <div class="form-group form-md-line-input has-info form-md-floating-label">
                                        <div class="input-group left-addon">
                                            <label for="form_control_1">Reglamento</label>
                                            <input type="file" autocomplete="off" id="file" name="file" class="form-control">
                                                
                                             @if ($errors->has('file'))
                                                <span class="help-block">
                                                    <strong>{{ $errors->first('file') }}</strong>
                                                </span>
                                            @endif
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-4 col-sm-4">
                                    <label for="form_control_1">Días que se puede reservar</label>
                                        <div class="input-group left-addon">
                                            <label>Lunes</label>
                                            <input type="checkbox" id="monday" name="monday">
                                        </div>
                                        <div class="input-group left-addon">
                                            <label>Martes</label>
                                            <input type="checkbox" id="tuesday" name="tuesday">
                                        </div>
                                        <div class="input-group left-addon">
                                                <label>Miércoles</label> 
                                                <!-- #Cambio wednsday por wendsday -->
                                                <input type="checkbox" id="wendsday" name="wendsday">
                                        </div>
                                        <div class="input-group left-addon">
                                                <label>Jueves</label>
                                                <input type="checkbox" id="thursday" name="thursday">
                                        </div>
                                        <div class="input-group left-addon">
                                                <label>Viernes</label>
                                                <input type="checkbox" id="friday" name="friday">
                                        </div>
                                        <div class="input-group left-addon">
                                                <label>Sabádo</label>
                                                <input type="checkbox" id="saturday" name="saturday">
                                        </div>
                                        <div class="input-group left-addon">
                                                <label>Domingo</label>
                                                <input type="checkbox" id="sunday" name="sunday">
                                        </div>
                                 
                                    
                                </div>
                                
                                <div class="col-md-4 col-sm-4">
                                    <div class="form-group form-md-line-input has-info form-md-floating-label">
                                        <div class="input-group left-addon">
                                            <label for="form_control_1">Cuota</label>
                                            <input type="text" autocomplete="off" id="cost" name="cost" maxlength="50"  pattern="^([0-9]*)|([0-9]*\.?[0-9]{2})$" title="solo numeros, decimal solo 2" class="form-control">
                                                
                                             @if ($errors->has('cost'))
                                                <span class="help-block">
                                                    <strong>{{ $errors->first('cost') }}</strong>
                                                </span>
                                            @endif
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-4 col-sm-4">
                                    <div class="form-group form-md-line-input has-info form-md-floating-label">
                                        <div class="input-group left-addon">
                                            <label for="form_control_1">Días que permanece la reserva</label>
                                            <input type="text" autocomplete="off" id="days_reserve_stay" name="days_reserve_stay" maxlength="2" class="form-control" >
                                                
                                             @if ($errors->has('days_reserve_stay'))
                                                <span class="help-block">
                                                    <strong>{{ $errors->first('days_reserve_stay') }}</strong>
                                                </span>
                                            @endif
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-4 col-sm-4">
                                    <!--<div class="form-group form-md-line-input has-info form-md-floating-label">
                                        <div class="input-group left-addon">
                                            <input type="color" autocomplete="off" name="color" id="color" class="form-control" required>
                                                <label for="form_control_1">Color</label>
                                             @if ($errors->has('color'))
                                                <span class="help-block">
                                                    <strong>{{ $errors->first('color') }}</strong>
                                                </span>
                                            @endif
                                        </div>
                                    </div>-->
                                             <label for="form_control_1">Color</label>
                                            <div class="input-group colorpicker">
                                                <input type="text" colorpicker="hex" name="color" class="form-control" required/>
                                                <span class="input-group-addon"></span>  
                                            </div>
                                           
                                            @if ($errors->has('color'))
                                                <span class="help-block">
                                                    <strong>{{ $errors->first('color') }}</strong>
                                                </span>
                                            @endif
                                        </div>
                                    </div>
                                    <script>
                                        $(document).ready(function() {
                                           
                                            $('.colorpicker').colorpicker({
                                                
                                                format: 'hex'
                                            });
                                        });
                                    </script>
                                </div>
                            </div>
                                <div class="row">
                                    <div class="col-md-12">
                                        <button type="submit" class="btn btn-success">Guardar</button>
                                    </div>
                                </div>
                    {!! Form::close() !!}
                            
                    
                    </div>
                </div>

      
            </div>
        </div>
        </div>
    
		

	</div>

</div>

{!! Html::script('vendor/bootstrap-colorpicker/js/bootstrap-colorpicker.min.js') !!}
<script>
    $('#days_reserve_stay').keypress(function(tecla){

        if(tecla.charCode < 48 || tecla.charCode > 57)return false; 

    });

    $('#cost').keypress(function(evt){
        //if(tecla.charCode < 48 || tecla.charCode > 57) return false;
        var charCode = (evt.which) ? evt.which : evt.keyCode;
        if (charCode != 46 && charCode > 31 && (charCode < 48 || charCode > 57))
        return false;
        //return true;
    });

</script>

@endsection