@extends('master')
@section('content')
<style>
.manita
{
    cursor:pointer;
}
</style>

{!! Html::style('vendor/bootstrap-colorpicker/css/bootstrap-colorpicker.min.css') !!}
<!--BREADCRUMB-->
<div class="row">
                
    <!--Sección-->
    <div class="col-md-9">
        <div id="page-title">
            <h2>Área social</h2>
            <p>Da de alta las áreas sociales del residencial</p>
        </div>
    </div>
                
    <!--Fecha-->
    @include('date')  

</div><!--BREADCRUMB END-->
            
@if ($errors->has('error'))
    <div class="alert alert-danger">
        <ul>    
            <li>{{ $errors->first('error') }}</li>         
        </ul>
    </div>                                             
@endif

<div class="panel">
    <div class="panel-body">
        <h3 class="title-hero">
            Alta de áreas sociales
            <div class="header-buttons" style="padding-top:5px;">
                @if ($errors->has('error') || $errors->has('name_social_area') || $errors->has('file') || $errors->has('cost') || $errors->has('days_reserve_stay') 
                || $errors->has('color'))
                    <a href="#" id="btnabrir" class="btn btn-md btn-danger" data-toggle="collapse" data-target="#demo-2" aria-expanded="true"><i id="iconagregar" class="glyph-icon icon-minus"></i></a>
                @else
                    @if($abierto == 1)
                        <a href="#" id="btnabrir" class="btn btn-md btn-danger" data-toggle="collapse" data-target="#demo-2" aria-expanded="true"><i id="iconagregar" class="glyph-icon icon-minus"></i></a>
                    @else
                        <a href="#" id="btnabrir" class="btn btn-md btn-danger collapsed" data-toggle="collapse" data-target="#demo-2" aria-expanded="true"><i id="iconagregar" class="glyph-icon icon-plus"></i></a>
                    @endif
                @endif
            </div>
        </h3>
                    
        <div class="example-box-wrapper">
            <div class="row">
                {!! Form::open(['method' => 'POST', 'action' => 'SocialAreaController@store', 'enctype' => 'multipart/form-data' , 'id' => 'formsocialarea']) !!}
                <div class="col-md-12">
                    @if ($errors->has('error') || $errors->has('name_social_area') || $errors->has('file') || $errors->has('cost') || $errors->has('days_reserve_stay') 
                    || $errors->has('color'))
                        <div id="demo-2" class="collapse in" aria-expanded="true">
                    @else
                        @if($abierto == 1)
                            <div id="demo-2" class="collapse in" aria-expanded="true">
                        @else
                            <div id="demo-2" class="collapse" aria-expanded="true">
                        @endif
                    @endif
                                
                        <div class="">
                            <div class="form-horizontal pad15L pad15R bordered-row">

                                <div class="form-group remove-border">

                                    <div class="col-md-4">
                                        <div class="row">
                                            <label class="col-sm-4 control-label">
                                                Nombre del área social:*
                                            </label>
                                            <div class="col-sm-8 form-group{{ $errors->has('name_social_area') ? ' has-error' : '' }}">
                                                <input type="text" class="form-control" id="name_social_area" name="name_social_area" value="{{old('name_social_area')}}" maxlength="30" placeholder="Nombre del área social..." onkeypress="return pulsar(event)" required>
                                                @if ($errors->has('name_social_area'))
                                                  <span class="help-block">
                                                    <strong>{{ $errors->first('name_social_area') }}</strong>
                                                  </span>
                                                @endif
                                            </div>
                                        </div>
                                    </div>
                                    
                                    <!-- #Agrega el checkbox para limitar eventos por casa -->
                                    <div class="col-md-4">
                                        <div class="row">
                                            <label class="col-sm-4 control-label">
                                                Limite mensual de área social:*
                                            </label>
                                            <div class="col-sm-8">
                                                <div class="col-sm-9 ">
                                                    <label class="checkbox-inline">
                                                        @if(old('sunday') == "option8")
                                                            <input type="checkbox" id="limit_event" name="limit_event" value="option8" onkeypress="return pulsar(event)" checked>
                                                        @else
                                                            <input type="checkbox" id="limit_event" name="limit_event" onkeypress="return pulsar(event)" value="option8">
                                                        @endif
                                                        Activar/Desactivar
                                                    </label>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                                
                                    <div class="col-md-4 col-md-offset-4">
                                        <div class="row">
                                            <label class="col-sm-4 control-label">
                                                <span class="bs-badge badge-info tooltip-button" data-toggle="tooltip" data-placement="top" title="Se pueden subir archivos: jpg, jpeg ,png y pdf.Tamaño maximo del archivo 5 mb.">?</span>
                                            </label>
                                            <div class="col-sm-8 form-group{{ $errors->has('file') ? ' has-error' : '' }}">
                                                <div class="fileinput fileinput-new" data-provides="fileinput">
                                                    <span class="btn btn-default btn-file">
                                                    <span class="fileinput-new"><i class="glyph-icon icon-paperclip"></i>Reglamento</span>
                                                    <span class="fileinput-exists">Cambiar</span>
                                                        <input type="file" id="file" name="file" value="{{old('file')}}" onkeypress="return pulsar(event)" accept="application/pdf,image/jpg,image/jpeg,image/png">
                                                    </span>
                                                    <span class="fileinput-filename"></span>
                                                    <a href="#" class="close fileinput-exists" data-dismiss="fileinput" style="float: none">×</a>
                                                </div>
                                                @if ($errors->has('file'))
                                                  <span class="help-block">
                                                    <strong>{{ $errors->first('file') }}</strong>
                                                  </span>
                                                @endif
                                                <input type="hidden" id="imageName" name="imageName" value=""/>
                                                <input type="hidden" id="contentType" name="contentType" value=""/>
                                                <input type="hidden" id="imageData" name="imageData" value=""/>
                                                <input type="hidden" id="sizeData" name="sizeData" value=""/>
                                            </div>
                                        </div>
                                    </div>
                                                
                                </div>
                                            
                                <div class="form-group">

                                    <div class="col-md-4">
                                        <div class="row">
                                            <label class="col-sm-4 control-label">
                                                <span class="bs-badge badge-info tooltip-button" data-toggle="tooltip" data-placement="top" title="Si el área social no tiene cuota colocar 0">?</span> Cuota:*</label>
                                                <div class="col-sm-8 form-group{{ $errors->has('cost') ? ' has-error' : '' }}">
                                                    <input type="text" class="form-control" id="cost" name="cost" value="{{old('cost')}}" maxlength="8"  pattern="^([0-9]*)|([0-9]*\.?[0-9]{2})$" min="0" title="solo numeros, decimal solo 2" onkeypress="return pulsar(event)" placeholder="Cuota..." required>
                                                    @if ($errors->has('cost'))
                                                      <span class="help-block">
                                                        <strong>{{ $errors->first('cost') }}</strong>
                                                      </span>
                                                    @endif
                                                    <div id="montoregex" style="display:none;color:#FF0000;">
                                                        <strong>solo numeros, solo 2 decimales.</strong>
                                                    </div>
                                                </div>
                                        </div>
                                    </div>
                                                
                                    <div class="col-md-4">
                                        <div class="row">
                                            <label class="col-sm-4 control-label">
                                                <span class="bs-badge badge-info tooltip-button" data-toggle="tooltip" data-placement="top" title="Colocar cuantos días tiene el residente para pagar la cuota antes de que se libere la reservación">?</span> Días para pagar:</label>
                                            <div class="col-sm-8 form-group{{ $errors->has('days_reserve_stay') ? ' has-error' : '' }}">
                                                <input type="text" class="form-control" id="days_reserve_stay" name="days_reserve_stay" value="{{old('days_reserve_stay')}}" pattern="^[0-9]{1,2}$" title="máximo dos digitos" maxlength="2" onkeypress="return pulsar(event)" placeholder="Días que permanece la reservación...">
                                                @if ($errors->has('days_reserve_stay'))
                                                    <span class="help-block">
                                                        <strong>{{ $errors->first('days_reserve_stay') }}</strong>
                                                    </span>
                                                @endif
                                                
                                            </div>
                                        </div>
                                    </div>
                                                
                                    <div class="col-md-4">
                                        <div class="row">
                                            <label for="" class="col-sm-3 control-label">
                                                Color:*
                                            </label>
                                                <div class="col-sm-9 form-group{{ $errors->has('color') ? ' has-error' : '' }}">
                                                  
                                                        <div style="display:inline-block"/>
                                                            <button type="button" class="btn btn-default" style="background-color:#FEFEFF;display:inline-block;" id="cp4" >Da clic</button>
                                                        </div>
                                                        <div  style="display:inline-block"/>
                                                            <input id="cp1" type="text" style="display:inline-block;"  class="form-control" name="color" value="{{old('color')}}" placeholder="Selecciona el color.." required/>
                                                        </div>
                                               
                                                    @if ($errors->has('color'))
                                                      <span class="help-block">
                                                        <strong>{{ $errors->first('color') }}</strong>
                                                      </span>
                                                    @endif
                                                   
                                                    
                                                </div>

                                               
                                                    <script>
                                                        $(function() {
                                                            
                                                            $('#cp4').colorpicker({
                                                                                                
                                                                format: 'hex',

                                                            });
                                                            $('#cp4').colorpicker().on('changeColor', function(e) {
                                                                
                                                                $("#cp4").css("background-color",e.color.toString('hex'));
                                                                $("#cp1").attr("value",e.color.toString('hex'));

                                                            });
                                                        });
                                                    </script>
                                                <!--<script>
                                                    $(document).ready(function() {
                                               
                                                        /*$('.colorpicker').colorpicker({
                                                                                                
                                                            format: 'hex',

                                                        });*/
                                                        $("#cp1").colorpicker({
                                                                                                
                                                            format: 'hex',

                                                        });
                                                    });
                                                </script>-->
                                        </div>
                                    </div>
                                                
                                </div>
                                
                                <!--#Areas Sociales para multiples casas-->
                                <div class="form-group">
                                    
                                    <div class="col-md-4">
                                        <div class="row">
                                            <label class="col-sm-4 control-label">
                                                No. de casas que pueden rentar:*
                                            </label>
                                            <!--Cambiar errores-->
                                            <div class="col-sm-8 form-group{{ $errors->has('name_social_area') ? ' has-error' : '' }}">
                                                @if(old('cant_casas'))
                                                    <input type="input" class="form-control" id="cant_casas" name="cant_casas" value="{{old('cant_casas')}}" pattern="^([0-9]*)|([0-9]*\.?[0-9]{2})$" title="solo numeros, decimal solo 2" maxlength="12" required>
                                                @else
                                                    <input type="input" class="form-control" id="cant_casas" name="cant_casas" value="1" pattern="^([0-9]*)|([0-9]*\.?[0-9]{2})$" title="solo numeros, decimal solo 2" maxlength="12">
                                                    
                                                @endif
                                                <!--Cambiar errores-->
                                                @if ($errors->has('amount_charge'))
                                                    <span class="help-block">
                                                        <strong>{{ $errors->first('amount_charge') }}</strong>
                                                    </span>
                                                @endif
                                            </div>
                                        </div>
                                    </div>
                                    
                                    <div class="col-md-4">
                                        <div class="row">
                                            <label class="col-sm-4 control-label">
                                                Limite de aforo:
                                            </label>
                                            <!--Cambiar errores-->
                                            <div class="col-sm-8 form-group{{ $errors->has('name_social_area') ? ' has-error' : '' }}">
                                                @if(old('limit_aforo'))
                                                    <input type="input" class="form-control" id="limit_aforo" name="limit_aforo" value="{{old('limit_aforo')}}" pattern="^([0-9]*)|([0-9]*\.?[0-9]{2})$" title="solo numeros, decimal solo 2" maxlength="12">
                                                @else
                                                    <input type="input" class="form-control" id="limit_aforo" name="limit_aforo" value="0" pattern="^([0-9]*)|([0-9]*\.?[0-9]{2})$" title="solo numeros, decimal solo 2" maxlength="12">
                                                    
                                                @endif
                                                <!--Cambiar errores-->
                                                @if ($errors->has('amount_charge'))
                                                    <span class="help-block">
                                                        <strong>{{ $errors->first('amount_charge') }}</strong>
                                                    </span>
                                                @endif
                                            </div>
                                        </div>
                                    </div>
                                    
                                    <div class="col-md-4">
                                        <div class="row">
                                            <label class="col-sm-4 control-label">
                                                Limite de asistentes:
                                            </label>
                                            <!--Cambiar errores-->
                                            <div class="col-sm-8 form-group{{ $errors->has('name_social_area') ? ' has-error' : '' }}">
                                                @if(old('limit_asist'))
                                                    <input type="input" class="form-control" id="limit_asist" name="limit_asist" value="{{old('limit_asist')}}" pattern="^([0-9]*)|([0-9]*\.?[0-9]{2})$" title="solo numeros, decimal solo 2" maxlength="12">
                                                @else
                                                    <input type="input" class="form-control" id="limit_asist" name="limit_asist" value="0" pattern="^([0-9]*)|([0-9]*\.?[0-9]{2})$" title="solo numeros, decimal solo 2" maxlength="12">
                                                    
                                                @endif
                                                <!--Cambiar errores-->
                                                @if ($errors->has('amount_charge'))
                                                    <span class="help-block">
                                                        <strong>{{ $errors->first('amount_charge') }}</strong>
                                                    </span>
                                                @endif
                                            </div>
                                        </div>
                                    </div>
                                    
                                </div>
                                                
                                <div class="form-group">
                                                    
                                    <label class="col-sm-3 control-label">Días que se puede reservar:*</label>
                                        <div class="col-sm-9 ">
                                            <label class="checkbox-inline">
                                                @if(old('monday') == "option1")
                                                    <input type="checkbox" id="monday" name="monday" value="option1" onkeypress="return pulsar(event)" checked>
                                                @else
                                                    <input type="checkbox" id="monday" name="monday" onkeypress="return pulsar(event)" value="option1">
                                                @endif
                                                Lunes
                                            </label>
                                            <label class="checkbox-inline">
                                                @if(old('tuesday') == "option2")
                                                    <input type="checkbox" id="tuesday" name="tuesday" value="option2" onkeypress="return pulsar(event)" checked>
                                                @else
                                                    <input type="checkbox" id="tuesday" name="tuesday" onkeypress="return pulsar(event)" value="option2">
                                                @endif
                                                Martes
                                            </label>
                                            <label class="checkbox-inline">
                                                <!-- #Cambio wednsday por wendsday -->
                                                @if(old('wendsday') == "option3")
                                                    <input type="checkbox" id="wendsday" name="wendsday" value="option3" onkeypress="return pulsar(event)" checked>
                                                @else
                                                    <input type="checkbox" id="wendsday" name="wendsday" onkeypress="return pulsar(event)" value="option3">
                                                @endif
                                                Miércoles
                                            </label>
                                            <label class="checkbox-inline">
                                                @if(old('thursday') == "option4")
                                                    <input type="checkbox" id="thursday" name="thursday" value="option4" onkeypress="return pulsar(event)" checked>
                                                @else
                                                    <input type="checkbox" id="thursday" name="thursday" onkeypress="return pulsar(event)" value="option4">
                                                @endif
                                                Jueves
                                            </label>
                                            <label class="checkbox-inline">
                                                @if(old('friday') == "option5")
                                                    <input type="checkbox" id="friday" name="friday" value="option5" onkeypress="return pulsar(event)" checked>
                                                @else
                                                    <input type="checkbox" id="friday" name="friday" onkeypress="return pulsar(event)" value="option5">
                                                @endif
                                                Viernes
                                            </label>
                                            <label class="checkbox-inline">
                                                @if(old('saturday') == "option6")
                                                    <input type="checkbox" id="saturday" name="saturday" value="option6" onkeypress="return pulsar(event)" checked>
                                                @else
                                                    <input type="checkbox" id="saturday" name="saturday" onkeypress="return pulsar(event)" value="option6">
                                                @endif
                                                Sábado
                                            </label>
                                            <label class="checkbox-inline">
                                                @if(old('sunday') == "option7")
                                                    <input type="checkbox" id="sunday" name="sunday" value="option7" onkeypress="return pulsar(event)" checked>
                                                @else
                                                    <input type="checkbox" id="sunday" name="sunday" onkeypress="return pulsar(event)" value="option7">
                                                @endif
                                                Domingo
                                            </label>
                                        </div>
                            
                                </div>

                            </div>
                        </div>

                        <div class="row" >
                                <div class="col-md-12">
                                    <p style="font-size:12px;"><em>(*) Estos campos son requeridos.</em></p>
                                </div>
                            </div>

                        <div class="button-pane mrg20T">
                            
                            <!--#Ocultar Area Social-->
                            <div class="group">
                                <div class="col-md-4">
                                    <div class="row">
                                        <label class="col-sm-4 control-label">
                                            Ocultar Area social:
                                        </label>
                                        <div class="col-sm-8">
                                            <div class="col-sm-9 ">
                                                <label class="checkbox-inline">
                                                    @if(old('ocult_area') == "1")
                                                        <input type="checkbox" id="ocult_area" name="ocult_area" checked>
                                                    @else
                                                        <input type="checkbox" id="ocult_area" name="ocult_area">
                                                    @endif
                                                    Ocultar/No ocultar
                                                </label>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <!--#Fin Ocultar Area Social-->
                            
                            <button type="button" id="acept_area" class="btn btn-success">Agregar área social</button>
                            <div style="display:none;">
                                 <button type="submit" id="acept" class="btn btn-success"></button>
                            </div>
                        </div>
                    </div>

                </div>
                {!! Form::close() !!}
            </div>

        </div>
    </div>
</div>
            

<div class="row">
    <div class="col-md-12">
        <div class="panel">
            <div class="panel-body">
                <h3 class="title-hero">
                    Áreas sociales
                </h3>
                <div class="example-box-wrapper">
                    <div class="remove-columns">
                        <table class="table table-condensed table-striped">
                            <thead>
                                <tr>
                                    <th>Área social</th>
                                    <th class="tab-center">Días para reservar</th>
                                    <th class="tab-center">Cuota</th>
                                    <th class="tab-center">Días para pagar</th>
                                    <th class="tab-center">Reglamento</th>
                                    <th class="tab-center">Color</th>
                                    <th class="tab-center">Área oculta</th>
                                    <th class="tab-center"></th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($social_area as $social_areas)
                                <tr id="trsarea">
                                    <td data-title="Área social">{{$social_areas->name_social_area}}</td>
                                    <td data-title="Días para reservar" class="tab-center">
                                        @if($social_areas->monday == 1)
                                            Lu-
                                        @endif
                                        @if($social_areas->tuesday == 1)
                                            M-
                                        @endif
                                        @if($social_areas->wendsday == 1)
                                            Mi-
                                        @endif
                                        @if($social_areas->thursday == 1)
                                            Ju-
                                        @endif
                                        @if($social_areas->friday == 1)
                                            Vi-
                                        @endif
                                        @if($social_areas->saturday == 1)
                                            Sá-
                                        @endif
                                        @if($social_areas->sunday == 1)
                                            Do
                                        @endif
                                    </td>
                                    <td data-title="Cuota" class="tab-center">${{$balance  = number_format($social_areas->cost, 2, '.', ',')}}&nbsp;</td>
                                    <td data-title="Días para pagar" class="tab-center">{{$social_areas->days_reserve_stay}}&nbsp;</td>
                                    <td data-title="Reglamento" class="tab-center">
                                        @if(empty($social_areas->url_file))
                                             <button  class="btn btn-xs btn-info" disabled><i class="glyph-icon icon-eye"></i></button>                  
                                        @else
                                            <button href="javascript:;" onClick="MM_openBrWindow('{{$social_areas->url_file}}','','scrollbars=yes,resizable=yes,width=800,height=600')" class="btn btn-xs btn-info"><i class="glyph-icon icon-eye"></i></button>
                                        @endif
                                    </td>
                                    <td data-title="Color" class="tab-center" ><div style="background:{{$social_areas->color}}">&nbsp;</div></td>
                                    <td data-title="Área oculta" class="tab-center">
                                        @if($social_areas->ocult_area == 1)
                                            Si
                                        @else
                                            No
                                        @endif
                                    </td>
                                    <td data-title="Acción" class="tab-center">
                                        @can('edit', App\SocialArea::class)
                                            <a href="{{ action('SocialAreaController@edit', $social_areas->id)}}">
                                                <i class="glyph-icon icon-pencil pad5R"></i>
                                            </a>
                                        @endcan
                                        @can('delete', App\SocialArea::class)
                                            <a href="#" id="btndeletesarea{{$a++}}" value="{{$social_areas->id}}" data-toggle="modal" data-target="#deletesarea">
                                                <i class="glyph-icon icon-trash pad5L"></i>
                                            </a>
                                        @endcan
                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                        <!-- #Paginacion de areas sociales -->
                        {{ $social_area->links() }}
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@include('footer')

<!--========= MODAL COMFIRMACIÓN PARA ELIMINAR =========================================================================== -->
<div id="deletesarea" class="modal fade" role="dialog" aria-hidden="true">
    <div class="modal-dialog modal-eliminar">
        <div class="modal-content">
        
            <div class="modal-header">
                <button type="button" id="" class="close" data-dismiss="modal" aria-hidden="true">&times;</button> 
                <h4 class="modal-title" id="mySmallModalLabel"><span>Eliminar área social</span></h4>
            </div>
            
            <div class="modal-body">
               
                <!-- Contenido -->
                <div class="row" id="contentindex">
                    <div id="yesdelete">
                        <p style="padding-left:20px; padding-right:20px;">¿Esta seguro que desea eliminar esta área social?</p>
                    </div>
                    <div id="notdelete" style="display:none;">
                        <p style="padding-left:20px; padding-right:20px;">No puedes eliminar esta área social porque ya tiene una reservación.</p>
                    </div>
                    @if(empty($social_areas))

                    @else
                    {!! Form::open( ['method' => 'DELETE', 'action' => ['SocialAreaController@destroy', $social_areas->id]]  ) !!}
                    <input type="hidden" id="deletesareaid" name="id" value="">                                    
                </div>
            
            </div>

            <div class="modal-footer">
                <button type="submit" id="btneliminararea" class="btn btn-eliminar" disabled>Eliminar</button>
                {!!Form::close()!!}
                @endif
            </div>
            
        </div>
    </div>
</div>
<!--========= TERMINA MODAL COMFIRMACIÓN PARA ELIMINAR =========================================================================== -->


{!! Html::script('vendor/bootstrap-colorpicker/js/bootstrap-colorpicker.js') !!}
{!! Html::script('vendor/compress.js/src/Compress.js') !!}
{!! Html::script('vendor/compress.js/index.js') !!}
{!! Html::script('js/validaciones.js') !!}

<script>
    function MM_openBrWindow(theURL,winName,features) { //v2.0
      window.open(theURL,winName,features);
    }

    function pulsarnada(o) { 
      o.preventDefault();
    } 
   


    $('tr#trsarea').each(function(i){
            
        $('#btndeletesarea'+i).on('click', function(){
                
            var id = $(this).val();
            $('#deletesareaid').attr('value',id);

        });      
    });

    $('tr#trsarea').each(function(i){
            
        
        $('#btndeletesarea'+i).on('click', function(){
             $('#btneliminararea').attr("disabled",true);
            $('#btneliminararea').show();
            $('#yesdelete').show();
            $('#notdelete').hide();  
            var id = $('#btndeletesarea'+i).attr("value");

            $.get('/ajax/socialareas/'+ id, function(data)
            {
                                                             
                if(data == 1)
                {
                    
                    $('#deletesareaid').attr('value',id);
                    $('#btneliminararea').attr("disabled",false);
                }
                else
                {
                    
                    $('#btneliminararea').hide();
                    $('#yesdelete').hide();
                    $('#notdelete').show();

                }
                       
                               
            });
            

        });      
      
    });

    $("#acept_area").on('click', function(){
        /* #Cambio wednsday por wendsday */
        if($("#monday").prop('checked') || $("#tuesday").prop('checked') || $("#wendsday").prop('checked') || $("#thursday").prop('checked') || $("#friday").prop('checked') || $("#saturday").prop('checked') || $("#sunday").prop('checked') )
        {
           
            var monto = $("#cost").val();
            
            if($("#cost").val() == "")
            {
                $("#acept").click();
            }
            else
            {
                if(/^[0-9]+(\.[0-9]{1,2})?$/.test(monto))
                {
                    $("#montoregex").hide("slow");
                   
                    if($("#cost").val() == 0)
                    {
                        $("#days_reserve_stay").attr("required",false);
                        $("#acept").click();  
                                            
                    } 
                    else
                    {   
                        $("#days_reserve_stay").attr("required",true);
                        $("#acept").click();
                          
                    }
                   
                   
                    
                }
                else
                {
                    
                    event.preventDefault();
                    $("#montoregex").show("slow");
                    $("#cost").focus();
                  
                }
            }
        }
        else
        {
            alert("Tienes que seleccionar al menos un día en que se puede usar el area social");
        }
    });

    $('#cost').keypress(function(evt){
        //if(tecla.charCode < 48 || tecla.charCode > 57) return false;
        var charCode = (evt.which) ? evt.which : evt.keyCode;
        if (charCode != 46 && charCode > 31 && (charCode < 48 || charCode > 57))
        return false;
        //return true;
    });

    $("#days_reserve_stay").keypress(function(evt){
        //if(tecla.charCode < 48 || tecla.charCode > 57) return false;
        var charCode = (evt.which) ? evt.which : evt.keyCode;
        if (charCode != 46 && charCode > 31 && (charCode < 48 || charCode > 57))
        return false;
        //return true;
    });

    $('#cp1').keypress(function(tecla){
    
       if(tecla.charCode < 48 || tecla.charCode > 57)return false;
       if ((tecla.charCode < 97 || tecla.charCode > 122)//letras mayusculas
                && (tecla.charCode < 65 || tecla.charCode > 90) //letras minusculas
                && (tecla.charCode != 45) //retroceso
                && (tecla.charCode != 241) //ñ
                 && (tecla.charCode != 209) //Ñ
                 && (tecla.charCode != 32) //espacio
                 && (tecla.charCode != 225) //á
                 && (tecla.charCode != 233) //é
                 && (tecla.charCode != 237) //í
                 && (tecla.charCode != 243) //ó
                 && (tecla.charCode != 250) //ú
                 && (tecla.charCode != 193) //Á
                 && (tecla.charCode != 201) //É
                 && (tecla.charCode != 205) //Í
                 && (tecla.charCode != 211) //Ó
                 && (tecla.charCode != 218) //Ú
 
              )
        return false; 

    });




 function pulsar(e) { 
      tecla = (document.all) ? e.keyCode :e.which; 
      return (tecla!=13); 
    } 

    

   

comprimirImagen('file');

    
                           
    
</script>
@endsection