@extends('master')
@section('content')

<style>
.ui-state-hover a,
.ui-state-hover a:hover,
.ui-state-hover a:link,
.ui-state-hover a:visited,
.ui-state-focus a,
.ui-state-focus a:hover,
.ui-state-focus a:link,
.ui-state-focus a:visited {
    color: #bcbcbc;
    text-decoration: none;
}
.ui-state-active,
.ui-state-active,
.ui-state-active {
    border: 1px solid #bcbcbc;
    background: #ffffff url(images/ui-bg_glass_65_ffffff_1x400.png) 50% 50% repeat-x;
    font-weight: bold;
    color: #bcbcbc;
    cursor:pointer;
}
.ui-state-active a,
.ui-state-active a:link,
.ui-state-active a:visited {
    color: #bcbcbc;
    text-decoration: none;
}

</style>
<!--BREADCRUMB-->
<div class="row">
                
    <!--Sección-->
    <div class="col-md-9">
        <div id="page-title">
            <h2>Alta de calles/pisos y números del residencial</h2>
            <p>Da de alta los nombres de las calles/pisos y los números de las residencias</p>
        </div>
    </div>
                
    <!--Fecha-->
    @include('date')

</div><!--BREADCRUMB END-->
            
@if ($errors->has('error'))
    <div class="alert alert-danger">
        <ul>    
            <li>{{ $errors->first('error') }}</li>         
        </ul>
    </div>                                             
@endif
@if ($errors->has('casa'))
    <div class="alert alert-danger">
        <ul>    
            <li>{{ $errors->first('casa') }}</li>         
        </ul>
    </div>                                             
@endif
@include('sessionmessage')
<div class="panel">
    <div class="panel-body">
        <h3 class="title-hero">
            Alta de calles/pisos y números del residencial
            <div class="header-buttons" style="padding-top:5px;">
                @if ($errors->has('name_street') || $errors->has('number') || $errors->has('debt') || $errors->has('error') || $errors->has('casa'))
                    <a href="#" id="btnabrir" class="btn btn-md btn-danger" data-toggle="collapse" data-target="#demo-2" aria-expanded="true"><i id="iconagregar" class="glyph-icon icon-minus"></i></a> 
                @else
                    @if($abierto == 1)
                        <a href="#" id="btnabrir" class="btn btn-md btn-danger" data-toggle="collapse" data-target="#demo-2" aria-expanded="true"><i id="iconagregar" class="glyph-icon icon-minus"></i></a> 
                    @else
                        <a href="#" id="btnabrir" class="btn btn-md btn-danger collapsed" data-toggle="collapse" data-target="#demo-2" aria-expanded="true"><i id="iconagregar" class="glyph-icon icon-plus"></i></a>
                    @endif
               @endif
            </div>
        </h3>
                    
        <div class="example-box-wrapper">
            <div class="row">

                {!! Form::open(['method' => 'POST', 'action' => 'StreetController@store', 'id' => 'formstreets']) !!}
                <div class="col-md-12">
                    @if ($errors->has('name_street') || $errors->has('number') || $errors->has('debt') || $errors->has('error') || $errors->has('casa'))
                        <div id="demo-2" class="collapse in" aria-expanded="true">
                    @else
                        @if($abierto == 1)
                            <div id="demo-2" class="collapse in" aria-expanded="true">
                        @else
                            <div id="demo-2" class="collapse" aria-expanded="true">
                        @endif
                    @endif
                                
                        <div class="">
                            <div class="form-horizontal pad15L pad15R bordered-row">

                                <div class="form-group remove-border">
                                                
                                    <div class="col-md-5 ">
                                        <div class="row">
                                            <label class="col-sm-4 control-label">
                                                Calle/piso:*
                                            </label>
                                            <div class="col-sm-8 form-group{{ $errors->has('name_street') ? ' has-error' : '' }}">
                                                <input type="text" class="form-control" id="name_street" name="name_street" value="{{ old('name_street') }}" placeholder="Nombre de la calle/piso..." required>
                                                @if ($errors->has('name_street'))
                                                  <span class="help-block">
                                                    <strong>{{ $errors->first('name_street') }}</strong>
                                                  </span>
                                                @endif
                                            </div>
                                        </div>
                                    </div>

                                    
                                        
                                    
                                    <div class="col-sm-2 hidden-lg hidden-md">
                                    </div>
                                    <div class="col-md-7 col-sm-10" >

                                        <div class="row" id="pegar">

                                        </div>
                                       
                                        <div id="todo" class="row">
                                            
                                            <div class="col-md-6 col-sm-6" >
                                                <div class="input-group form-guess" >
                                                    <input type="text" id="number" name="number[]" onkeypress="return pulsar(event)" class="form-control inputs" placeholder="Número de casa o departamento" required>
                                                </div>
                                            </div>
                                            <div class="col-md-5 col-sm-5">
                                                <div class="" >
                                                    <input type="text" class="form-control" id="debt" name="debt[]" value="" pattern="^-?([0-9]*)|(-?[0-9]*\.?[0-9]{2})$" title="solo numeros, decimal solo 2" onkeypress="return pulsar(event)"  maxlength="20" placeholder="Saldo inicial..." required>
                                                </div>
                                            </div>
                                            <!--<div class="col-md-3 col-sm-3">
                                                <div class="" >
                                                    <select class="form-control" id="type" name="type[]" onkeypress="return pulsar(event)" required>
                                                        <option value="">-Selecciona-</option>
                                                        <option value="1">Saldo a favor</option>
                                                        <option value="2">Deuda</option>
                                                    </select>

                                                </div>
                                            </div>-->
                                            <div class="col-md-1 col-sm-1">
                                                <button type="button" class="input-group-addon addon-inside btn-primary" id="btnaddnumber">
                                                    <i class="glyph-icon icon-plus"></i>
                                                </button>
                                            </div>

                                        </div>
                                    </div>
                                    

                                </div>

                            </div>
                             <div class="row" >
                                <div class="col-md-12" >
                                    <p style="font-size:12px;"><em>(*) Estos campos son requeridos.</em></p>
                                </div>
                            </div>

                            <div class="button-pane mrg20T">
                                <button id="btnaddstreet" class="btn btn-success">Registrar</button>
                            </div>
                        </div>

                    </div>
                </div>
                {!! Form::close() !!}

            </div>
        </div>
    </div>
</div>
            

<div class="row">
    <div class="col-md-12">
        <div class="panel">
            <div class="panel-body">
                <h3 class="title-hero">
                    Residencias
                </h3>
                <div class="example-box-wrapper">
                    <div class="remove-columns">

                        <div class="row" style="padding-bottom:20px;">
                            {!! Form::open(['method' => 'GET', 'action' => 'StreetController@index', 'id' => 'formstreetssearch']) !!}
                            <div class="col-md-4">
                                
                                <div class="row">
                                    <label class="col-sm-4 control-label">Residencia:</label>
                                    <div class="col-sm-8"> 
                                        <div class="ui-widget">
                                            <input type="text" class="form-control" id="searchstreetnumber"  value="" placeholder="Calle/piso">
                                            <input type="hidden" class="form-control" id="streetnumber" name="streetnumber" value="" placeholder="">
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="col-md-8 col-sm-11 col-xs-11" style="padding-left:20px;">
                                <div class="row mrg5R" style="float:left;">
                                    <button class="btn btn-alt btn-hover btn-primary ">
                                        <span>Filtrar</span>
                                        <i class="glyph-icon icon-arrow-right"></i>
                                    </button>    
                                    <a href="{{ action('StreetController@index')}}" class="btn btn-alt btn-hover btn-default">
                                        <span>Eliminar filtro</span>
                                        <i class="glyph-icon icon-arrow-right"></i>
                                    </a>          
                                </div>
                            </div>
                            {!! Form::close() !!}
                        </div>

                        <table class="table table-condensed table-striped">
                            <thead>
                                <tr>
                                    <th>Residencia</th>
                                    <th class="tab-center">Número</th>
                                    <th class="tab-center">Pago adelantado</th>
                                    <th class="tab-center">Por cobrar</th>
                                    <th class="tab-center">Saldo inicial</th>
                                    <th class="tab-center"></th>
                                </tr>
                            </thead>
                            <tbody>
                                @if(empty($street))
                                @else
                                    @foreach($street as $streets)
                                        <tr id="trstreet">
                                            <td data-title="Residencia">{{$streets->name_street}}</td>
                                            <td data-title="Número" class="tab-center">{{$streets->number}}</td>
                                            <td data-title="Pago adelantado" class="tab-center">
                                                @if(is_null($streets->pago))
                                                    @if(is_null($streets->monto))
                                                        $0
                                                    @else
                                                        ${{$streets->monto}}
                                                    @endif
                                                @else
                                                    @if(is_null($streets->monto))
                                                        ${{$streets->pago}}
                                                    @else
                                                        ${{$t = $streets->monto - $streets->pago}}
                                                    @endif
                                                @endif
                                            </td>
                                            <td data-title="Por cobrar" class="tab-center">
                                                @if(empty($streets->saldo))
                                                    $0.00
                                                @else
                                                    ${{$balance  = number_format($streets->saldo, 2, '.', ',')}}
                                                @endif
                                            </td>
                                            <td data-title="Saldo inicial" class="tab-center">
                                                @if($streets->type == 2)
                                                    @if($streets->initial_debt == $streets->aid)
                                                        @if($streets->debt == 0)
                                                            $0.00
                                                        @else
                                                            ${{$balance  = number_format($streets->debt, 2, '.', ',')}}
                                                        @endif
                                                    @endif
                                                @else
                                                    @if($streets->initial_debt == $streets->payid)
                                                        @if($streets->amount == 0)
                                                            $0.00
                                                        @else
                                                            -${{$balance  = number_format($streets->amount, 2, '.', ',')}}
                                                        @endif
                                                    @else
                                                        $0.00
                                                    @endif
                                                @endif
                                            </td>
                                            <td data-title="Acción" class="tab-center">
                                                <!--@can('delete', App\Street::class)
                                                    <a id="btndeletestreet{{$a++}}" value="{{$streets->id}}" data-toggle="modal" data-target="#deletestreet" href="#"><i class="glyph-icon icon-trash"></i></a>
                                                @endcan-->
                                                <a href="{{ action('StreetController@edit', $streets->id)}}"><i class="glyph-icon icon-pencil"></i></a> 
                                            </td>
                                        </tr>
                                    @endforeach
                                @endif
                            </tbody>
                        </table>
                    </div>
                     <div class="row">
                        <div class="col-sm-6 col-sm-offset-6">
                            <div class="dataTables_paginate paging_bootstrap" id="datatable-example_paginate">
                                <ul class="pagination">
                                   {!! $street->render() !!}
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

@include('footer')
{!! Html::script('js/streets.js') !!}
<script type="text/javascript" src="../../../../../assets/jquery-ui-1.12.1/jquery-ui.min.js"></script>
<script>
    $('#searchstreetnumber').autocomplete({
        minLenght:1,
        autoFocus:true,
        source: '/getstreets',
        select: function( event, ui ) {
                         
            $('#streetnumber').val(ui.item.id);
           
        }

    }); 
</script>

<!--========= MODAL COMFIRMACIÓN PARA ELIMINAR =========================================================================== -->
<div id="deletestreet" class="modal fade" role="dialog" aria-hidden="true">
    <div class="modal-dialog modal-eliminar">
        <div class="modal-content">
        
            <div class="modal-header">
                <button type="button" id="" class="close" data-dismiss="modal" aria-hidden="true">&times;</button> 
                <h4 class="modal-title" id="mySmallModalLabel"><span>Eliminar residencia</span></h4>
            </div>
            
            <div class="modal-body">
               
                <!-- Contenido -->
                <div class="row" id="contentindex">
                    <div id="yesdelete">
                        <p style="padding-left:20px; padding-right:20px;">¿Esta seguro que desea eliminar esta residencia?</p>
                    </div>
                    <div id="notdelete" style="display:none;">
                        <p style="padding-left:20px; padding-right:20px;">No puedes eliminar esta residencia porque ya tiene una deuda.</p>
                    </div>
                    @if(empty($streets))

                    @else
                    {!! Form::open( ['method' => 'DELETE', 'action' => ['StreetController@destroy', $streets->id]]  ) !!}
                    <input type="hidden" id="deletestreetid" name="id" value="">                                          
                </div>
            
            </div>

            <div class="modal-footer">
                <button type="submit" id="btneliminarstreet" class="btn btn-eliminar" disabled>Eliminar</button>
                {!!Form::close()!!}
                @endif
            </div>
            
        </div>
    </div>
</div>
<!--========= MODAL COMFIRMACIÓN PARA ELIMINAR =========================================================================== -->

@endsection
