@extends('master')
@section('content')

<style>


</style>
<!--BREADCRUMB-->
<div class="row">
                
    <!--Sección-->
    <div class="col-md-9">
        <div id="page-title">
            <h2>Soporte técnico</h2>
            <p>¿Necesitas ayuda con el sistema? Te proporcionaremos la ayuda que necesites</p>
        </div>
    </div>
                
    <!--Fecha-->
    @include('date')
</div><!--BREADCRUMB END-->

@if ($errors->has('error'))
    <div class="alert alert-danger">
        <ul>    
            <li>{{ $errors->first('error') }}</li>         
        </ul>
    </div>                                             
@endif
@if (Session::has('message'))
<div class="alert alert-success">
    <div class="bg-green alert-icon">
        <i class="glyph-icon icon-check"></i>
    </div>
    <div class="alert-content">
        <h4 class="alert-title">&nbsp;</h4>
        <p>{{ Session::get('message') }}</p>
    </div>
</div>
@endif
            
<div class="row">
    <div class="col-md-12">
                
<div class="panel">
                <div class="panel-body">
            <!--<h3 class="content-box-header clearfix">
                Ponte en contacto con nosotros
            </h3>-->
             <h3 class="title-hero">
                        Ponte en contacto con nosotros
                    </h3>

            {!! Form::open(['method' => 'POST', 'action' => 'SupportFormController@store', 'id' => 'formsupportform']) !!}
                <div class="form-horizontal pad15L pad15R bordered-row">
                    <div class="form-group">

                        <div class="col-md-4">
                            <div class="row">
                                <label class="col-sm-4 control-label">
                                    Nombre:*
                                </label>
                                <div class="col-sm-8 form-group{{ $errors->has('name_support') ? ' has-error' : '' }}">
                                    <input type="text" class="form-control" id="name_support" name="name_support" value="{{old('name_support')}}" maxlength="50"  placeholder="Nombre..." required>
                                    @if ($errors->has('name_support'))
                                      <span class="help-block">
                                        <strong>{{ $errors->first('name_support') }}</strong>
                                      </span>
                                    @endif
                                </div>
                            </div>
                        </div>
                                
                        <div class="col-md-4">
                            <div class="row">
                                <label class="col-sm-4 control-label">
                                    Correo:*
                                </label>
                                <div class="col-sm-8 form-group{{ $errors->has('email_support') ? ' has-error' : '' }}">
                                    <input type="email" class="form-control" id="email_support" name="email_support" value="{{old('email_support')}}" maxlength="60" placeholder="Correo electrónico..." required>
                                    @if ($errors->has('email_support'))
                                      <span class="help-block">
                                        <strong>{{ $errors->first('email_support') }}</strong>
                                      </span>
                                    @endif
                                </div>
                            </div>
                        </div>
                                
                        <div class="col-md-4">
                            <div class="row">
                                <label class="col-sm-4 control-label">
                                    Teléfono:*
                                </label>
                                <div class="col-sm-8 form-group{{ $errors->has('phone_support') ? ' has-error' : '' }}">
                                    <input type="text" class="form-control" id="phone_support" name="phone_support" value="{{old('phone_support')}}" pattern="^[0-9]{7,20}$" title="7-20 dígitos" maxlength="20" placeholder="Teléfono..." required>
                                    @if ($errors->has('phone_support'))
                                      <span class="help-block">
                                        <strong>{{ $errors->first('phone_support') }}</strong>
                                      </span>
                                    @endif
                                </div>
                            </div>
                        </div>

                    </div>
                            
                    <div class="form-group">

                        <div class="col-md-4">
                            <div class="row">
                                <label class="col-sm-4 control-label">
                                    Mensaje:*
                                </label>
                                <div class="col-sm-8 form-group{{ $errors->has('message_support') ? ' has-error' : '' }}">
                                    <textarea id="message_support" name="message_support" maxlength="250" rows="4" class="form-control textarea-no-resize" required>{{old('message_support')}}</textarea>
                                    @if ($errors->has('message_support'))
                                      <span class="help-block">
                                        <strong>{{ $errors->first('message_support') }}</strong>
                                      </span>
                                    @endif
                                </div>
                            </div>
                        </div>
                                
                    </div>
                

                    <div class="row" >
                        <div class="col-md-12">
                            <p style="font-size:12px;"><em>(*) Estos campos son requeridos.</em></p>
                        </div>
                    </div>
                </div>       
                <div class="button-pane mrg20T">
                    <button class="btn btn-success">Enviar</button>
                </div>
            {!! Form::close() !!}
                           
        </div>
    </div>
</div>


</div>

@include('footer')
<script>

    $('#phone_support').keypress(function(tecla){

        if(tecla.charCode < 48 || tecla.charCode > 57)return false; 

    });
</script>

@endsection