@extends('master')
@section('content')


<!--BREADCRUMB-->
<div class="row">
    <!--Sección-->
    <div class="col-md-9">
        <div id="page-title">
            <h2>Dashboard</h2>
            <p>Revisa aspectos importantes del residencial.</p>
        </div>
    </div>
                
    @include('date')

</div><!--#BREADCRUMB END-->

            <!--CONTENIDO-------------------------------------------------------------------------------------------------------------->
            
            <!--ALERTAS-->
            <div class="row">
                <div class="col-md-12">
                    
                    <!--PAGADO-->
                    <!--<div class="alert alert-success">
                        <div class="bg-green alert-icon">
                            <i class="glyph-icon icon-check"></i>
                        </div>
                        <div class="alert-content">
                            <h4 class="alert-title">¡Felicidades!</h4>
                            <p>Estas al corriente con tus pagos.</p>
                        </div>
                    </div>-->
                        
                    <!--ADVERTENCIA-->
                    <!--<div class="alert alert-warning">
                        <div class="bg-orange alert-icon">
                            <i class="glyph-icon icon-warning"></i>
                        </div>
                        <div class="alert-content">
                            <h4 class="alert-title">¡No lo olvides!</h4>
                            <p>Hoy es el último día para pagar tu cuota.</p>
                        </div>
                    </div>-->
                    
                    <!--ADEUDO-->
                    <!--<div class="alert alert-danger">
                        <div class="bg-red alert-icon">
                            <i class="glyph-icon icon-times"></i>
                        </div>
                        <div class="alert-content">
                            <h4 class="alert-title">UPSS!</h4>
                            <p>Tienes pagos vencidos. Favor de liquidar la deuda lo más pronto posible.</p>
                        </div>
                    </div>-->
                    @if($res == 1)
                        <div class="alert alert-info" id="alert1">
                            <div class="bg-blue alert-icon">
                                <i class="glyph-icon icon-times" id="btn1"></i>
                            </div>
                            <div class="alert-content">
                                <h4 class="alert-title">¡No lo olvides!</h4>
                                <p>Tienes reservaciones pendientes por aprobar.</p>
                            </div>
                        </div>
                    @endif
                    
                    <!--#Pagos por aprobar-->
                    @if($pagos == 1)
                        <div class="alert alert-warning" id="alert2">
                            <div class="bg-yellow alert-icon">
                                <i class="glyph-icon icon-times" id="btn2"></i>
                            </div>
                            <div class="alert-content">
                                <h4 class="alert-title">¡No lo olvides!</h4>
                                <p>Tienes pagos pendientes por aprobar.&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<a href="{{ url('/incomes') }}">Ver pagos pendientes.</a></p>
                            </div>
                        </div>
                    @endif
                    
                </div>
            </div>

            @if(!empty($pop))
                <div class="alert alert-warning">
                        <div class="bg-orange alert-icon">
                            <i class="glyph-icon icon-warning"></i>
                        </div>
                        <div class="alert-content">
                            <h4 class="alert-title">¡No lo olvides!</h4>
                            <p>{{$pop}}</p>
                        </div>
                </div>
            @endif

            
            <div class="row">
                <!--BLOQUE IZQUIERDO------------------------------------------------------------------------------------------>
                <div class="col-md-8">
                    
                    <!--PRIMERA FILA------------------------------------------------------------------------------------------>
                    <div class="row">
                        
                        <!--Grafica 1-->
                        <div class="col-md-12">
                            <div class="panel">
                                <div class="panel-body">
                                    <h3 class="title-hero">
                                        Histórico de ingresos y egresos
                                        <div class="float-right font-size-13">Últimos 12 meses</div>
                                    </h3>
                                    <div class="example-box-wrapper">
                                        <canvas id="IngresosyEgresos" style="width:100%; height: 320px;"></canvas>
                                    </div>

                                    @foreach($income as $key => $incomes)
                                        <div id="all">
                                            <input type="hidden" id="income{{$a++}}" name="{{$income[$key]['month']}}" value="{{$income[$key]['amounti']}}" />
                                            <input type="hidden" id="expense{{$a}}" name="{{$income[$key]['month']}}" value="{{$income[$key]['amounte']}}" />
                                            <input type="hidden" id="month{{$a}}" value="{{$income[$key]['month']}}" />
                                        </div>
                                    @endforeach
                                </div>
                            </div>
                        </div>
                        
                    </div><!--#PRIMERA FILA END-->
                    
                </div><!--#BLOQUE IZQUIERDO end-->
                                                
                <!--BLOQUE DERECHO---------------------------------------------------------------------------------------->
                <div class="col-md-4">
                    
                    <div class="panel">
                        <div class="panel-body">
                            <h3 class="title-hero">
                                Ingresos / Egresos
                                <div class="float-right font-size-13">Mes actual</div>
                            </h3>
                            <div class="example-box-wrapper">
                                <table class="table table-condensed table-striped mrg0B">
                                    <tbody>
                                    <tr>
                                        <td>(+) Ingresos cobrados</td>
                                        <td>${{$incomenumeral}}</td>
                                    </tr>
                                    <tr>
                                        <td>(-) Gastos pagados</td>
                                        <td>${{$expensenumeral}}</td>
                                    </tr>
                                    <tr>
                                        <td>(=) Total</td>
                                        <td>${{$total1}}</td>
                                    </tr>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                
                    <div class="panel">
                        <div class="panel-body">
                            <h3 class="title-hero">
                                Capital de trabajo
                            </h3>
                            <div class="example-box-wrapper">
                                <table class="table table-condensed table-striped mrg0B">
                                    <tbody>
                                    <tr>
                                        <td>(+) Cuentas por cobrar</td>
                                        <td>${{$alldebt}}</td>
                                    </tr>
                                    <tr>
                                        <td>(+) Saldo en bancos</td>
                                        <td>${{$balance}}</td>
                                    </tr>
                                    <tr>
                                        <td>(-) Cuentas por pagar</td>
                                        <td>${{$accounttopay}}</td>
                                    </tr>
                                    <tr>
                                        <td>(=) Total</td>
                                        <td>${{$total2}}</td>
                                    </tr>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                    
                </div><!--#BLOQUE DERECHO end-->
            </div>
            
            <!--BLOQUE INFERIOR-->
            <div class="row">
                <div class="col-md-12">
                    <div class="row">
                        <div class="col-md-4 col-sm-4">
                            <div class="panel">
                                <div class="panel-body">
                                    <h3 class="title-hero">
                                        Categoria ingresos
                                        <div class="float-right font-size-13">${{$incometotal}}</div>
                                    </h3>
                                    <div class="example-box-wrapper clearfix" >
                                        <canvas id="PieIngresos" style="height:100px;"></canvas>
                                    </div>
                                    @foreach($incomecategory as $key => $incomes)
                                        <input type="hidden" id="{{$incomecategory[$key]['id']}}s" name="{{$incomecategory[$key]['category_name']}}" value="{{$incomecategory[$key]['amount']}}" />
                                    @endforeach
                                        <input type="hidden" id="5s" name="" value="{{$payadvanced}}" />

                                </div>
                            </div>
                        </div>
                        <div class="col-md-4 col-sm-4">
                            <div class="panel">
                                <div class="panel-body">
                                    <h3 class="title-hero">
                                        Categoria gastos
                                        <div class="float-right font-size-13">${{$expensetotal}}</div>
                                    </h3>
                                    <div class="example-box-wrapper clearfix">
                                        <canvas id="DonutGastos" style="height:100px;"></canvas>
                                    </div>
                                    @foreach($expensecategory as $keys => $expenses)
                                        <input type="hidden"  class="porcentaje" id="{{$expensecategory[$keys]['id']}}" name="{{$expensecategory[$keys]['category_name']}}" value="{{$expensecategory[$keys]['amount']}}" />
                                    @endforeach

                                   <!-- @foreach($expensepor as $keys => $expensepors)
                                        <input type="hidden"  name="{{$expensepor[$keys]['category_name']}}" value="{{$expensepor[$keys]['porcentage']}}" />
                                    @endforeach-->


                                </div>
                            </div>
                        </div>
                        <div class="col-md-4 col-sm-4">
                            <div class="panel">
                                <div class="panel-body">
                                    <h3 class="title-hero">
                                        Cartera vencida
                                        <div class="float-right font-size-13">${{$carteravencida}}</div>
                                    </h3>
                                    <div class="example-box-wrapper clearfix">
                                        <canvas id="PieVencida" style="height:100px;"></canvas>
                                    </div>
                                    @foreach($cartera as $cc)
                                        <input type="hidden" id="normal" name="" value="{{$cc['normal']}}" />
                                        <input type="hidden" id="treinta" name="" value="{{$cc['treinta']}}" />
                                        <input type="hidden" id="sesenta" name="" value="{{$cc['sesenta']}}" />
                                        <input type="hidden" id="mas" name="" value="{{$cc['mas']}}" />
                                    @endforeach
                                    
                                   
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div><!--#BLOQUE INFERIOR end-->

@include('footer')

<script src="https://cdnjs.cloudflare.com/ajax/libs/Chart.js/2.4.0/Chart.min.js"></script>
<script type="text/javascript" src="../../../assets/widgets/charts/flot/flot-demo.js"></script>
<script>

    $("#btn1").on('click', function(){

        $("#alert1").hide("slow");
    });

    //#Pagos por aprobar
    $("#btn2").on('click', function(){

        $("#alert2").hide("slow");
    });

</script>                   
@endsection