@extends('master')
@section('content')

<style>
.ui-state-hover a,
.ui-state-hover a:hover,
.ui-state-hover a:link,
.ui-state-hover a:visited,
.ui-state-focus a,
.ui-state-focus a:hover,
.ui-state-focus a:link,
.ui-state-focus a:visited {
    color: #bcbcbc;
    text-decoration: none;
}
.ui-state-active,
.ui-state-active,
.ui-state-active {
    border: 1px solid #bcbcbc;
    background: #ffffff url(images/ui-bg_glass_65_ffffff_1x400.png) 50% 50% repeat-x;
    font-weight: bold;
    color: #bcbcbc;
    cursor:pointer;
}
.ui-state-active a,
.ui-state-active a:link,
.ui-state-active a:visited {
    color: #bcbcbc;
    text-decoration: none;
}

</style>
<!--BREADCRUMB-->
<div class="row">
                
    <!--Sección-->
    <div class="col-md-9">
        <div id="page-title">
            <h2>Aportaciones mensuales</h2>
            <p>Da de alta las diferentes cantidades de aportación mensual y asignalas a las residencias.</p>
        </div>
    </div>
                
    <!--Fecha-->
    @include('date')

</div><!--BREADCRUMB END-->
            
@if ($errors->has('error'))
    <div class="alert alert-danger">
        <ul>    
            <li>{{ $errors->first('error') }}</li>         
        </ul>
    </div>                                             
@endif




@include('sessionmessage')
<div class="row">
	<div class="col-md-6">
		<div class="panel">
		    <div class="panel-body">
		        <h3 class="title-hero">
		           Alta de aportaciones mensuales
		            <div class="header-buttons" style="padding-top:5px;">
		                @if ($errors->has('contribution'))
		                    <a href="#" id="btnabrir" class="btn btn-md btn-danger" data-toggle="collapse" data-target="#demo-2" aria-expanded="true"><i id="iconagregar" class="glyph-icon icon-minus"></i></a> 
		                @else
		                    @if($abierto == 1)
		                        <a href="#" id="btnabrir" class="btn btn-md btn-danger" data-toggle="collapse" data-target="#demo-2" aria-expanded="true"><i id="iconagregar" class="glyph-icon icon-minus"></i></a> 
		                    @else
		                        <a href="#" id="btnabrir" class="btn btn-md btn-danger collapsed" data-toggle="collapse" data-target="#demo-2" aria-expanded="true"><i id="iconagregar" class="glyph-icon icon-plus"></i></a>
		                    @endif
		               @endif
		            </div>
		        </h3>
		                    
		        <div class="example-box-wrapper">
		            <div class="row">

		                {!! Form::open(['method' => 'POST', 'action' => 'MonthlyPayController@store', 'id' => 'formstreets']) !!}
		                <div class="col-md-12">
		                    @if ($errors->has('name_street') || $errors->has('number') || $errors->has('debt') || $errors->has('error') || $errors->has('casa'))
		                        <div id="demo-2" class="collapse in" aria-expanded="true">
		                    @else
		                        @if($abierto == 1)
		                            <div id="demo-2" class="collapse in" aria-expanded="true">
		                        @else
		                            <div id="demo-2" class="collapse" aria-expanded="true">
		                        @endif
		                    @endif
		                                
		                        <div class="">
		                            <div class="form-horizontal pad15L pad15R bordered-row">

		                                <div class="form-group remove-border">
		                                                
		                                    <div class="col-md-12 ">
		                                        <div class="row">
		                                            <label class="col-sm-6 control-label">
		                                                Aportación Mensual*:
		                                            </label>
		                                            <div class="col-sm-6 form-group{{ $errors->has('contribution') ? ' has-error' : '' }}">
		                                               
		                                                 <input type="text" class="form-control" id="contribution" name="contribution" pattern="^([0-9]*)|([0-9]*\.?[0-9]{2})$" title="solo numeros, decimal solo 2" maxlength="12" min="1" value="{{old('contribution')}}" required/>

		                                                 @if ($errors->has('cero'))
				                                            <span class="help-block">
				                                                <strong>{{ $errors->first('cero') }}</strong>
				                                            </span>
				                                        @endif
				                                            <div id="montocero" style="display:none;color:#FF0000;">
				                                                <strong>El monto no puede ser 0.</strong>
				                                            </div>
				                                            <div id="montoregex" style="display:none;color:#FF0000;">
				                                                <strong>solo numeros, solo 2 decimales.</strong>
				                                            </div>
		                                                
		                                            </div>
		                                        </div>
		                                    </div>

		   
		                            </div>
		                             <div class="row" >
		                                <div class="col-md-12" >
		                                    <p style="font-size:12px;"><em>(*) Estos campos son requeridos.</em></p>
		                                </div>
		                            </div>

		                            <div class="button-pane mrg20T">
		                                <button id="btnaddcontribution" class="btn btn-success">Guardar</button>
		                            </div>
		                        </div>

		                    </div>
		                </div>
		                {!! Form::close() !!}
		            </div>
		            </div>
		        </div>
		    </div>
		</div>
	</div>

	<div class="col-md-6">
		<div class="panel">
		    <div class="panel-body">
		        <h3 class="title-hero">
		            Aportaciones mensuales
		            <div class="header-buttons" style="padding-top:5px;">
		                <a href="#" id="btnabrir2" class="btn btn-md btn-danger collapsed" data-toggle="collapse" data-target="#demo-3" aria-expanded="true"><i id="iconagregar2" class="glyph-icon icon-plus"></i></a>
		            </div>
		        </h3>
		                    
		        <div class="example-box-wrapper">
		            <div class="row">

		                <div class="col-md-12">

		                    <div id="demo-3" class="collapse" aria-expanded="true">
	    
		                         <table class="table table-condensed table-striped">
		                            <thead>
		                                <tr>
		                                    <th>Monto</th>
		                                    <th >Principal</th>
		                                    <th class="tab-center"></th>
		                                </tr>
		                            </thead>
		                            <tbody>
		                                @if(empty($atri))
		                                @else
		                                    @foreach($atri as $atris)
		                                    <input type="hidden" value="{{$b++}}"/>
		                                        <tr id="trcontribution1">
		                                            <td data-title="Monto">${{$atris->amount}}</td>
		                                            <td data-title="Principal">
		                                            	@if($atris->asign == 1)
		                                            		<p ><i class="glyph-icon icon-star"></i></p>
		                                            	@else

		                                            	@endif
		                                            </td>
		                                            <td data-title="Acción" class="tab-center">
		                                            	<input type="hidden" value="{{$b}}" id="number{{$b}}"/>
		                                            	<input type="hidden" value="{{$atris->id}}" id="iat{{$b}}"/>

		                                            	<a href="{{ action('MonthlyPayAsignController@edit', $atris->id)}}" ><span class="bs-badge badge-info tooltip-button" data-toggle="tooltip" data-placement="top" title="Seleccionar como aportación mensual principal."><i class="glyph-icon icon-check"></i></span></a> 
		                                            	
		                                            	 <a href="#t" id="btneditatri{{$b}}" data-toggle="modal" data-target="#editatri"><span class="bs-badge badge-info tooltip-button" data-toggle="tooltip" data-placement="top" title="Aplicar esta aportación mensual a todas las residencias."><i class="glyph-icon icon-refresh"></i></span></a> 

		                                                <a href="#t" id="btndeleteatri{{$b}}"  data-toggle="modal" data-target="#deleteatri" ><i class="glyph-icon icon-trash"></i></a> 
		                                            </td>
		                                        </tr>
		                                    @endforeach
		                                @endif
		                            </tbody>
		                        </table>
		                </div>
		                {!! Form::close() !!}
		            </div>
		            </div>
		            
		        </div>
		    </div>
		</div>
	</div>
</div>
            

<div class="row">
    <div class="col-md-12">
        <div class="panel">
            <div class="panel-body">
                <h3 class="title-hero">
                    Residencias
                </h3>
                <div class="example-box-wrapper">
                    <div class="remove-columns">

                        <div class="row" style="padding-bottom:20px;">
                            {!! Form::open(['method' => 'GET', 'action' => 'MonthlyPayController@index', 'id' => 'formstreetscontributionsearch']) !!}
                            <div class="col-md-4">
                                
                                <div class="row">
                                    <label class="col-sm-4 control-label">Residencia:</label>
                                    <div class="col-sm-8"> 
                                        <div class="ui-widget">
                                            <input type="text" class="form-control" id="searchstreetnumber"  value="" placeholder="Calle/piso">
                                            <input type="hidden" class="form-control" id="streetnumber" name="streetnumber" value="" placeholder="">
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="col-md-8 col-sm-11 col-xs-11" style="padding-left:20px;">
                                <div class="row mrg5R" style="float:left;">
                                    <button class="btn btn-alt btn-hover btn-primary ">
                                        <span>Filtrar</span>
                                        <i class="glyph-icon icon-arrow-right"></i>
                                    </button>    
                                    <a href="{{ action('MonthlyPayController@index')}}" class="btn btn-alt btn-hover btn-default">
                                        <span>Eliminar filtro</span>
                                        <i class="glyph-icon icon-arrow-right"></i>
                                    </a>          
                                </div>
                            </div>
                            {!! Form::close() !!}
                        </div>

                        <table class="table table-condensed table-striped">
                            <thead>
                                <tr>
                                    <th width="25%">Residencia</th>
                                    <th width="20%" class="tab-center">Número</th>
                                   	<th width="30%" class="tab-center">Aportación Mensual</th>
                                    <th width="25%" class="tab-center"></th>
                                </tr>
                            </thead>
                            <tbody>
                                @if(empty($street))
                                @else
                                    @foreach($street as $streets)
                                    	<input type="hidden" id="" value="{{$a++}}"/>
                                        <tr id="trstreeta">
                                            <td data-title="Residencia">{{$streets->name_street}}</td>
                                            <td data-title="Número" class="tab-center">{{$streets->number}}</td>
                                            <td data-title="Aportación mensual" class="tab-center">
                                            	@if(is_null($streets->amount))
                                            		
                                            	@else
                                            		<div class="col-sm-12 form-group{{ $errors->has('acontribution') ? ' has-error' : '' }}">
                                            			<input type="hidden" value="{{$streets->mid}}" id="atrioption{{$a}}"/>
		                                                <select id="acontribution{{$a}}" name="acontribution" value="{{$streets->amount}}" class="form-control" required disabled="disabled">
		                                                    <option value="">-Selecciona-</option>
		                                                    @foreach($amount as $camounts)
		                                                        @if($streets->mid ==  $camounts->id)
		                                                            <option value="{{$camounts->id}}" selected>{{$camounts->amount}}</option>
		                                                        @else
		                                                            <option value="{{$camounts->id}}">{{$camounts->amount}}</option>
		                                                        @endif
		                                                    @endforeach
		                                                </select>
		                                                @if ($errors->has('acontribution'))
		                                                    <span class="help-block">
		                                                        <strong>{{ $errors->first('acontribution') }}</strong>
		                                                    </span>
		                                                @endif
                                            		</div>
                                            	@endif
                                            </td>
                                            <td data-title="Acción" class="tab-center">
                                            	<div class="row">
                                            		<div class="col-md-9">
                                            	
	                                                {!! Form::model($street , ['method' => 'PATCH', 'action' => ['MonthlyPayController@update', $streets->id],'id' => 'formedit'.$a]) !!}
	                                            	<input type="hidden" value="" id="valueamount{{$a}}" name="atribamount"/>
	                                            	<div style="display:none;" id="btnaccept{{$a}}">
	                                                	<button class="btn btn-xs btn-alt btn-hover btn-blue-alt " type="submit"   >Guardar</button>
	                                            	</div>
	                                                {!! Form::close() !!}
		                                            </div>
		                                            <div class="col-md-3">
	                                            		<span style="display: inline-block;">
	                                             			<a href="#w" id="closeedit{{$a}}" style="display:none;"><i class="glyph-icon icon-times" ></i></a>
	                                             		</span>
	                                             		<span style="display: inline-block;">
	                                                		<a href="#x" id="disablecontribution{{$a}}"><i class="glyph-icon icon-pencil"></i></a>
	                                                	</span>
	                                                </div>
                                               	</div>
                                                	
                                                	
                                            	

                                                
                                            </td>
                                        </tr>
                                    @endforeach
                                @endif
                            </tbody>
                        </table>
                    </div>
                     <div class="row">
                        <div class="col-sm-6 col-sm-offset-6">
                            <div class="dataTables_paginate paging_bootstrap" id="datatable-example_paginate">
                                <ul class="pagination">
                                   {!! $street->render() !!}
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!--========= MODAL COMFIRMACIÓN PARA ELIMINAR =========================================================================== -->
<div id="deleteatri" class="modal fade" role="dialog" aria-hidden="true" data-backdrop="static">
    <div class="modal-dialog modal-eliminar">
        <div class="modal-content">
        
            <div class="modal-header">
                <button type="button" id="closeatrimodal" class="close" data-dismiss="modal" aria-hidden="true">&times;</button> 
                <h4 class="modal-title" id="mySmallModalLabel"><span>Eliminar aportación mensual</span></h4>
            </div>
            
            <div class="modal-body">
               
                <!-- Contenido -->
                <div class="row" id="contentindex">
                    <div id="yesdelete">
                        <p style="padding-left:20px; padding-right:20px;">¿Esta seguro que desea eliminar esta aportación mensual?</p>
                    </div>
                    <div id="notdelete" style="display:none;">
                    	<div >
                        	<p style="padding-left:20px; padding-right:20px;">No puedes eliminar esta aportación mensual porque esta asiganda a una o mas residencias.</p>
                    	</div>
                    </div>
                    @if(empty($atris))

                    @else
                    

                      {!! Form::open(['method' => 'DELETE', 'action' => ['MonthlyPayController@destroy', $atris->id], 'id' => 'deleteatributionform']) !!}
                    <input type="hidden" id="deletatri" name="id" value=""/>
                    <input type="hidden" id="numberatri" value=""/>                                          
                </div>
            
            </div>

            <div class="modal-footer">
                <button type="button" id="btneliminaratri" class="btn btn-eliminar" >Eliminar</button>
                {!!Form::close()!!}
                @endif
            </div>
            
        </div>
    </div>
</div>
<!--========= MODAL COMFIRMACIÓN PARA ELIMINAR =========================================================================== -->

<!--========= MODAL CAMBIAR AL APORTACION MENSUAL DE TODAS LAS CASAS =========================================================================== -->
<div id="editatri" class="modal fade" role="dialog" aria-hidden="true" data-backdrop="static">
    <div class="modal-dialog modal-eliminar">
        <div class="modal-content">
        
            <div class="modal-header">
                <button type="button" id="closeeditmodal" class="close" data-dismiss="modal" aria-hidden="true">&times;</button> 
                <h4 class="modal-title" id="mySmallModalLabel"><span>Asignar aportación mensual</span></h4>
            </div>
            
            <div class="modal-body">
               
                <!-- Contenido -->
                <div class="row" id="contentindex">
                    <div id="">
                        <p style="padding-left:20px; padding-right:20px;">¿Esta seguro que desea asignar esta aportación mensual a todas las residencias?</p>
                    </div>
                  
                    @if(empty($streets))

                    @else
                     {!! Form::open(['method' => 'POST', 'action' => 'MonthlyPayAsignController@store', 'id' => 'formstreets2']) !!}


                    <input type="hidden" id="idamount" name="idamount" value=""/>
                                                         
                </div>
            
            </div>

            <div class="modal-footer">
                <button type="submit" id="btneditatri" class="btn btn-eliminar" >Aceptar</button>
                {!!Form::close()!!}
                @endif
            </div>
            
        </div>
    </div>
</div>
<!--========= MODAL CAMBIAR AL APORTACION MENSUAL DE TODAS LAS CASAS =========================================================================== -->

@include('footer')
{!! Html::script('js/streets.js') !!}
<script type="text/javascript" src="../../../../../assets/jquery-ui-1.12.1/jquery-ui.min.js"></script>
<script>
    $('#searchstreetnumber').autocomplete({
        minLenght:1,
        autoFocus:true,
        source: '/getstreets',
        select: function( event, ui ) {
                         
            $('#streetnumber').val(ui.item.id);
           
        }

    }); 

    $("tr#trstreeta").each(function(i){

    	/*if(i == 0)
    	{
    		i = 1;
    	}*/

    	i = i+1;

        $("#disablecontribution"+i).on('click', function(){
        	
        	
        	$("#acontribution"+i).prop('disabled', false);
        	$("#closeedit"+i).show("slow");
			$("#disablecontribution"+i).hide("slow");
        	
        });

        $("#closeedit"+i).on('click', function(){
			
			$("#btnaccept"+i).hide("slow");
			$("#acontribution"+i).prop('disabled', true);
        	$("#closeedit"+i).hide("slow");
			$("#disablecontribution"+i).show("slow");
			var option = $("#atrioption"+i).val();
			$("#acontribution"+i).val(option);
        
        });

        $("#acontribution"+i).on('change', function(){

        	var am = $("#acontribution"+i+" "+"option:selected").attr("value");
        	$("#valueamount"+i).val(am);
        	$("#btnaccept"+i).show("slow");

        });



        

    });

    $("#btnaddcontribution").on('click',function(){

        	var monto = $("#contribution").val();
          
	        if(/^[0-9]+(\.[0-9]{1,2})?$/.test(monto))
	        {
	            $("#montoregex").hide("slow");
	            if($("#contribution").val() <= 0)
	            {    
	                if($("#contribution").val() == "")
	                {
	                   
	                   $("#montocero").hide("slow");
	                }
	                else
	                {
	                   event.preventDefault();
	                   $("#montocero").show("slow");
	                }
	                                    
	            } 
	            else
	            {   
	                $("#montocero").hide("slow");   
	            }
	                
	        }
	        else
	        {
	            event.preventDefault();
	            $("#montocero").hide("slow");
	            $("#montoregex").show("slow");
	              
	        }

    });
    


	$('#contribution').keypress(function(evt){
        //if(tecla.charCode < 48 || tecla.charCode > 57) return false;
        var charCode = (evt.which) ? evt.which : evt.keyCode;
        if (charCode != 46 && charCode > 31 && (charCode < 48 || charCode > 57))
        return false;
        //return true;
    });

    $("#btnabrir2").on('click', function(){

        var uno = $("#btnabrir2").attr("class");
        
        if(uno == "btn btn-md btn-danger collapsed")
        {
            $("#iconagregar2").attr("class","glyph-icon icon-minus");
        }
        else
        {
            
            $("#iconagregar2").attr("class","glyph-icon icon-plus");
        }
        
    });


    $("tr#trcontribution1").each(function(e){

    	var s = e + 1;

    	$("#btndeleteatri"+s).on('click', function(){

    		
    		var n = $("#number"+s).val();
    		var a_id = $("#iat"+s).val();

    		$("#deletatri").val(a_id);
    		$("#numberatri").val(n);


    	});

    	$("#btneditatri"+s).on('click', function(){

    		
    		
    		var a_id = $("#iat"+s).val();

    		$("#idamount").val(a_id);
    	


    	});

    	
  

    });

    $("#closeeditmodal").on('click', function(){

    	$("#idamount").val(' ');

    });


    $("#btneliminaratri").on('click', function(){

     	var id = $("#deletatri").val();
     

     	$.get('/checkatribution?a_id='+ id, function(data){       
            

	            if(data == 0)
	            {
	               
	               $("#yesdelete").hide("slow");
	               $("#notdelete").show("slow");
	               $("#btneliminaratri").prop("disabled", true);

	                  
	            }
	            else
	            {
	            	$("#deleteatributionform").submit();
	            }
  
                    
       	});
     	


    });

    $("#closeatrimodal").on('click', function(){

    	$("#btneliminaratri").prop("disabled", false);
    	$("#yesdelete").show("slow");
	    $("#notdelete").hide("slow");
	    

    });





    
</script>



@endsection
