@extends('master')
@section('content')



<!--BREADCRUMB-->
<div class="row">
                
    <!--Sección-->
    <div class="col-md-9">
        <div id="page-title">
            <h2>Discusiones</h2>
            <p>Crea discusiones para el residencial</p>
        </div>
    </div>
                
    <!--Fecha-->
    @include('date')
</div><!--BREADCRUMB END-->


@include('sessionmessage')

@if ($errors->has('error'))
    <div class="alert alert-danger">
        <ul>    
            <li>{{ $errors->first('error') }}</li>         
        </ul>
    </div>                                             
@endif

@if ($errors->has('error2'))
    <div class="alert alert-danger">
        <ul>    
            <li>{{ $errors->first('error2') }}</li>         
        </ul>
    </div>                                             
@endif

<div class="row">
    <div class="panel">
        <div class="panel-body">
            <h3 class="title-hero">
                Añadir discusión
                <div class="header-buttons" style="padding-top:5px;">
                    @if ($errors->has('title') || $errors->has('start_date') || $errors->has('end_date') || $errors->has('description'))
                        <a href="#" id="btnabrir" class="btn btn-md btn-danger" data-toggle="collapse" data-target="#demo-2" aria-expanded="true"><i id="iconagregar" class="glyph-icon icon-minus"></i></a>
                    @else
                        @if($abierto == 1)
                            <a href="#" id="btnabrir" class="btn btn-md btn-danger" data-toggle="collapse" data-target="#demo-2" aria-expanded="true"><i id="iconagregar" class="glyph-icon icon-minus"></i></a>
                        @else
                            <a href="#" id="btnabrir" class="btn btn-md btn-danger collapsed" data-toggle="collapse" data-target="#demo-2" aria-expanded="true"><i id="iconagregar" class="glyph-icon icon-plus"></i></a>
                        @endif
                    @endif
                </div>
            </h3>
                        
            <div class="example-box-wrapper">
                <div class="row">
                   
                    <div class="col-md-12">
                        @if ($errors->has('name_document') || $errors->has('file') || $errors->has('error'))
                            <div id="demo-2" class="collapse in" aria-expanded="true">
                        @else
                            @if($abierto == 1)
                                <div id="demo-2" class="collapse in" aria-expanded="true">
                            @else
                                <div id="demo-2" class="collapse" aria-expanded="true">
                            @endif
                        @endif          
                            <div class="">
                                <div class="form-horizontal pad15L pad15R bordered-row">
                                {!! Form::open(['method' => 'POST', 'action' => 'DiscussionController@store', 'id' => 'formdiscussion']) !!}
                                    <meta name="csrf-token" content="{{ csrf_token() }}"> 
                                    <div class="form-group remove-border">
                                                    
                                        <div class="col-md-4">
                                            <div class="row">
                                                <label class="col-sm-4 control-label">
                                                    Título:*
                                                </label>
                                                <div class="col-sm-8 form-group{{ $errors->has('title') ? ' has-error' : '' }}">
                                                    <input type="text" class="form-control" id="title" value="{{old('title')}}" name="title" maxlength="35" required>
                                                    @if ($errors->has('title'))
                                                      <span class="help-block">
                                                        <strong>{{ $errors->first('title') }}</strong>
                                                      </span>
                                                    @endif
                                                </div>
                                            </div>
                                        </div>

                                        <div class="col-md-4">
                                            <div class="row">
                                                <label class="col-sm-4 control-label">
                                                    Fecha de inicio:*
                                                </label>
                                                <div class="col-sm-8 form-group{{ $errors->has('start_date') ? ' has-error' : '' }}" >
                                                    <div class="input-prepend input-group">
                                                        <span class="add-on input-group-addon">
                                                            <i class="glyph-icon icon-calendar"></i>
                                                        </span>
                                                        @if(old('start_date'))
                                                            <input type="text" autocomplete="off" class="bootstrap-datepicker form-control manita" value="{{old('start_date')}}" id="start_date" name="start_date" {!! $datesvalidation !!} title="aaaa-mm-dd" required>
                                                        @else
                                                            <input type="text" autocomplete="off" class="bootstrap-datepicker form-control manita" value="{!! date('Y-m-d')!!}" id="start_date" name="start_date" {!! $datesvalidation !!} title="aaaa-mm-dd" required>
                                                        @endif
                                                        
                                                    </div>
                                                    @if ($errors->has('start_date'))
                                                        <span class="help-block">
                                                            <strong>{{ $errors->first('start_date') }}</strong>
                                                        </span>
                                                    @endif
                                                </div>
                                                
                                            </div>
                                        </div>

                                        <div class="col-md-4">
                                            <div class="row">
                                                <label class="col-sm-4 control-label">
                                                    Fecha fin:*
                                                </label>
                                                <div class="col-sm-8 form-group{{ $errors->has('end_date') ? ' has-error' : '' }}" >
                                                    <div class="input-prepend input-group">
                                                        <span class="add-on input-group-addon">
                                                            <i class="glyph-icon icon-calendar"></i>
                                                        </span>
                                                        @if(old('end_date'))
                                                            <input type="text" autocomplete="off" class="bootstrap-datepicker form-control manita" value="{{old('end_date')}}" id="end_date" name="end_date" {!! $datesvalidation !!} title="aaaa-mm-dd" required>
                                                        @else
                                                            <input type="text" autocomplete="off" class="bootstrap-datepicker form-control manita" value="" id="end_date" name="end_date" {!! $datesvalidation !!} title="aaaa-mm-dd" required>
                                                        @endif
                                                        
                                                    </div>
                                                    @if ($errors->has('end_date'))
                                                        <span class="help-block">
                                                            <strong>{{ $errors->first('end_date') }}</strong>
                                                        </span>
                                                    @endif
                                                </div>
                                                
                                            </div>
                                        </div>

                                    </div>

                                    <div class="form-group remove-border">

                                        <div class="col-md-4">
                                            <div class="row">
                                                <label class="col-sm-4 control-label" >
                                                    Descrip.*:
                                                </label>
                                                <div class="col-sm-8 form-group{{ $errors->has('description') ? ' has-error' : '' }}">
                                                    
                                                    <textarea rows="4" id="description" maxlength="150" name="description" class="form-control textarea-no-resize" placeholder="Descripción" required>{{ old('description') }}</textarea>
                                                    @if ($errors->has('description'))
                                                        <span class="help-block">
                                                            <strong>{{ $errors->first('description') }}</strong>
                                                        </span>
                                                    @endif
                                                </div>
                                                
                                            </div>
                                        </div>

                                    </div>

                                <div class="row" >
                                    <div class="col-md-12">
                                        <p style="font-size:12px;"><em>(*) Estos campos son requeridos.</em></p>
                                    </div>
                                </div>

                                <div class="button-pane mrg20T">
                                    <button type="submit" class="btn btn-success" id="btnagregar">Agregar</button>
                                </div>
                            </div>

                        </div>
                    </div>
                    {!! Form::close() !!}
                </div>
            </div>
        </div>
    </div>
</div>

<div class="row">
    <div class="col-md-12">
        <div class="panel">
            <div class="panel-body">
                <h3 class="title-hero">
                    Discusiones
                </h3>
                <div class="example-box-wrapper">
                    <div class="remove-columns">
                        <table class="table table-condensed">
                            <thead>
                                <tr>
                                    <th>Fecha inicio</th>
                                    <th class="tab-center">Título</th>
                                    <th class="text-center">Fecha fin</th>
                                    <th class="text-center">Estatus</th>
                                    <th class="text-center">Resultado</th>
                                </tr>
                            </thead>
                            <tbody>
                   

                                @if($total == " " )

                                @else
                                    @foreach($total as $key => $totales)
                                        <input type="hidden" value="{{$a++}}"/>
                                        <tr id="trdiscussions">
                                            <td data-title="Fecha inicio" id="tdclick{{$a}}" style="cursor:pointer;" >{{$total[$key]['start_date']}}</td>
                                            <td data-title="Título" id="tdclick1{{$a}}" style="cursor:pointer;" class="tab-center">{{$total[$key]['title']}}</td>
                                            <td data-title="Fecha fin" id="tdclick2{{$a}}" style="cursor:pointer;" class="tab-center">{{$total[$key]['end_date']}}</td>
                                            <td data-title="Estatus" id="tdclick3{{$a}}" style="cursor:pointer;" class="tab-center">{{$total[$key]['status_name']}}</td>
                                            <td data-title="Resultado" id="tdclick4{{$a}}" style="cursor:pointer;" class="tab-center">
                                                A favor: {{$total[$key]['favor']}},
                                                En contra: {{$total[$key]['contra']}},
                                                Abstenciones: {{$total[$key]['absten']}},
                                                <div style="display:none;">
                                                    {!! Form::open(['method' => 'GET', 'action' => ['DiscussionController@show',$total[$key]['id']], 'id' => 'formdetaildiscussion'.$a]) !!}
                                                        <input type="hidden" name="id" value="{{$total[$key]['id']}}"/>
                                                    {!! Form::close() !!}
                                                </div>
                                            </td>
                                        </tr>
                                    @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
                <div class="pagination">{!! $total->render() !!}</div> 
                @endif
            </div>

             <div class="actions">
                <div class="btn-group">
                    <a style="text-decoration:none;color:white;" href="{{ action('DocumentController@create')}}" class="btn btn-sm green dropdown-toggle">Agregar</a>
                </div>
            </div>

        </div>
    </div>
</div>


@include('footer')





<script>

    function MM_openBrWindow(theURL,winName,features) { //v2.0
      window.open(theURL,winName,features);
    }




</script>

<script type="text/javascript" src="../../../../../assets/jquery-ui-1.12.1/jquery-ui.min.js"></script>



<script>
    

    $(document).ready(function() { 
        $('#start_date').datepicker({
            minDate: '0d',
        });

        $('#end_date').datepicker({
            minDate: '0d',
        });

        $('#payment_date').keypress(function(tecla){
            if(tecla.charCode < 48 || tecla.charCode > 57)return false;
            if ((tecla.charCode < 97 || tecla.charCode > 122)//letras mayusculas
                && (tecla.charCode < 65 || tecla.charCode > 90) //letras minusculas
                && (tecla.charCode != 45) //retroceso
                && (tecla.charCode != 241) //ñ
                && (tecla.charCode != 209) //Ñ
                && (tecla.charCode != 32) //espacio
                && (tecla.charCode != 225) //á
                && (tecla.charCode != 233) //é
                && (tecla.charCode != 237) //í
                && (tecla.charCode != 243) //ó
                && (tecla.charCode != 250) //ú
                && (tecla.charCode != 193) //Á
                && (tecla.charCode != 201) //É
                && (tecla.charCode != 205) //Í
                && (tecla.charCode != 211) //Ó
                && (tecla.charCode != 218) //Ú
            )
            return false; 

        });


        $("tr#trdiscussions").each(function(i){
           
            var n = i+1;
            $('#tdclick'+n).on('click', function(){
             
                $("#formdetaildiscussion"+n).submit();
                    
            });
            $('#tdclick1'+n).on('click', function(){
             
                $("#formdetaildiscussion"+n).submit();
                    
            });
            $('#tdclick2'+n).on('click', function(){
             
                $("#formdetaildiscussion"+n).submit();
                    
            });
            $('#tdclick3'+n).on('click', function(){
             
                $("#formdetaildiscussion"+n).submit();
                    
            });
            $('#tdclick4'+n).on('click', function(){
             
                $("#formdetaildiscussion"+n).submit();
                    
            });
        });


    });


</script>

@endsection
