@extends('master')
@section('content')



<!--BREADCRUMB-->
<div class="row">
                
    <!--Sección-->
    <div class="col-md-9">
        <div id="page-title">
            <h2>Documentos</h2>
            <p>Revisa documentos importantes sobre el residencial</p>
        </div>
    </div>
                
    <!--Fecha-->
    @include('date')
</div><!--BREADCRUMB END-->


@include('sessionmessage')

@if ($errors->has('error'))
    <div class="alert alert-danger">
        <ul>    
            <li>{{ $errors->first('error') }}</li>         
        </ul>
    </div>                                             
@endif

@if ($errors->has('error2'))
    <div class="alert alert-danger">
        <ul>    
            <li>{{ $errors->first('error2') }}</li>         
        </ul>
    </div>                                             
@endif

<div class="row">
    <div class="panel">
        <div class="panel-body">
            <h3 class="title-hero">
                Agregar documento
                <div class="header-buttons" style="padding-top:5px;">
                    @if ($errors->has('name_document') || $errors->has('file') || $errors->has('error'))
                        <a href="#" id="btnabrir" class="btn btn-md btn-danger" data-toggle="collapse" data-target="#demo-2" aria-expanded="true"><i id="iconagregar" class="glyph-icon icon-minus"></i></a>
                    @else
                        @if($abierto == 1)
                            <a href="#" id="btnabrir" class="btn btn-md btn-danger" data-toggle="collapse" data-target="#demo-2" aria-expanded="true"><i id="iconagregar" class="glyph-icon icon-minus"></i></a>
                        @else
                            <a href="#" id="btnabrir" class="btn btn-md btn-danger collapsed" data-toggle="collapse" data-target="#demo-2" aria-expanded="true"><i id="iconagregar" class="glyph-icon icon-plus"></i></a>
                        @endif
                    @endif
                </div>
            </h3>
                        
            <div class="example-box-wrapper">
                <div class="row">
                   
                    <div class="col-md-12">
                        @if ($errors->has('name_document') || $errors->has('file') || $errors->has('error'))
                            <div id="demo-2" class="collapse in" aria-expanded="true">
                        @else
                            @if($abierto == 1)
                                <div id="demo-2" class="collapse in" aria-expanded="true">
                            @else
                                <div id="demo-2" class="collapse" aria-expanded="true">
                            @endif
                        @endif          
                            <div class="">
                                <div class="form-horizontal pad15L pad15R bordered-row">
                                {!! Form::open(['method' => 'POST', 'action' => 'DocumentController@store', 'enctype' => 'multipart/form-data', 'id' => 'formmessage']) !!}
                                    <meta name="csrf-token" content="{{ csrf_token() }}"> 
                                    <div class="form-group remove-border">
                                                    
                                        <div class="col-md-4">
                                            <div class="row">
                                                <label class="col-sm-4 control-label">
                                                    Nombre:*
                                                </label>
                                                <div class="col-sm-8 form-group{{ $errors->has('name_document') ? ' has-error' : '' }}">
                                                    <input type="text" class="form-control" id="name_document" value="{{old('name_document')}}" name="name_document" maxlength="30" required>
                                                    @if ($errors->has('name_document'))
                                                      <span class="help-block">
                                                        <strong>{{ $errors->first('name_document') }}</strong>
                                                      </span>
                                                    @endif
                                                </div>
                                            </div>
                                        </div>

                                        <div class="col-md-4">
                                            <div class="row">
                                                <label class="col-sm-4 control-label">
                                                    <span class="bs-badge badge-info tooltip-button" data-toggle="tooltip" data-placement="top" title="Se pueden subir archivos: jpg, jpeg ,png y pdf.Tamaño maximo del archivo 5 mb.">?</span> Archivo:*
                                                </label>
                                                <div class="col-sm-8 form-group{{ $errors->has('file') ? ' has-error' : '' }}">
                                                    <div class="fileinput fileinput-new" data-provides="fileinput">
                                                        <span class="btn btn-default btn-file">
                                                        <span class="fileinput-new"><i class="glyph-icon icon-paperclip"></i> Adjuntar archivo</span>
                                                        <span class="fileinput-exists">Cambiar</span>
                                                            <input type="file" id="file" name="file" value="{{old('file')}}" accept="application/pdf,image/jpg,image/jpeg,image/png" required>
                                                        </span>
                                                        <span class="fileinput-filename"></span>
                                                        <a href="#" class="close fileinput-exists" data-dismiss="fileinput" style="float: none">×</a>
                                                    </div>
                                                    @if ($errors->has('file'))
                                                      <span class="help-block">
                                                        <strong>{{ $errors->first('file') }}</strong>
                                                      </span>
                                                    @endif
                                                </div>
                                            </div>
                                        </div>

                                        
                                        
                                        <input type="hidden" id="imageName" name="imageName" value=""/>
                                        <input type="hidden" id="contentType" name="contentType" value=""/>
                                        <input type="hidden" id="imageData" name="imageData" value=""/>
                                        <input type="hidden" id="sizeData" name="sizeData" value=""/>
                                        

                                </div>

                                <div class="row" >
                                    <div class="col-md-12">
                                        <p style="font-size:12px;"><em>(*) Estos campos son requeridos.</em></p>
                                    </div>
                                </div>

                                <div class="button-pane mrg20T">
                                    <button type="submit" class="btn btn-success" id="btnagregar">Agregar</button>
                                </div>
                            </div>

                        </div>
                    </div>
                    {!! Form::close() !!}
                </div>
            </div>
        </div>
    </div>
</div>

<div class="row">
    <div class="col-md-12">
        <div class="panel">
            <div class="panel-body">
                <h3 class="title-hero">
                    Documentos
                </h3>
                <div class="example-box-wrapper">
                    <table class="table table-condensed">
                        <thead>
                            <tr>
                                <th>#</th>
                                <th>Nombre del documento</th>
                                <th class="text-center">Descargar</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($document as $documents)
                                <tr id="trdocuments">
                                    
                                    <td>{{$a++}}</td>
                                    <td>{{$documents->name_document}}</td>
                                    <td class="text-center">
                                        @if(empty($documents->url_file))

                                        @else
                                            <button href="javascript:;" onClick="MM_openBrWindow('{{$documents->url_file}}','','scrollbars=yes,resizable=yes,width=800,height=600')" class="btn btn-xs btn-alt btn-hover btn-blue-alt"><span>Descargar</span><i class="glyph-icon icon-arrow-right"></i></button>
                                        @endif
                                    </td>
                                    <td>

                                            <a href="{{ action('DocumentController@edit', $documents->id)}}">
                                                <i class="glyph-icon icon-pencil pad5R"></i>
                                            </a>
                             
                                            <a href="#" id="btndeletedocument{{$a}}" value="{{$documents->id}}" data-toggle="modal" data-target="#deletedocument">
                                                <i class="glyph-icon icon-trash pad5L"></i>
                                            </a>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
                <div class="pagination">{!! $document->render() !!}</div> 
            </div>

             <div class="actions">
                <div class="btn-group">
                    <a style="text-decoration:none;color:white;" href="{{ action('DocumentController@create')}}" class="btn btn-sm green dropdown-toggle">Agregar</a>
                </div>
            </div>

        </div>
    </div>
</div>


@include('footer')



{!! Html::script('vendor/compress.js/src/Compress.js') !!}
{!! Html::script('vendor/compress.js/index.js') !!}
{!! Html::script('js/validaciones.js') !!}


<script>

    function MM_openBrWindow(theURL,winName,features) { //v2.0
      window.open(theURL,winName,features);
    }



    $('tr#trdocuments').each(function(i){
            
        var dd = i+2;
        $('#btndeletedocument'+dd).on('click', function(){
                
            var id = $('#btndeletedocument'+dd).attr("value");
            $('#deletedocumentid').attr('value',id);

        });      
    });
    
    comprimirImagen('file');



</script>

<!--========= MODAL COMFIRMACIÓN PARA ELIMINAR =========================================================================== -->
<div id="deletedocument" class="modal fade" role="dialog" aria-hidden="true">
    <div class="modal-dialog modal-eliminar">
        <div class="modal-content">
        
            <div class="modal-header">
                <button type="button" id="" class="close" data-dismiss="modal" aria-hidden="true">&times;</button> 
                <h4 class="modal-title" id="mySmallModalLabel"><span>Eliminar documento</span></h4>
            </div>
            
            <div class="modal-body">
               
                <!-- Contenido -->
                <div class="row" id="contentindex">
                    <p style="padding-left:20px; padding-right:20px;">¿Esta seguro que desea eliminar este documento?</p>
                    @if(empty($documents))

                    @else
                    {!! Form::open(['method' => 'DELETE', 'action' => ['DocumentController@destroy', $documents->id]]) !!}
                    <input type="hidden" id="deletedocumentid" name="id" value="">                                    
                </div>
            
            </div>

            <div class="modal-footer">
                <button type="submit" id="aceptareliminar" class="btn btn-eliminar">Eliminar</button>
                {!!Form::close()!!}
                @endif
            </div>
            
        </div>
    </div>
</div>
<!--========= TERMINA MODAL COMFIRMACIÓN PARA ELIMINAR =========================================================================== -->

@endsection

