@extends('master')
@section('content')

@include('date')
@include('error')
@include('sessionmessage')

        <div class="col-md-10">
            <div class="col-md-12" style="background-color:#fff; padding:10px 20px; margin-bottom:10px;">
                <span class="caption-subject" style="float: left; display: inline-block; padding: 12px 0;">Agregar egresos</span>
                <div class="actions">
                    <div class="btn-group">
                            
                    </div>
                </div>
            </div>


            <div class="col-md-12" style="background-color:#fff; padding:30px; margin-bottom:20px;">
                    <div class="portlet">
                        <div class="portlet-title">
                            <div class="caption">
                                <span class=""> </span>
                            </div>
                        </div>
                        {!! Form::open(['method' => 'POST', 'action' => 'ExpenseController@store', 'enctype' => 'multipart/form-data', 'id' => 'formexpense']) !!}
                            <div class="col-lg-10 col-md-10 login-container bs-reset">
                                <div class="login-content">

                                        <div class="row">
                                            <div class="col-md-6 col-sm-6">
                                                <div class="form-group form-md-line-input has-info form-md-floating-label">
                                                    <div class="input-group left-addon">
                                                        <select id="category" name="category" class="form-control">
                                                            @foreach($expense_category as $expense_categories)
                                                                <option value="{{$expense_categories->id}}">{{$expense_categories->category_name}}</option>
                                                            @endforeach
                                                        </select>
                                                         <label for="form_control_1">Categoría de Ingreso</label>
                                                        @if ($errors->has('category'))
                                                            <span class="help-block">
                                                                <strong>{{ $errors->first('category') }}</strong>
                                                            </span>
                                                        @endif
                                                    </div>
                                                </div>
                                            </div>
                                            
                                            <div class="col-md-6 col-sm-6">
                                                <div class="form-group form-md-line-input has-info form-md-floating-label">
                                                    <div class="input-group left-addon">
                                                        <input type="text" autocomplete="off" id="amount" name="amount" value="{{ old('amount')}}" pattern="^([0-9]*)|([0-9]*\.?[0-9]{2})$" title="solo numeros, decimal solo 2" maxlength="20" class="form-control" required>
                                                            <label for="form_control_1">Cantidad</label>
                                                         @if ($errors->has('amount'))
                                                            <span class="help-block">
                                                                <strong>{{ $errors->first('amount') }}</strong>
                                                            </span>
                                                        @endif
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row">
                                            <div class="col-md-6 col-sm-6">
                                                <div class="form-group form-md-line-input has-info form-md-floating-label">
                                                    <div class="input-group left-addon">
                                                        <input type="text" autocomplete="off" id="description" name="description" value="{{ old('description')}}" maxlength="60" class="form-control">
                                                            <label for="form_control_1">Descripción</label>
                                                        @if ($errors->has('description'))
                                                            <span class="help-block">
                                                                <strong>{{ $errors->first('description') }}</strong>
                                                            </span>
                                                        @endif
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-md-6 col-sm-6">

                                                <label for="form_control_1">Fecha contable</label>
                                                <div class="input-prepend input-group">
                                                    <span class="add-on input-group-addon">
                                                       <i class="glyph-icon icon-calendar"></i>
                                                    </span>
                                                    <input type="text" class="bootstrap-datepicker form-control" id="accounting_date" name="accounting_date"  data-date-format="mm/dd/yy">
                                                </div>
                                                @if ($errors->has('accounting_date'))
                                                    <span class="help-block">
                                                        <strong>{{ $errors->first('accounting_date') }}</strong>
                                                    </span>
                                                @endif
                                        
                                            </div>
                                        </div>
                                        <div class="row">
                                            <div class="col-md-6 col-sm-6">
                                                <div class="form-group form-md-line-input has-info form-md-floating-label">
                                                    <div class="input-group left-addon">
                                                        <select id="month" name="month" class="form-control" required>
                                                            @foreach($month as $months)
                                                                @if($months->id == $actual_month->id)
                                                                    <option value="{{$months->id}}" selected>{{$months->month_year_text}}</option>
                                                                @else
                                                                    <option value="{{$months->id}}">{{$months->month_year_text}}</option>
                                                                @endif
                                                            @endforeach
                                                        </select> 
                                                        <label for="form_control_1">Seleciona mes</label>
                                                        @if ($errors->has('month'))
                                                            <span class="help-block">
                                                                <strong>{{ $errors->first('month') }}</strong>
                                                            </span>
                                                        @endif
                                                    </div>
                                                </div>
                                            </div>
                                             <div class="col-md-6 col-sm-6">
                                                <div class="form-group form-md-line-input has-info form-md-floating-label">
                                                    <div class="input-group left-addon">
                                                        <input type="file" autocomplete="off" id="file" name="file"  class="form-control">
                                                            <label for="form_control_1">Cargar comprobante</label>
                                                        @if ($errors->has('file'))
                                                            <span class="help-block">
                                                                <strong>{{ $errors->first('file') }}</strong>
                                                            </span>
                                                        @endif
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row">
                                            <div class="col-md-12 col-sm-12">
                                                <div class="form-group form-md-line-input has-info form-md-floating-label">
                                                    <div class="input-group left-addon">
                                                        <select id="payment_type" name="payment_type" class="form-control" value="{{ old('payment_type')}}" required>
                                                            @foreach($payment_type as $payment_types)
                                                                <option value="{{$payment_types->id}}">{{$payment_types->payment_name}}</option>
                                                            @endforeach
                                                        </select> 
                                                            <label for="form_control_1">Tipo de pago</label>
                                                        @if ($errors->has('payment_type'))
                                                            <span class="help-block">
                                                                <strong>{{ $errors->first('payment_type') }}</strong>
                                                            </span>
                                                        @endif
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        
                                        <div class="row">
                                            <div class="col-md-12">
                                                <button type="submit" class="btn btn-sm green dropdown-toggle">Guardar</button>
                                            </div>
                                        </div>
                                </div>
                            </div>
                            
                        {!! Form::close() !!}

                           
                    </div>
            </div>
      
        </div>

@include('footer')

<script>
    $('#amount').keypress(function(evt){
        //if(tecla.charCode < 48 || tecla.charCode > 57) return false;
        var charCode = (evt.which) ? evt.which : evt.keyCode;
        if (charCode != 46 && charCode > 31 && (charCode < 48 || charCode > 57))
        return false;
        //return true;
    });

    function MM_openBrWindow(theURL,winName,features) { //v2.0
      window.open(theURL,winName,features);
    }

    $(document).ready(function() {


        $('#datetimepickerexp').datepicker({
            format: 'YYYY-MM-DD',
        });

   
    });

</script>


@endsection