@extends('master')
@section('content')

<!--BREADCRUMB-->
<div class="row">
                
    <!--Sección-->
    <div class="col-md-9">
        <div id="page-title">
            <h2>Egresos</h2>
            <p>Agrega los gastos de la colonia</p>
        </div>
    </div>
                
    <!--Fecha-->
    @include('date')
               
</div><!--BREADCRUMB END-->

            
@include('error')
@include('sessionmessage')


<div class="panel">
    <div class="panel-body">
        <h3 class="title-hero">
            Editar gasto
            
        </h3>
                    
        <div class="example-box-wrapper">
            <div class="row">
                {!! Form::model($expense , ['method' => 'PATCH',  'enctype' => 'multipart/form-data', 'action' => ['ExpenseController@update', $expense->id]]) !!}
                <div class="col-md-12">
                    
                                
                        <div class="">
                            <div class="form-horizontal pad15L pad15R bordered-row">

                                <div class="form-group remove-border">
                                                
                                    <div class="col-md-4">
                                        <div class="row">
                                            <label class="col-sm-4 control-label">
                                                Categoría de egreso:*
                                            </label>
                                            <div class="col-sm-8">
                                                <select class="form-control" id="category" name="category" required>
                                                    <option value="">-Selecciona-</option>
                                                    @foreach($expense_category as $expense_categories)
                                                        @if($expense->category == $expense_categories->id)
                                                            <option value="{{$expense_categories->id}}" selected>{{$expense_categories->category_description}}</option>
                                                        @else
                                                            <option value="{{$expense_categories->id}}">{{$expense_categories->category_description}}</option>
                                                        @endif
                                                    @endforeach        
                                                </select>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="col-md-4">
                                        <div class="row">
                                            <label class="col-sm-4 control-label">
                                                Monto:*
                                            </label>
                                            <div class="col-sm-8">
                                                <input type="text" class="form-control" id="amount" name="amount" value="{{$expense->amount}}" pattern="^([0-9]*)|([0-9]*\.?[0-9]{2})$" title="solo numeros, decimal solo 2" maxlength="20" placeholder="Cantidad de aportación..." required>
                                            </div>
                                        </div>
                                    </div>

                                                
                                    <div class="col-md-4">
                                        <div class="row">
                                            <label class="col-sm-4 control-label">
                                                Fecha:*
                                            </label>
                                            <div class="col-sm-8">
                                                <div class="input-prepend input-group">
                                                    <span class="add-on input-group-addon">
                                                        <i class="glyph-icon icon-calendar"></i>
                                                    </span>
                                                    <input type="text" class="bootstrap-datepicker form-control" id="accounting_date" name="accounting_date" value="{{$expense->accounting_date}}" data-date-format="mm/dd/yy" required>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                </div>

                                <div class="form-group">

                                    <div class="col-md-4">
                                        <div class="row">
                                            <label class="col-sm-4 control-label">
                                                Descripción:
                                            </label>
                                            <div class="col-sm-8">
                                                <textarea name="" rows="1" id="description" name="description" value="{{$expense->description}}" maxlength="60" class="form-control textarea-no-resize"></textarea>
                                            </div>
                                        </div>
                                    </div>
                                                
                                    <div class="col-md-4">
                                        <div class="row">
                                            <label class="col-sm-4 control-label">
                                                Método de pago:*
                                            </label>
                                            <div class="col-sm-8">
                                                <select id="payment_type" name="payment_type" class="form-control"  required>
                                                    <option value="">-Selecciona-</option>
                                                    @foreach($payment_type as $payment_types)
                                                        @if($expense->payment_type == $payment_types->id)
                                                            <option value="{{$payment_types->id}}" selected>{{$payment_types->payment_name}}</option>
                                                        @else
                                                            <option value="{{$payment_types->id}}">{{$payment_types->payment_name}}</option>
                                                        @endif
                                                    @endforeach
                                                </select> 
                                            </div>
                                        </div>
                                    </div>

                                    <div class="col-md-4">
                                        <div class="row">
                                            <label class="col-sm-4 control-label">
                                                <span class="bs-badge badge-info tooltip-button" data-toggle="tooltip" data-placement="top" title="Se pueden subir archivos: jpg, jpeg ,png y pdf.Tamaño maximo del archivo 5 mb.">?</span> Comprobante:
                                            </label>
                                            <div class="col-sm-8">
                                                <div class="fileinput fileinput-new" data-provides="fileinput">
                                                    <span class="btn btn-default btn-file">
                                                    <span class="fileinput-new"><i class="glyph-icon icon-paperclip"></i> Adjuntar archivo</span>
                                                    <span class="fileinput-exists">Cambiar</span>
                                                        <input type="file" id="file" name="file">
                                                    </span>
                                                    <span class="fileinput-filename"></span>
                                                    <a href="#" class="close fileinput-exists" data-dismiss="fileinput" style="float: none">×</a>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                </div>

                            </div>

                             <div class="row" >
                                <div class="col-md-12">
                                    <p style="font-size:12px;"><em>(*) Estos campos son requeridos.</em></p>
                                </div>
                            </div>

                            <div class="button-pane mrg20T">
                                <a href="{{url('expenses')}}" class="btn btn-default">Cancelar</a>
                                <button class="btn btn-success">Guardar</button>
                            </div>
                        </div>

                    
                </div>
                {!! Form::close() !!}
            </div>
        </div>
    </div>
</div>

<script>
    $('#amount').keypress(function(evt){
        //if(tecla.charCode < 48 || tecla.charCode > 57) return false;
        var charCode = (evt.which) ? evt.which : evt.keyCode;
        if (charCode != 46 && charCode > 31 && (charCode < 48 || charCode > 57))
        return false;
        //return true;
    });

    function MM_openBrWindow(theURL,winName,features) { //v2.0
      window.open(theURL,winName,features);
    }
   

</script>


@endsection