@extends('master')
@section('content')

<style>
    .manita
    {
        cursor:pointer;
    }
</style>
<!--BREADCRUMB-->
<div class="row">
                
    <!--Sección-->
    <div class="col-md-9">
        <div id="page-title">
            <h2>Egresos</h2>
            <p>Agrega los gastos del residencial</p>
        </div>
    </div>
                
    <!--Fecha-->
    @include('date')
               
</div><!--BREADCRUMB END-->

            
@if ($errors->has('error'))
    <div class="alert alert-danger">
        <ul>    
            <li>{{ $errors->first('error') }}</li>         
        </ul>
    </div>                                             
@endif

@if ($errors->has('file'))
    <div class="alert alert-danger">
        <ul>    
            <li>{{ $errors->first('file') }}</li>         
        </ul>
    </div>                                             
@endif

@if ($errors->has('error2'))
    <div class="alert alert-danger">
        <ul>    
            <li>{{ $errors->first('error2') }}</li>         
        </ul>
    </div>                                             
@endif

@if ($errors->has('pago'))
    <div class="alert alert-danger">
        <ul>    
            <li>{{ $errors->first('pago') }}</li>         
        </ul>
    </div>                                             
@endif

@if ($errors->has('cuenta'))
    <div class="alert alert-danger">
        <ul>    
            <li>{{ $errors->first('cuenta') }}</li>         
        </ul>
    </div>                                             
@endif

@include('sessionmessage')

<div class="panel">
    <div class="panel-body">
        <h3 class="title-hero">
            Agregar gasto
            <div class="header-buttons" style="padding-top:5px;">
                @if ($errors->has('category') || $errors->has('amount') || $errors->has('description') || $errors->has('error'))
                    <a href="#" id="btnabrir" class="btn btn-md btn-danger" data-toggle="collapse" data-target="#demo-2" aria-expanded="true"><i id="iconagregar" class="glyph-icon icon-minus"></i></a>
                @else
                    @if($abierto == 1)
                        <a href="#" id="btnabrir" class="btn btn-md btn-danger" data-toggle="collapse" data-target="#demo-2" aria-expanded="true"><i id="iconagregar" class="glyph-icon icon-minus"></i></a>
                    @else
                        <a href="#" id="btnabrir" class="btn btn-md btn-danger collapsed" data-toggle="collapse" data-target="#demo-2" aria-expanded="true"><i id="iconagregar" class="glyph-icon icon-plus"></i></a>
                    @endif
                @endif
            </div>
        </h3>
                    
        <div class="example-box-wrapper">
            <div class="row">
                {!! Form::open(['method' => 'POST', 'action' => 'ExpenseController@store', 'enctype' => 'multipart/form-data', 'id' => 'formexpense']) !!}
                <div class="col-md-12">
                    @if ($errors->has('category') || $errors->has('amount') || $errors->has('description') || $errors->has('error'))
                        <div id="demo-2" class="collapse in" aria-expanded="true">
                    @else
                        @if($abierto == 1)
                            <div id="demo-2" class="collapse in" aria-expanded="true">
                        @else
                             <div id="demo-2" class="collapse" aria-expanded="true">
                        @endif
                    @endif
                                
                        <div class="">
                            <div class="form-horizontal pad15L pad15R bordered-row">

                                <div class="form-group remove-border">
                                                
                                    <div class="col-md-4">
                                        <div class="row">
                                            <label class="col-sm-5 control-label">
                                                Categoría:*
                                            </label>
                                            <div class="col-sm-7 form-group{{ $errors->has('category') ? ' has-error' : '' }}">
                                                <select class="form-control" id="category" name="category" value="{{old('category')}}" required>
                                                    <option value="">-Selecciona-</option>
                                                    @foreach($expense_category as $expense_categories)
                                                        @if(old('category') == $expense_categories->id)
                                                            <option value="{{$expense_categories->id}}" selected>{{$expense_categories->category_description}}</option>
                                                        @else
                                                            <option value="{{$expense_categories->id}}">{{$expense_categories->category_description}}</option>
                                                        @endif
                                                    @endforeach        
                                                </select>
                                                @if ($errors->has('category'))
                                                    <span class="help-block">
                                                        <strong>{{ $errors->first('category') }}</strong>
                                                    </span>
                                                @endif
                                            </div>
                                        </div>
                                    </div>

                                    <div class="col-md-4">
                                        <div class="row">
                                            <label class="col-sm-4 control-label">
                                                Monto:*
                                            </label>
                                            <div class="col-sm-8 form-group{{ $errors->has('amount') ? ' has-error' : '' }}">
                                                <input type="text" class="form-control" id="amount" name="amount" value="{{ old('amount')}}" pattern="^([0-9]*)|([0-9]*\.?[0-9]{2})$" title="solo numeros, decimal solo 2" maxlength="20" placeholder="Monto..." required>
                                                @if ($errors->has('amount'))
                                                    <span class="help-block">
                                                        <strong>{{ $errors->first('amount') }}</strong>
                                                    </span>
                                                @endif
                                                <div id="montocero" style="display:none;color:#FF0000;">
                                                    <strong>El monto no puede ser 0.</strong>
                                                </div>
                                                <div id="montoregex" style="display:none;color:#FF0000;">
                                                    <strong>solo numeros, solo 2 decimales.</strong>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="col-md-4">
                                        <div class="row">
                                            <label class="col-sm-4 control-label">
                                                Descrip.:
                                            </label>
                                            <div class="col-sm-8 form-group{{ $errors->has('description') ? ' has-error' : '' }}">
                                                <textarea  rows="1" id="description" name="description" value="{{ old('description')}}" maxlength="60" class="form-control textarea-no-resize" placeholder="Descripción">{{ old('description')}}</textarea>
                                                @if ($errors->has('description'))
                                                    <span class="help-block">
                                                        <strong>{{ $errors->first('description') }}</strong>
                                                    </span>
                                                @endif
                                            </div>
                                        </div>
                                    </div>

                                                
                                    
                                </div>

                                <div class="form-group remove-border">
                                    <div class="col-md-4">
                                        <div class="row">
                                            <label class="col-sm-5 control-label">
                                                Fecha vencimiento:*
                                            </label>
                                            <div class="col-sm-7 form-group{{ $errors->has('deadline') ? ' has-error' : '' }}">
                                                <input type="text" autocomplete="off" class="bootstrap-datepicker form-control manita" value="{{old('deadline')}}" id="deadline" name="deadline" {!! $datesvalidation !!} title="aaaa-mm-dd" required>
                                                @if ($errors->has('deadline'))
                                                    <span class="help-block">
                                                        <strong>{{ $errors->first('deadline') }}</strong>
                                                    </span>
                                                @endif
                                            </div>
                                        </div>
                                    </div>
                                </div>



                            </div>

                            <div class="row" >
                                <div class="col-md-12">
                                    <p style="font-size:12px;"><em>(*) Estos campos son requeridos.</em></p>
                                </div>
                            </div>

                            <div class="button-pane mrg20T">
                                <button id="btncerosub" class="btn btn-success">Registrar gasto</button>
                            </div>
                        </div>

                    </div>
                </div>
                {!! Form::close() !!}
            </div>
        </div>
    </div>
</div>

<div class="row">
    <div class="col-md-12">
        <div class="panel">
            <div class="panel-body">
                <h3 class="title-hero">
                    Gastos por pagar
                </h3>
                <div class="example-box-wrapper">
                    <div class="remove-columns">
                        <table class="table table-condensed table-striped">
                            <thead>
                                <tr>
                                    <th>Categoría</th>
                                    <th class="tab-center">Descripción</th>
                                    <th class="tab-center">Monto</th>
                                    <th class="tab-center">Fecha de captura</th>
                                    <th class="tab-center">Vencimiento</th>
                                    <th class="tab-center"></th>
                                </tr>
                            </thead>
                            <tbody>
                                @if(empty($porpagar))

                                @else

                                    @foreach($porpagar as $ppr)
                                        <tr id="traccountexp">
                                            <td data-title="Categoría">{{$ppr->category_description}}</td>
                                            <td data-title="Descripción" class="tab-center">
                                                {{ $ppr->description }}&nbsp;
                                            </td>
                                            <td data-title="Monto" class="tab-center">${{$balance  = number_format($ppr->to_pay, 2, '.', ',')}}</td>
                                            <td data-title="Fecha de captura" class="tab-center">{{$ppr->capture_date}}</td>
                                            <td data-title="Vencimiento" class="tab-center">{{$ppr->deadline}}</td>
                                            <td data-title="Acción" class="tab-center" style="min-width:105px;">
                                                <button id="btnupdateexpense{{$c++}}" value="{{$ppr->ids}}" data-toggle="modal" data-target="#updateexpensedebt" class="btn btn-xs btn-success"><i class="glyph-icon icon-check"></i></button>
                                                <button id="btndeleteexpense{{$b++}}" value="{{$ppr->ids}}" data-toggle="modal" data-target="#deleteexpensedebt" class="btn btn-xs btn-danger"><i class="glyph-icon icon-times"></i></button>
                                            </td>
                                        </tr>
                                    @endforeach
                                @endif
                            </tbody>
                        </table>
                    </div>

                    <div class="row">
                        <div class="col-sm-6 col-sm-offset-6">
                            <div class="dataTables_paginate paging_bootstrap" id="datatable-example_paginate">
                                <ul class="pagination">
                                    @if(empty($porpagar))

                                    @else
                                        {!! $porpagar->render() !!}
                                    @endif
                                </ul>
                            </div>
                        </div>
                    </div>

                </div>
            </div>
        </div>
    </div>
</div>

            
<div class="panel">
    <div class="panel-body">
        <h3 class="title-hero">
            Historial de egresos
        </h3>

        {!! Form::open(['method' => 'GET', 'action' => 'ExpenseController@index', 'id' => 'formexpensesfilter']) !!}
            <div class="form-horizontal pad15L pad15R bordered-row">

                <div class="form-group remove-border">
                    <div class="col-md-3">
                        <div class="row">
                            <label class="col-sm-4 control-label">Fecha:</label>
                            <div class="col-sm-8">
                                <div class="input-prepend input-group">
                                    <span class="add-on input-group-addon">
                                        <i class="glyph-icon icon-calendar"></i>
                                    </span>
                                    <input type="text" autocomplete="off" class="bootstrap-datepicker form-control manita" value="{{$fecha}}" id="fecha" name="fecha" {!! $datesvalidation !!} title="aaaa-mm-dd" >
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="row">
                            <label class="col-sm-4 control-label">Categoría:</label>
                            <div class="col-sm-8">
                                <select class="form-control" id="categoria" name="categoria" value="{{old('categoria')}}">
                                    <option value="">-Selecciona-</option>
                                        @foreach($expense_category as $expense_categories)
                                   
                                                @if($categoria == $expense_categories->id)  
                                                     <option value="{{$expense_categories->id}}" selected>{{$expense_categories->category_description}}</option>
                                                @else
                                                     <option value="{{$expense_categories->id}}">{{$expense_categories->category_description}}</option>
                                                @endif
                                           
                                        @endforeach        
                                </select>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-5" >
                        <div class="row" style="margin-left:5px;">
                            <button class="btn btn-alt btn-hover btn-primary">
                            <span>Filtrar</span>
                                <i class="glyph-icon icon-arrow-right"></i>
                            </button>
                            <a href="{{ action('ExpenseController@index')}}" class="btn btn-alt btn-hover btn-default">
                            <span>Eliminar filtro</span>
                                <i class="glyph-icon icon-arrow-right"></i>
                            </a>
                        </div>
                    </div>
                        
                    <input type="hidden" class="form-control" id="street" name="street" value="" placeholder="Calle">
                </div>

            </div>
        {!! Form::close() !!}


        <div class="example-box-wrapper">
            <div id="datatable-example_wrapper" class="dataTables_wrapper form-inline no-footer">   

                <div class="remove-columns" style="overflow-x:scroll;">
                    <table cellpadding="0" cellspacing="0" border="0" class="table table-striped table-bordered dataTable">
                        <thead class="cf">
                            <tr role="row">
                                <th class="tab-center">Folio</th>
                                <th class="tab-center">Categoría</th>
                                <th class="tab-center">Descripción</th>
                                <th class="tab-center">Monto</th>
                                <th class="tab-center">Tipo de pago</th>
                                <th class="tab-center">Fecha</th>
                                <th class="tab-center">Fecha de captura</th>
                                <th class="tab-center"></th>
                            </tr>
                        </thead>
                        <tbody>
                            @if(empty($expense))

                            @else
                                @foreach($expense as $expenses)
                            <tr role="row" id="trexpense">
                                <td data-title="Folio" class="tab-center">{{$expenses->id }}</td>
                                <td data-title="Categoria" class="tab-center">{{$expenses->category_description }}</td>
                                <td data-title="Descripción" class="tab-center">{{$expenses->description }}&nbsp;</td>
                                <td data-title="Monto" class="tab-center">${{$balance  = number_format($expenses->amount, 2, '.', ',')}}</td>
                                <td data-title="Tipo de pago" class="tab-center">{{$expenses->payment_name}}</td>
                                <td data-title="Fecha contable" class="tab-center">{{$expenses->accounting_date}}</td>
                                <td data-title="Fecha de captura" class="tab-center">{{$expenses->capture_date}}</td>
                                <td data-title="Acción" class="tab-center" style="min-width:105px;">
                                    @if(empty($expenses->url_voucher))
                                        <button  class="btn btn-xs btn-info pad5R" disabled><i class="glyph-icon icon-eye"></i></button>                      
                                    @else         
                                        <button  href="javascript:;" onClick="MM_openBrWindow('{{$expenses->url_voucher}}','','scrollbars=yes,resizable=yes,width=800,height=600')" class="btn btn-xs btn-info pad5R"><i class="glyph-icon icon-eye"></i></button>
                                    @endif
                                        
                                    <!--@can('edit', App\Expense::class)
                                        <a href="{{ action('ExpenseController@edit', $expenses->id)}}">
                                            <i class="glyph-icon icon-pencil pad5R"></i>
                                        </a>
                                    @endcan
                                    @can('delete', App\Income::class)
                                        <a id="btndeleteexpense{{$a++}}" value="{{$expenses->id}}" data-toggle="modal" data-target="#deleteexpense">
                                            <i class="glyph-icon icon-trash pad5L"></i>
                                        </a>
                                    @endcan-->
                                </td>
                            </tr>
                                @endforeach
                            @endif
                        </tbody>
                    </table>
                </div>

                <div class="row">

                    <div class="col-sm-6 col-sm-offset-6">
                        <div class="dataTables_paginate paging_bootstrap" id="datatable-example_paginate">
                            <ul class="pagination">

                                @if(empty($expense))
                                @else
                                    {!! $expense->render() !!}
                                @endif
                                
                                <!--<li class="previous disabled"><a href="#">Anterior</a></li>
                                <li class="active"><a href="#">1</a></li>
                                <li><a href="#">2</a></li>
                                <li><a href="#">3</a></li>
                                <li><a href="#">4</a></li>
                                <li><a href="#">5</a></li>
                                <li class="next"><a href="#">Siguiente</a></li>-->
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>



@include('footer')

{!! Html::script('js/expense.js') !!}

<!--========= MODAL APROBAR EGRESO =========================================================================== -->
<div id="updateexpensedebt" class="modal fade" role="dialog" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
        
            <div class="modal-header">
                <button type="button" id="" class="close" data-dismiss="modal" aria-hidden="true">&times;</button> 
                <h4 class="modal-title" id="mySmallModalLabel"><span>Registrar pago</span></h4>
            </div>
            
            <div class="modal-body">
               
                <!-- Contenido -->
                <div class="row" id="contentindex">
                    <!--<div class="col-md-12" style="padding-bottom:10px;">
                        <p style="padding-left:20px; padding-right:20px;">¿Esta seguro que desea aprobar este egreso?</p>
                    </div>-->
                    @if(empty($porpagar))

                    @else
                    {!! Form::model($porpagar , ['method' => 'PATCH', 'enctype' => 'multipart/form-data', 'action' => ['ExpenseController@update', $ppr->id]]) !!}
                    <input type="hidden" id="updateexpenseid" name="id" value=""> 
                        @endif

                    <div class="col-md-12" style="padding-bottom:10px;">
                        <div class="col-md-4">
                            <label class="control-label">Cuenta:*</label>
                            <select class="form-control" id="" name="account" required>
                                <option value="">-Selecciona-</option>
                                @foreach($account as $accounts)
                                    <option value="{{ $accounts->id }}">{{ $accounts->description }}</option>
                                @endforeach
                            </select>
                        </div>

                        <div class="col-md-4">
                            <label class="control-label">Tipo de pago:*</label>
                            <select class="form-control" id="payment_type" name="payment_type" required>
                                 <option value="">-Selecciona-</option>
                                @foreach($payment_type as $payment_types)
                                    <option value="{{ $payment_types->id }}">{{ $payment_types->payment_name }}</option>
                                @endforeach
                            </select>
                            
                        </div>

                        <div class="col-md-4">
                            <label class="control-label">Comprobante:</label>
                            <div class="fileinput fileinput-new" data-provides="fileinput" style="display-block">
                                <span class="btn btn-default btn-file">
                                <span class="fileinput-new"><i class="glyph-icon icon-paperclip"></i> Adjuntar archivo</span>
                                <span class="fileinput-exists">Cambiar</span>
                                    <input type="file"  id="file" name="file" accept="application/pdf,image/jpg,image/jpeg,image/png">
                                </span>
                                <span class="fileinput-filename"></span>
                                <a href="#" class="close fileinput-exists" data-dismiss="fileinput" style="float: none">×</a>
                            </div>
                            <input type="hidden" id="imageName" name="imageName" value=""/>
                            <input type="hidden" id="contentType" name="contentType" value=""/>
                            <input type="hidden" id="imageData" name="imageData" value=""/>
                            <input type="hidden" id="sizeData" name="sizeData" value=""/>
                        </div>
                    </div> 

                    <div class="col-md-12">
                        <div class="col-md-4">
                            <label class="control-label">Fecha:*</label>
                            <div class="input-prepend input-group">
                                <span class="add-on input-group-addon">
                                    <i class="glyph-icon icon-calendar"></i>
                                </span>
                                <input type="text" class="bootstrap-datepicker form-control" id="accounting_date" name="accounting_date" required>
                            </div>
                        </div> 
                        <div class="col-md-4">
                            <label class="control-label">Monto:*</label>
                            <input type="text" class="form-control" id="amount2" name="amount" value="" pattern="^([0-9]*)|([0-9]*\.?[0-9]{2})$" title="solo numeros, decimal solo 2" maxlength="20" placeholder="Monto..." required>
                        </div>  
                    </div>

                    <div class="col-md-12" style="padding-top:10px;">
                        <p style="font-size:12px;"><em>(*) Estos campos son requeridos.</em></p>
                    </div> 

                </div>
            
            </div>

            <div class="modal-footer">
                <button type="submit" id="" class="btn btn-eliminar">Aprobar</button>
                {!!Form::close()!!}
            
            </div>
            
        </div>
    </div>
</div>
<!--========= MODAL APROBAR EGRESO =========================================================================== -->

<!--========= MODAL RECHAZAR EGRESO =========================================================================== -->
<div id="deleteexpensedebt" class="modal fade" role="dialog" aria-hidden="true">
    <div class="modal-dialog modal-eliminar">
        <div class="modal-content">
        
            <div class="modal-header">
                <button type="button" id="" class="close" data-dismiss="modal" aria-hidden="true">&times;</button> 
                <h4 class="modal-title" id="mySmallModalLabel"><span>Rechazar egreso</span></h4>
            </div>
            
            <div class="modal-body">
               
                <!-- Contenido -->
                <div class="row" id="contentindex">
                    <div class="col-md-12">
                        <p style="padding-left:20px; padding-right:20px;">¿Esta seguro que desea rechazar este egreso?</p>
                    </div>
                    @if(empty($porpagar))

                    @else
                    {!! Form::open(['method' => 'DELETE', 'action' => ['ExpenseController@destroy', $ppr->id]]) !!}
                    <div class="col-md-12" style="padding-top:20px;">
                        <input type="hidden" id="deleteexpenseid" name="id" value="">      
                    </div>                                                                        
                </div>
            
            </div>

            <div class="modal-footer">
                <button type="submit" id="" class="btn btn-eliminar">Rechazar</button>
                {!!Form::close()!!}
                @endif
            </div>
            
        </div>
    </div>
</div>
<!--========= MODAL RECHAZAR EGRESO =========================================================================== -->

<!--========= MODAL COMFIRMACIÓN PARA ELIMINAR =========================================================================== -->
<!--<div id="deleteexpense" class="modal fade" role="dialog" aria-hidden="true">
    <div class="modal-dialog modal-eliminar">
        <div class="modal-content">
        
            <div class="modal-header">
                <button type="button" id="" class="close" data-dismiss="modal" aria-hidden="true">&times;</button> 
                <h4 class="modal-title" id="mySmallModalLabel"><span>Eliminar egreso</span></h4>
            </div>
            
            <div class="modal-body">
               
                <!- Contenido -->
                <!--<div class="row" id="contentindex">
                    <p style="padding-left:20px; padding-right:20px;">¿Esta seguro que desea eliminar este egreso?</p>
                    @if(empty($expense))

                    @else
                    {!! Form::open(['method' => 'DELETE', 'action' => ['ExpenseController@destroy', $expenses->id]]) !!}
                    <input type="hidden" id="deleteexpenseid" name="id" value="">                                    
                </div>
            
            </div>

            <div class="modal-footer">
                <button type="submit" id="aceptareliminar" class="btn btn-eliminar">Eliminar</button>
                {!!Form::close()!!}
                @endif
            </div>
            
        </div>
    </div>
</div>-->
<!--========= TERMINA MODAL COMFIRMACIÓN PARA ELIMINAR =========================================================================== -->
<script type="text/javascript" src="../../../../../assets/jquery-ui-1.12.1/jquery-ui.min.js"></script>
{!! Html::script('vendor/compress.js/src/Compress.js') !!}
{!! Html::script('vendor/compress.js/index.js') !!}
{!! Html::script('js/validaciones.js') !!}
<script>
$(document).ready(function() { 
     $('#deadline').datepicker({
    
        minDate: '0d',
    
    });

    comprimirImagen('file');

    $('#searchstreet').autocomplete({
            
        minLenght:1,
        autoFocus:true,
        source: '/getstreets',
        select: function( event, ui ) {
                                 
            $('#street_id').val(ui.item.id);
                   
        }

    });

    $('#fecha').datepicker({
       
    });

});

</script>
@endsection