@extends('master')
@section('content')

<style>
.form-control[readonly]
{
    cursor:pointer!important;
}
.manita
{
    cursor:pointer;
}
.ui-state-hover a,
.ui-state-hover a:hover,
.ui-state-hover a:link,
.ui-state-hover a:visited,
.ui-state-focus a,
.ui-state-focus a:hover,
.ui-state-focus a:link,
.ui-state-focus a:visited {
    color: #bcbcbc;
    text-decoration: none;
}
.ui-state-active,
.ui-state-active,
.ui-state-active {
    border: 1px solid #bcbcbc;
    background: #ffffff url(images/ui-bg_glass_65_ffffff_1x400.png) 50% 50% repeat-x;
    font-weight: bold;
    color: #bcbcbc;
    cursor:pointer;
}
.ui-state-active a,
.ui-state-active a:link,
.ui-state-active a:visited {
    color: #bcbcbc;
    text-decoration: none;
}

</style>
<!--BREADCRUMB-->
<div class="row">
                
    <!--Sección-->
    <div class="col-md-9">
        <div id="page-title">
            <h2>Cuotas extraordinarias</h2>
            <p>Registra aportaciones adicionales a las residencias.</p>
        </div>
    </div>
                
    <!--Fecha-->
    @include('date')

</div><!--BREADCRUMB END-->
  


<div class="row">
    <div class="col-md-12">
        @if (Session::has('message'))
            <div class="alert alert-success">
                <p>
                    {{ Session::get('message') }}
                </p>
            </div>
        @endif
    </div>
</div>

@if ($errors->has('error'))
    <div class="alert alert-danger">
        <ul>    
            <li>{{ $errors->first('error') }}</li>         
        </ul>
    </div>                                             
@endif



<div class="panel">
    <div class="panel-body">
        <h3 class="title-hero">
            Registrar cuenta extraordinaria
            
        </h3>

        {!! Form::open(['method' => 'POST', 'action' => 'ExtraordinaryAccountController@store', 'id' => '']) !!}            
        <div class="example-box-wrapper">
            <div class="row">

                <div class="col-md-12">
                    
                    <div id="demo-2" class="collapse in" aria-expanded="true">
                             
                        <div class="">
                            <div class="form-horizontal pad15L pad15R bordered-row">

                                <div class="form-group remove-border">
                                                
                                    <div class="col-md-4">
                                        <div class="row">
                                            <label class="col-sm-4 control-label">
                                                Residencia:*
                                            </label>
                                            <div class="col-sm-8 form-group{{ $errors->has('residence') ? ' has-error' : '' }}">
                                                <input type="text" class="form-control" id="searchstreet"  name="searchstreet" value="{{old('searchstreet')}}" placeholder="Calle/piso" onkeypress="return pulsar(event)">
                                                <input type="hidden" class="form-control" id="street_id" name="residence" value="{{old('residence')}}" placeholder="">
                                                @if ($errors->has('residence'))
                                                    <span class="help-block">
                                                        <strong>{{ $errors->first('residence') }}</strong>
                                                    </span>
                                                @endif
                                            </div>

                                        </div>
                                    </div>

                                    <div class="col-md-4">
                                   
                                        <div class="row">
                                            <label class="col-sm-4 control-label">
                                                Descrip.*:
                                            </label>
                                            <div class="col-sm-8 form-group{{ $errors->has('description') ? ' has-error' : '' }}" >
                                                
                                                 <textarea id="description" name="description" maxlength="40" rows="1" class="form-control textarea-no-resize" onkeypress="return pulsar(event)" placeholder="Descripción" required>{{old('description')}}</textarea>
                                                @if ($errors->has('description'))
                                                    <span class="help-block">
                                                        <strong>{{ $errors->first('description') }}</strong>
                                                    </span>
                                                @endif
                                            </div>
                                            
                                        </div>
                             
                                    </div>

                                    <div class="col-md-4">
                                        <div class="row">
                                            <label class="col-sm-4 control-label">
                                                Monto:*
                                            </label>
                                            <div class="col-sm-8 form-group{{ $errors->has('amount') ? ' has-error' : '' }}">
                                                <input type="text" class="form-control" id="amount" name="amount" value="{{old('amount')}}" onkeypress="return pulsar(event)" pattern="^([0-9]*)|([0-9]*\.?[0-9]{2})$" title="no se permite 0,decimal solo 2" maxlength="9" placeholder="Cantidad de aportación..." required>
                                                @if ($errors->has('amount'))
                                                    <span class="help-block">
                                                        <strong>{{ $errors->first('amount') }}</strong>
                                                    </span>
                                                @endif
                                               
                                                <div id="montocero" style="display:none;color:#FF0000;">
                                                    <strong>El monto no puede ser 0.</strong>
                                                </div>
                                                <div id="montoregex" style="display:none;color:#FF0000;">
                                                   <strong>solo numeros, solo 2 decimales.</strong>
                                                </div>
                                              
                                            </div>
                                        </div>
                                    </div>

                                </div>

                                <div class="row remove-border">
                                                
                                    <div class="col-md-4">
                                        <label class="col-sm-4 control-label">
                                                Todas las residencias:*
                                            </label>
                                            <div class="col-sm-8 form-group{{ $errors->has('allstreet') ? ' has-error' : '' }}">
                                                <div class="col-sm-8 col-md-8">
                                                    @if(old('allstreet'))
                                                        @if(old('allstreet') == 1)
                                                            <input type="checkbox" class="" id="allstreet" name="allstreet" value="1" onkeypress="return pulsar(event)" checked>
                                                        @else
                                                            <input type="checkbox" class="" id="allstreet" name="allstreet" onkeypress="return pulsar(event)" value="1">
                                                        @endif
                                                    @else
                                                        <input type="checkbox" class="" id="allstreet" name="allstreet" onkeypress="return pulsar(event)" value="1">
                                                    @endif
                                                @if ($errors->has('allstreet'))
                                                    <span class="help-block">
                                                        <strong>{{ $errors->first('allstreet') }}</strong>
                                                    </span>
                                                @endif
                                                </div>
                                            </div>
                                    </div>
                                    <div class="col-md-4">
                                        <label class="col-sm-4 control-label">
                                                Fecha vencimiento:*
                                            </label>
                                            <div class="col-sm-8 form-group{{ $errors->has('deadline') ? ' has-error' : '' }}">
                                               
                                                    
                                                    <div class="input-prepend input-group">
                                                            <span class="add-on input-group-addon">
                                                                <i class="glyph-icon icon-calendar"></i>
                                                            </span>
                                                        @if(old('deadline'))
                                                            <input type="text" autocomplete="off" class="bootstrap-datepicker form-control manita" onkeypress="return pulsar(event)" value="{{old('deadline')}}" {!! $datesvalidation !!} title="aaaa-mm-dd" id="deadline" name="deadline" required>
                                                        @else
                                                            <input type="text" autocomplete="off" class="bootstrap-datepicker form-control manita" onkeypress="return pulsar(event)" value="" {!! $datesvalidation !!} title="aaaa-mm-dd" id="deadline" name="deadline" required>
                                                        @endif
                                                    </div>

                                                @if ($errors->has('deadline'))
                                                    <span class="help-block">
                                                        <strong>{{ $errors->first('deadline') }}</strong>
                                                    </span>
                                                @endif
                                                </div>
                                            </div>
                                    </div>

                                </div>

                            <div class="row" >
                                <div class="col-md-12">
                                    <p style="font-size:12px;"><em>(*) Estos campos son requeridos.</em></p>
                                </div>
                            </div>

                            <div class="button-pane mrg20T">
                                 <button type="button" class="btn btn-success" id="acept" >Registrar</button>
                                
                            </div>
                            <button type="submit" id="btnregistrar" style="display:none;"></button>
                        </div>

                    </div>
                </div>

            </div>
        </div>
        {!! Form::close() !!}
    </div>
</div>

<!--========= MODAL GUARDAR CUOTA  =========================================================================== -->
<div id="aceptacuota" class="modal fade" role="dialog" aria-hidden="true" data-backdrop="static" data-keyboard="false" >
    <div class="modal-dialog ">
        <div class="modal-content">
        
            <div class="modal-header">
                <button type="button" id="cerrarmodalt" class="close" data-dismiss="modal" aria-hidden="true">&times;</button> 
                <h4 class="modal-title" id="mySmallModalLabel"><span>Agregar cuota extraordinaria</span></h4>
            </div>
            
            <div class="modal-body">
               
                <!-- Contenido -->
                <div class="row" id="contentindex">
                    <div class="col-md-12">
                        <div style="padding-left:20px; padding-right:20px;" id="texto"></div>
                        <p style="padding-left:20px; padding-right:20px; padding-top:10px;"><strong>Esta acción no se puede deshacer.</strong> ¿Esta seguro que desea registrar esta cuota extraordinaria?</p>
                    </div>

                    
                    <div class="col-md-12" style="padding-top:20px;">
                       
                    </div>                                                                        
                </div>
            
            </div>

            <div class="modal-footer">
                
                <button type="button" id="btncerrarmodal" class="btn btn-dafault" data-dismiss="modal">Cerrar</button>
                <button type="submit" id="acept2" class="btn btn-success" >Aceptar</button>
   
            </div>
            
        </div>
    </div>
</div>
<!--========= MODAL GUARDAR CUOTA  =========================================================================== -->

<script type="text/javascript" src="../../../../../assets/jquery-ui-1.12.1/jquery-ui.min.js"></script>

<script>

$(document).ready(function() { 
    $("#allstreet").on('click',function(){

        if($("#allstreet").prop("checked"))
        {
            $("#searchstreet").attr("disabled",true);
            $("#searchstreet").attr("required",false);
            $("#searchstreet").val('');
            $("#street_id").val('');
            $("#allstreet").val(2);

            
        }
        else
        {
           
            $("#allstreet").val(1);
            $("#searchstreet").attr("disabled",false);
            $("#searchstreet").attr("required",true);
        }

    });

    if($("#allstreet").prop("checked"))
    {
        $("#searchstreet").attr("disabled",true);
        $("#searchstreet").attr("required",false);
        $("#searchstreet").val('');
        $("#street_id").val('');
        $("#allstreet").val(2);
        
    }
    else
    {
        $("#allstreet").val(1);
        $("#searchstreet").attr("disabled",false);
        $("#searchstreet").attr("required",true);
    }

    $("#cerrarmodalt").on('click',function(){

        $("#texto").empty();
    });

    $("#btncerrarmodal").on('click',function(){

        $("#texto").empty();
    });


    $("#acept2").on('click',function(){

        $("#btnregistrar").click();
    });

    $("#acept").on('click',function(){

       
    
        var monto = $("#amount").val();
            
            //^([0-9])* | ([0-9])*[.]?[0-9]{2}$
            if(/^[0-9]+(\.[0-9]{1,2})?$/.test(monto))
            {
                $("#montoregex").hide("slow");
                if($("#amount").val() <= 0)
                {
                        
                    if($("#amount").val() == "")
                    {
                        $("#montocero").hide("slow");
                        if(($("#searchstreet").val() == "" && $("#allstreet").val() == 1) || $("#description").val() == "" || $("#amount").val() == "" || $("#deadline").val() == "" )
                        {
                            
                            $("#btnregistrar").click();
                            
                            
                        }
                        else
                        {
                            
                           
                            if($("#searchstreet").val() != "")
                            {
                                add = '<p>La cuota extraordinaria es para el residente <strong>'+$("#searchstreet").val()+'</strong>.<br>'+
                                'Con un <strong>monto de: $'+$("#amount").val()+'</strong>.</p>';
                                       
                            }
                            else
                            {
                                add = '<p>La cuota extraordinaria es para <strong>todos los residentes</strong>.<br>'+
                                'Con un <strong>monto de: $'+$("#amount").val()+'</strong>.</p>';
                            }
                           

                            $("#texto").append(add);
                            
                            $("#aceptacuota").modal("show");
                        }
                        
                    }
                    else
                    {
                        $("#aceptacuota").modal('hide');
                        $("#montocero").show("slow");
                    }
  
                }
                else
                {   
                    $("#montocero").hide("slow");
                    if(($("#searchstreet").val() == "" && $("#allstreet").val() == 1) || $("#description").val() == "" || $("#amount").val() == "" || $("#deadline").val() == "" )
                    {
                         $("#btnregistrar").click();
                       
                    }
                    else
                    {
                        if($("#searchstreet").val() != "")
                        {
                            add = '<p>La cuota extraordinaria es para el residente <strong>'+$("#searchstreet").val()+'</strong>.<br>'+
                            'Con un <strong>monto de: $'+$("#amount").val()+'</strong>.</p>';
                               
                        }
                        else
                        {
                            add = '<p>La cuota extraordinaria es para <strong>todos los residentes</strong>.<br>'+
                            'Con un <strong>monto de: $'+$("#amount").val()+'</strong>.</p>';
                        }
                            

                        $("#texto").append(add);

                        $("#aceptacuota").modal("show");
                    }

                    
                }
                
            }
            else
            {
                
                $("#montocero").hide("slow");
                $("#montoregex").show("slow");
              
            }

        

    });

    $('#deadline').datepicker({
         minDate: '0d',                                                                                                    
    }); 

    $('#deadline').keypress(function(tecla){
    
       if(tecla.charCode < 48 || tecla.charCode > 57)return false;
       if ((tecla.charCode < 97 || tecla.charCode > 122)//letras mayusculas
                && (tecla.charCode < 65 || tecla.charCode > 90) //letras minusculas
                && (tecla.charCode != 45) //retroceso
                && (tecla.charCode != 241) //ñ
                 && (tecla.charCode != 209) //Ñ
                 && (tecla.charCode != 32) //espacio
                 && (tecla.charCode != 225) //á
                 && (tecla.charCode != 233) //é
                 && (tecla.charCode != 237) //í
                 && (tecla.charCode != 243) //ó
                 && (tecla.charCode != 250) //ú
                 && (tecla.charCode != 193) //Á
                 && (tecla.charCode != 201) //É
                 && (tecla.charCode != 205) //Í
                 && (tecla.charCode != 211) //Ó
                 && (tecla.charCode != 218) //Ú
 
              )
        return false; 

    });

    $('#amount').keypress(function(evt){
        //if(tecla.charCode < 48 || tecla.charCode > 57) return false;
        var charCode = (evt.which) ? evt.which : evt.keyCode;
        if (charCode != 46 && charCode > 31 && (charCode < 48 || charCode > 57))
        return false;
        //return true;
    });

    $('#searchstreet').autocomplete({
            
            minLenght:1,
            autoFocus:true,
            source: '/getstreets',
            select: function( event, ui ) {
                                 
                $('#street_id').val(ui.item.id);
                   
            }

        });



});

function pulsar(e) { 
  tecla = (document.all) ? e.keyCode :e.which; 
  return (tecla!=13); 
} 
    
</script>

@endsection
