@extends('master')
@section('content')
    
<!--BREADCRUMB-->
<div class="row">
                
    <!--Sección-->
    <div class="col-md-9">
        <div id="page-title">
            <h2>Dashboard</h2>
                <p>Revisa aspectos importantes de tu cuenta y de tu colonia.</p>
            </div>
        </div>
                
        <!--Fecha-->
        <div class="col-md-3 font-gray text-right">
            <i class="glyph-icon icon-calendar"></i>&nbsp;
            <script>
                var meses = new Array ("Enero","Febrero","Marzo","Abril","Mayo","Junio","Julio","Agosto","Septiembre","Octubre","Noviembre","Diciembre");
                var diasSemana = new Array("Domingo","Lunes","Martes","Miércoles","Jueves","Viernes","Sábado");
                var f=new Date();
                document.write(diasSemana[f.getDay()] + ", " + f.getDate() + " de " + meses[f.getMonth()] + " de " + f.getFullYear());
            </script>
        </div>
</div><!--#BREADCRUMB END-->

        <div class="row">
            <div class="col-md-12">
                @if (Session::has('message'))
                   <div class="alert alert-danger">
                        <p>
                            {{ Session::get('message') }}
                        </p>
                     </div>
                @endif
            </div>
         </div>

        <div class="row">
            <div class="col-md-12">
                <div class="col-md-12" style="background-color:#fff; padding:10px 20px; margin-bottom:10px;">
                    <span class="caption-subject" style="float: left; display: inline-block; padding: 12px 0;">Ingresos</span>
                    <div class="actions">
                        <div class="btn-group">
                                
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-12">
                        @if (count($errors) > 0)
                            <div class="alert alert-danger">
                                <ul>
                                    @foreach ($errors->all() as $error)
                                        <li>{{ $error }}</li>
                                     @endforeach
                                </ul>
                            </div>
                        @endif
                    </div>
                </div>

                <div class="col-md-12" style="background-color:#fff; padding:30px; margin-bottom:20px;">
                        <div class="portlet">
                            <div class="portlet-title">
                                <div class="caption">
                                    <span class=""> </span>
                                </div>
                            </div>
                            {!! Form::open(['method' => 'POST', 'action' => 'IncomeController@store', 'enctype' => 'multipart/form-data', 'id' => 'formemploye']) !!}
                                <div class="col-lg-4 col-md-4 login-container bs-reset">
                                    <div class="login-content">

                                        <div class="row">
                                                <div class="col-md-6 col-sm-6">
                                                    <div class="form-group form-md-line-input has-info form-md-floating-label">
                                                        <div class="input-group left-addon">
                                                            <input type="text" autocomplete="off" id="amount" name="amount" value="{{$amount}}"pattern="^([0-9]*)|([0-9]*\.?[0-9]{2})$" title="solo numeros, decimal solo 2" maxlength="20" class="form-control" required>
                                                                <label for="form_control_1">Cantidad</label>
                                                             @if ($errors->has('quantity'))
                                                                <span class="help-block">
                                                                    <strong>{{ $errors->first('quantity') }}</strong>
                                                                </span>
                                                            @endif
                                                        </div>
                                                    </div>
                                                </div>
                                        </div>
                                            <div class="row">
                                                <div class="col-md-12 col-sm-12">
                                                    <div class="form-group form-md-line-input has-info form-md-floating-label">
                                                        <div class="input-group left-addon">
                                                            <input type="text" autocomplete="off" id="description" name="description" maxlength="60" class="form-control" required>
                                                                <label for="form_control_1">Descripción</label>
                                                            @if ($errors->has('description'))
                                                                <span class="help-block">
                                                                    <strong>{{ $errors->first('description') }}</strong>
                                                                </span>
                                                            @endif
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="row">
                                                <div class="col-md-12 col-sm-12">
                                                    <div class="form-group form-md-line-input has-info form-md-floating-label">
                                                        <div class="input-group left-addon">
                                                            <select id="payment_type" name="payment_type" class="form-control" required>
                                                                @foreach($payment_type as $payment_types)
                                                                    <option value="{{$payment_types->id}}">{{$payment_types->payment_name}}</option>
                                                                @endforeach
                                                            </select> 
                                                                <label for="form_control_1">Tipo de pago</label>
                                                            @if ($errors->has('payment_type'))
                                                                <span class="help-block">
                                                                    <strong>{{ $errors->first('payment_type') }}</strong>
                                                                </span>
                                                            @endif
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="row">
                                                <div class="col-md-12 col-sm-12">
                                                    <div class="form-group form-md-line-input has-info form-md-floating-label">
                                                        <div class="input-group left-addon">
                                                            <select id="residence" name="residence" class="form-control" required> 
                                                                <option value="">-Selecciona-</option>
                                                                @foreach($resident as $residents)
                                                                    <option value="{{$residents->id}}">{{$residents->name_street}} {{$residents->number}}</option>
                                                                @endforeach
                                                            </select>
                                                                <label for="form_control_1">Residencia</label>
                                                            @if ($errors->has('residence'))
                                                                <span class="help-block">
                                                                    <strong>{{ $errors->first('residence') }}</strong>
                                                                </span>
                                                            @endif
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="row">
                                                <div class="col-md-12 col-sm-12">
                                                    <div class="form-group form-md-line-input has-info form-md-floating-label">
                                                        <div class="input-group left-addon">
                                                            <label for="form_control_1">Comprobante</label>
                                                            <input class="form-control" type="file" id="" name="file"/>
                                                                
                                                            @if ($errors->has('file'))
                                                                <span class="help-block">
                                                                    <strong>{{ $errors->first('file') }}</strong>
                                                                </span>
                                                            @endif
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>

                                            <div class="row">
                                                <div class="col-md-12">
                                                    <button type="submit" class="btn btn-sm green dropdown-toggle">Guardar</button>
                                                </div>
                                            </div>
                                    </div>
                                </div>
                    

                                <div class="col-lg-8 col-md-8 login-container bs-reset">
                                    <div class="portlet">
                                        <div class="portlet box red">
                                            <div class="portlet-title">
                                                <div class="caption">
                                                    Deuda del usuario seleccionado<i class="fa fa-cogs"></i> 
                                                </div>
                                                <div class="tools">
                                                        <a href="javascript:;" class="collapse" data-original-title="" title=""> </a>
                                                        <a href="javascript:;" class="reload" data-original-title="" title=""> </a>
                                                </div>
                                            </div>
                                            <div class="portlet-body">
                                               <div id="history_resident">
                                                    
                                               </div>
                                            </div>
                                        </div>
                                    </div>


                                   
                                </div>
                               
                        </div>            
                            {!! Form::close() !!}
                </div>
          
            </div>

        </div>

        <footer>
            <hr>
            <p class="font-gray"><span style="text-align:left;float:left"><strong>Desarrollado por:</strong> <a href="http://www.innovationti.mx">Innovation TI</a></span></p>
        </footer> 

{!! Html::script('js/incomes.js') !!}
@endsection