@extends('master')
@section('content')

<!--BREADCRUMB-->
<div class="row">
                
    <!--Sección-->
    <div class="col-md-9">
        <div id="page-title">
            <h2>Ingresos</h2>
            <p>Edita pagos</p>
        </div>
    </div>
                
    <!--Fecha-->
    @include('date')

</div><!--BREADCRUMB END-->
  


@include('sessionmessage')   

@if ($errors->has('error'))
    <div class="alert alert-danger">
        <ul>    
            <li>{{ $errors->first('error') }}</li>         
        </ul>
    </div>                                             
@endif

@if ($errors->has('error2'))
    <div class="alert alert-danger">
        <ul>    
            <li>{{ $errors->first('error2') }}</li>         
        </ul>
    </div>                                             
@endif

@if ($errors->has('deuda'))
    <div class="alert alert-danger">
        <ul>    
            <li>{{ $errors->first('deuda') }}</li>         
        </ul>
    </div>                                             
@endif

<div class="panel">
    <div class="panel-body">
        <h3 class="title-hero">
            Editar pago
            
        </h3>

        {!! Form::model($payment,['method' => 'PATCH', 'action' => ['EditIncomeController@update', $payment->id], 'enctype' => 'multipart/form-data', 'id' => 'formeditincome']) !!}            
        <div class="example-box-wrapper">
            <div class="row">

                <div class="col-md-12">
      
                    <div class="">
                        <div class="form-horizontal pad15L pad15R bordered-row">

                            <div class="form-group remove-border">
                                                
                                <div class="col-md-4">
                                    <div class="row">
                                        <label class="col-sm-4 control-label">
                                            Residente:*
                                        </label>
                                        <div class="col-sm-8 form-group{{ $errors->has('residence') ? ' has-error' : '' }}">
                                            <select class="form-control" id="residence" name="residence" value="{{$payment->residence}}" required>
                                                <option value="">-Selecciona-</option>
                                                    @foreach($street as $streets)
                                                        @if($streets->id == "1")
                                                        @else
                                                            @if($payment->residence == $streets->id)
                                                                <option value="{{$streets->id}}" selected>{{$streets->name_street}} {{$streets->number}}</option>
                                                            @else
                                                                <option value="{{$streets->id}}" >{{$streets->name_street}} {{$streets->number}}</option>
                                                            @endif
                                                        @endif
                                                    @endforeach
                                            </select>
                                            @if ($errors->has('residence'))
                                                <span class="help-block">
                                                    <strong>{{ $errors->first('residence') }}</strong>
                                                </span>
                                            @endif
                                        </div>

                                    </div>
                                </div>

                                <div class="col-md-4">
                                    <div class="row">
                                        <label class="col-sm-4 control-label">
                                            Monto:*
                                        </label>
                                        <div class="col-sm-8 form-group{{ $errors->has('amount') ? ' has-error' : '' }}">
                                            <input type="text" class="form-control" id="amount" name="amount" value="{{$payment->amount}}" pattern="^([0-9]*)|([0-9]*\.?[0-9]{2})$" title="solo numeros, decimal solo 2" maxlength="20" placeholder="Cantidad de aportación..." required>
                                                @if ($errors->has('amount'))
                                                    <span class="help-block">
                                                        <strong>{{ $errors->first('amount') }}</strong>
                                                    </span>
                                                @endif
                                        </div>
                                    </div>
                                </div>

                                <div class="col-md-4">
                                    <div class="row">
                                        <label class="col-sm-4 control-label">
                                            Método de pago:*
                                        </label>
                                        <div class="col-sm-8 form-group{{ $errors->has('payment_type') ? ' has-error' : '' }}">
                                            <select id="payment_type" name="payment_type" value="{{$payment->payment_type}}" class="form-control" required>
                                                <option value="">-Selecciona-</option>
                                                @foreach($payment_type as $payment_types)
                                                    @if($payment->payment_type == $payment_types->id)
                                                        <option value="{{$payment_types->id}}" selected>{{$payment_types->payment_name}}</option>
                                                    @else
                                                        <option value="{{$payment_types->id}}">{{$payment_types->payment_name}}</option>
                                                    @endif
                                                @endforeach
                                            </select>
                                            @if ($errors->has('payment_type'))
                                                <span class="help-block">
                                                    <strong>{{ $errors->first('payment_type') }}</strong>
                                                </span>
                                            @endif
                                        </div>
                                    </div>
                                </div>

                            </div>

                            <div class="form-group">
                                                
                                <div class="col-md-4">
                                    <div class="row">
                                        <label class="col-sm-4 control-label">
                                            Fecha de pago:*
                                        </label>
                                        <div class="col-sm-8 form-group{{ $errors->has('payment_date') ? ' has-error' : '' }}" >
                                            <div class="input-prepend input-group">
                                                <span class="add-on input-group-addon">
                                                    <i class="glyph-icon icon-calendar"></i>
                                                </span>
                                                <input type="text" autocomplete="off" class="bootstrap-datepicker form-control" value="{{$payment->payment_date}}" id="payment_date" name="payment_date" required>
                                            </div>
                                            @if ($errors->has('payment_date'))
                                                <span class="help-block">
                                                    <strong>{{ $errors->first('payment_date') }}</strong>
                                                </span>
                                            @endif
                                        </div>
                                            
                                    </div>
                                </div>

                                <div class="col-md-4">
                                    <div class="row">
                                        <label class="col-sm-4 control-label">
                                            Descripción:
                                        </label>
                                        <div class="col-sm-8 form-group{{ $errors->has('description') ? ' has-error' : '' }}">
                                                <!--<input type="text" class="form-control" id="description" name="description" value="{{old('description')}}"  maxlength="50" placeholder="" required>-->
                                            <textarea name="" rows="1" id="description" maxlength="50" name="description" class="form-control textarea-no-resize">{{ $payment->description }}</textarea>
                                            @if ($errors->has('description'))
                                                <span class="help-block">
                                                    <strong>{{ $errors->first('description') }}</strong>
                                                </span>
                                            @endif
                                        </div>
                                            
                                    </div>
                                </div>
                                                
                                <div class="col-md-4">
                                    <div class="row">
                                        <label class="col-sm-4 control-label">
                                            <span class="bs-badge badge-info tooltip-button" data-toggle="tooltip" data-placement="top" title="Se pueden subir archivos: jpg, jpeg ,png y pdf.Tamaño maximo del archivo 5 mb.">?</span> Comprobante:
                                        </label>
                                        <div class="col-sm-8 form-group{{ $errors->has('file') ? ' has-error' : '' }}">
                                            <div class="fileinput fileinput-new" data-provides="fileinput">
                                                <span class="btn btn-default btn-file">
                                                <span class="fileinput-new"><i class="glyph-icon icon-paperclip"></i> Adjuntar archivo</span>
                                                <span class="fileinput-exists">Cambiar</span>
                                                    <input type="file" id="file" name="file" value="">
                                                </span>
                                                <span class="fileinput-filename"></span>
                                                <a href="#" class="close fileinput-exists" data-dismiss="fileinput" style="float: none">×</a>
                                            </div>
                                        </div>
                                        @if ($errors->has('file'))
                                            <span class="help-block">
                                                <strong>{{ $errors->first('file') }}</strong>
                                            </span>
                                        @endif
                                    </div>
                                </div>

                            </div>

                            
                            <div class="form-group">             
                                <div class="col-md-4">
                                    <div class="row">
                                        <label class="col-sm-4 control-label">
                                            Cuenta:*
                                        </label>
                                        <div class="col-sm-8 form-group{{ $errors->has('accountid') ? ' has-error' : '' }}">
                                            <select class="form-control" id="accountid" name="accountid" value="{{$payment->account_id}}" required>
                                                <option value="">-Selecciona-</option>
                                                @foreach($account as $accounts)
                                                    @if($payment->account_id == $accounts->id)
                                                        <option value="{{$accounts->id}}" selected>{{ $accounts->description }}</option>
                                                    @else
                                                        <option value="{{$accounts->id}}">{{ $accounts->description }}</option>
                                                    @endif
                                                @endforeach
                                            </select>
                                            @if ($errors->has('accountid'))
                                                <span class="help-block">
                                                    <strong>{{ $errors->first('accountid') }}</strong>
                                                </span>
                                            @endif
                                        </div>
                                            
                                    </div>
                                </div>
                            </div>

                        </div>

                        <div class="row" >
                            <div class="col-md-12">
                                <p style="font-size:12px;"><em>(*) Estos campos son requeridos.</em></p>
                            </div>
                        </div>

                        <div class="button-pane mrg20T">
                            <button type="submit" class="btn btn-success">Registrar pago</button>
                        </div>
                    </div>
                   
                </div>

            </div>
        </div>
        {!! Form::close() !!}
    </div>
</div>
            
@endsection