@extends('master')
@section('content')


<!--BREADCRUMB-->
<div class="row">       
    <!--Sección-->
    <div class="col-md-9">
        <div id="page-title">
            <h2>Mis pagos</h2>
            <p>Detalle de pago</p>
        </div>
    </div>
                
    <!--Fecha-->
    <div class="col-md-3 font-gray fecha">
        <p><i class="glyph-icon icon-calendar"></i>&nbsp;
            <script>
                var meses = new Array ("Enero","Febrero","Marzo","Abril","Mayo","Junio","Julio","Agosto","Septiembre","Octubre","Noviembre","Diciembre");
                var diasSemana = new Array("Domingo","Lunes","Martes","Miércoles","Jueves","Viernes","Sábado");
                var f=new Date();
                document.write(diasSemana[f.getDay()] + ", " + f.getDate() + " de " + meses[f.getMonth()] + " de " + f.getFullYear());
            </script>
        </p>
    </div>
</div><!--BREADCRUMB END-->


@if ($errors->has('error'))
    <div class="alert alert-danger">
        <ul>    
            <li>{{ $errors->first('error') }}</li>         
        </ul>
    </div>                                             
@endif
@include('sessionmessage')


<div class="panel">
    <div class="panel-body">
        <h3 class="title-hero">
            Pago
        </h3>

        <div class="example-box-wrapper">
            @foreach($income as $incomes)
            <div class="row">
                <div class="col-md-6">
                    <div>
                        <label style="display:inline-block">Folio:</label> <p style="display:inline-block">{{$incomes->ids}}</p>
                    </div>
                    <div>
                        <label style="display:inline-block">Fecha de pago:</label> <p style="display:inline-block">{{$incomes->payment_date}}</p>
                    </div>
                    <div>
                        <label style="display:inline-block">Fecha de captura:</label> <p style="display:inline-block">{{$incomes->capture_date}}</p>
                    </div>
                    <div>
                        <label style="display:inline-block">Descripción:</label> <p style="display:inline-block">{{$incomes->description}}</p>
                    </div>
                </div>

                <div class="col-md-6">
                    <div>
                        <label style="display:inline-block">Tipo de pago:</label> <p style="display:inline-block">{{$incomes->payment_name}}</p>
                    </div>
                    <div>
                        <label style="display:inline-block">Cantidad:</label> <p style="display:inline-block">${{$incomes->amount}}</p>
                    </div>
                    <div>
                        <label style="display:inline-block">Estatus:</label> <p style="display:inline-block">{{$incomes->stname}}</p>
                    </div>
                </div>
            </div>
            @endforeach

            
        </div>
    </div>
</div>

            
<div class="panel">
    <div class="panel-body">
        <h3 class="title-hero">
            Detalle de pago
        </h3>

        <div class="example-box-wrapper">
            <div id="datatable-example_wrapper" class="dataTables_wrapper form-inline no-footer">   


                <div class="remove-columns">
                    <table cellpadding="0" cellspacing="0" border="0" class="table table-striped table-bordered dataTable">
                        <thead class="cf">
                            <tr role="row">
                                <th class="tab-center">Categoría</th>
                                <th class="tab-center">Descripción</th>
                                <th class="tab-center">Monto</th>
                            </tr>
                        </thead>

                        <tbody>
                            @foreach($detalle as $detalles)
                            <tr role="row">
                                <td data-title="Folio" class="tab-center">{{$detalles->category_name}}</td>
                                <td data-title="Folio" class="tab-center">{{$detalles->description}}</td>
                                <td data-title="Folio" class="tab-center">${{$detalles->paid}}</td>
                            </tr>
                            @endforeach
                            <tr>
                                <td></td>
                                <td class="tab-center">TOTAL</td>
                                <td class="tab-center">
                                    @foreach($total as $totales)
                                        ${{$totales->pay}}
                                    @endforeach
                                </td>
                            </tr>
                                    
                        </tbody>
                    </table>
                           
                </div>

                           
                </div>
            </div>
        </div>

   
            <div class="button-pane mrg20T">
                <a href="{{url('/incomes/residents')}}" class="btn btn-success">Regresar</a>
            </div>
        
    </div>

@include('footer')



@endsection