@extends('master')
@section('content')
<div class="page-content-wrapper">
    <!-- BEGIN CONTENT BODY -->
    <div class="page-content">
    	<!-- BEGIN PAGE BAR -->
        <div class="page-bar">
            <ul class="page-breadcrumb">
                <li>
                    <a href=""></a>
                    <i class="fa fa-circle"></i>
                </li>
             	<li>
                     <span>Configuración</span>
                </li>
            </ul>
            <div class="page-toolbar">
                <div class="pull-right btn-sm">
                    <i class="icon-calendar"></i>&nbsp;
                        <script>
                            var meses = new Array ("Enero","Febrero","Marzo","Abril","Mayo","Junio","Julio","Agosto","Septiembre","Octubre","Noviembre","Diciembre");
                            var diasSemana = new Array("Domingo","Lunes","Martes","Miércoles","Jueves","Viernes","Sábado");
                            var f=new Date();
                            document.write(diasSemana[f.getDay()] + ", " + f.getDate() + " de " + meses[f.getMonth()] + " de " + f.getFullYear());
                        </script>
                </div>
            </div>
        </div>
        <!-- END PAGE BAR -->
        <!-- BEGIN PAGE TITLE-->
        <h3 class="page-title"><a href="{{ url('/incomes') }}"><i class="icon-arrow-left"></i></a>Ingresos</h3>
        <!-- END PAGE TITLE-->
        <!-- END PAGE HEADER-->
        <!-- BEGIN DASHBOARD STATS 1-->
        <div class="clearfix"></div>

        <div class="row">
            <div class="col-md-12">
                @if (Session::has('message'))
                   <div class="alert alert-danger">
                        <p>
                            {{ Session::get('message') }}
                        </p>
                     </div>
                @endif
            </div>
         </div>

         <div class="col-md-10">
            <div class="col-md-12" style="background-color:#fff; padding:10px 20px; margin-bottom:10px;">
                <span class="caption-subject" style="float: left; display: inline-block; padding: 12px 0;">Ingresos</span>
                <div class="actions">
                    <div class="btn-group">
                            
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-md-12">
                    @if (count($errors) > 0)
                        <div class="alert alert-danger">
                            <ul>
                                @foreach ($errors->all() as $error)
                                    <li>{{ $error }}</li>
                                 @endforeach
                            </ul>
                        </div>
                    @endif
                </div>
            </div>

            <div class="col-md-12" style="background-color:#fff; padding:30px; margin-bottom:20px;">
                    <div class="portlet">
                        <div class="portlet-title">
                            <div class="caption">
                                <span class=""> </span>
                            </div>
                        </div>
                        {!! Form::model($incomeR , ['method' => 'PATCH', 'enctype' => 'multipart/form-data',  'action' => ['UpdateIncomeResidentController@update',$incomeR->id]]) !!}
                            <div class="col-lg-8 col-md-8 login-container bs-reset">
                                <div class="login-content">
                                        <input type="hidden" value="{{$incomeR->id}}" id="" name="id">
                                        <div class="form-group remove-border">

                                            <div class="col-md-4">
                                                <div class="row">
                                                    <label class="col-sm-4 control-label">
                                                        Monto:</label>
                                                    <div class="col-sm-8">
                                                        <input type="text" class="form-control" id="amount" name="amount" value="" pattern="^([0-9]*)|([0-9]*\.?[0-9]{2})$" title="solo numeros, decimal solo 2" maxlength="20" placeholder="Cantidad de aportación..." required>
                                                    </div>

                                                </div>
                                            </div>

                                            <div class="col-md-4">
                                                <div class="row">
                                                    <label class="col-sm-4 control-label">
                                                        Método de pago:</label>
                                                        <div class="col-sm-8">
                                                            <select class="form-control" id="payment_type" name="payment_type"  required>
                                                                <option vlaue="">-Selecciona-</option>
                                                                @foreach($payment_type as $payment_types)
                                                                    <option value="{{$payment_types->id}}">{{$payment_types->payment_name}}</option>
                                                                @endforeach
                                                            </select> 
                                                        </div>
                                                </div>
                                            </div>

                                            <div class="col-md-4">
                                                <div class="row">
                                                    <label class="col-sm-4 control-label">
                                                        Fecha de pago:</label>
                                                    <div class="col-sm-8">
                                                        <div class="input-prepend input-group">
                                                            <span class="add-on input-group-addon">
                                                                <i class="glyph-icon icon-calendar"></i>
                                                            </span>
                                                            <input type="text" class="bootstrap-datepicker form-control" id="pay_date" name="pay_date" value="" data-date-format="mm/dd/yy" required>
                                                           
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>

                                        </div>
                                        <div class="row">
                                            <div class="col-md-12">
                                                <button type="submit" class="btn btn-sm green dropdown-toggle">Guardar</button>
                                            </div>
                                        </div>
                                </div>
                            </div>
                            
                        {!! Form::close() !!}

        </div>

</div>
<script>
$(document).ready(function() {

      $('#datetimepickerinres2').datetimepicker({
            format: 'YYYY-MM-DD',
        });
   
});
</script>

@endsection