@extends('master')
@section('content')
<div class="page-content-wrapper">
    <!-- BEGIN CONTENT BODY -->
    <div class="page-content">
        <!-- BEGIN PAGE BAR -->
        <div class="page-bar">
            <ul class="page-breadcrumb">
                <li>
                    <a href=""></a>
                    <i class="fa fa-circle"></i>
                </li>
                <li>
                     <span>Comunicados</span>
                </li>
            </ul>
            <div class="page-toolbar">
                <div class="pull-right btn-sm">
                    <i class="icon-calendar"></i>&nbsp;
                        <script>
                            var meses = new Array ("Enero","Febrero","Marzo","Abril","Mayo","Junio","Julio","Agosto","Septiembre","Octubre","Noviembre","Diciembre");
                            var diasSemana = new Array("Domingo","Lunes","Martes","Miércoles","Jueves","Viernes","Sábado");
                            var f=new Date();
                            document.write(diasSemana[f.getDay()] + ", " + f.getDate() + " de " + meses[f.getMonth()] + " de " + f.getFullYear());
                        </script>
                </div>
            </div>
        </div>
        <!-- END PAGE BAR -->
        <!-- BEGIN PAGE TITLE-->
        <h3 class="page-title"><a href="{{ url('/messages') }}"><i class="icon-arrow-left"></i></a>Comunicados</h3>
        <!-- END PAGE TITLE-->
        <!-- END PAGE HEADER-->
        <!-- BEGIN DASHBOARD STATS 1-->
        <div class="clearfix"></div>

        <div class="row">
            <div class="col-md-12">
                @if (Session::has('message'))
                   <div class="alert alert-danger">
                        <p>
                            {{ Session::get('message') }}
                        </p>
                     </div>
                @endif
            </div>
         </div>

        <div class="col-md-10">
            <div class="col-md-12" style="background-color:#fff; padding:10px 20px; margin-bottom:10px;">
                <span class="caption-subject" style="float: left; display: inline-block; padding: 12px 0;">Agregar Comunicado</span>
                <div class="actions">
                    <div class="btn-group">
                            
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-md-12">
                    @if (count($errors) > 0)
                        <div class="alert alert-danger">
                            <ul>
                                @foreach ($errors->all() as $error)
                                    <li>{{ $error }}</li>
                                 @endforeach
                            </ul>
                        </div>
                    @endif
                </div>
            </div>

            <div class="col-md-12" style="background-color:#fff; padding:30px; margin-bottom:20px;">
                    <div class="portlet">
                        <div class="portlet-title">
                            <div class="caption">
                                <span class=""> </span>
                            </div>
                        </div>
                        {!! Form::open(['method' => 'POST', 'action' => 'MessageController@store', 'enctype' => 'multipart/form-data', 'id' => 'formmessage']) !!}
                            <div class="col-lg-10 col-md-10 login-container bs-reset">
                                <div class="login-content">

                                    <div class="row">
                                        <div class="col-md-6 col-sm-6">
                                            <div class="form-group form-md-line-input has-info form-md-floating-label">
                                                <div class="input-group left-addon">
                                                    <input type="text" autocomplete="off" id="subject" name="subject" maxlength="40" class="form-control" required>
                                                    <label for="form_control_1">Asunto</label>
                                                    @if ($errors->has('subject'))
                                                        <span class="help-block">
                                                            <strong>{{ $errors->first('subject') }}</strong>
                                                        </span>
                                                    @endif
                                                </div>
                                            </div>
                                        </div>
                                    </div> 
                                    <div class="row">
                                        <div class="col-md-6 col-sm-6">
                                            <div class="form-group form-md-line-input has-info form-md-floating-label">
                                                <div class="input-group left-addon">
                                                    <textarea autocomplete="off" id="body" name="body"  class="form-control" required></textarea>
                                                    <label for="form_control_1">Mensaje</label>
                                                    @if ($errors->has('body'))
                                                        <span class="help-block">
                                                            <strong>{{ $errors->first('body') }}</strong>
                                                        </span>
                                                    @endif
                                                </div>
                                            </div>
                                        </div>
                                    </div> 
                                    <div class="row">
                                        <div class="col-md-6 col-sm-6">
                                            <div class="form-group form-md-line-input has-info form-md-floating-label">
                                                <div class="input-group left-addon">
                                                    <input type="file" autocomplete="off" id="file" name="file" maxlength="20" class="form-control">
                                                    <label for="form_control_1">Anexo</label>
                                                    @if ($errors->has('file'))
                                                        <span class="help-block">
                                                            <strong>{{ $errors->first('file') }}</strong>
                                                        </span>
                                                    @endif
                                                </div>
                                            </div>
                                        </div>
                                    </div> 
                                    <div class="row">
                                        <div class="col-md-12">
                                            <input type="hidden" id="btngrdr" name="btngrdr" value="">
                                            <button type="submit" class="btn btn-sm green dropdown-toggle">Guardar</button>
                                            <button type="submit" id="publish" class="btn btn-sm green dropdown-toggle">Publicar</button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            
                        {!! Form::close() !!}

                           
                    </div>
                </div>
            </div>
        </div>
    </div>


<script>
    $('#amount').keypress(function(evt){
        //if(tecla.charCode < 48 || tecla.charCode > 57) return false;
        var charCode = (evt.which) ? evt.which : evt.keyCode;
        if (charCode != 46 && charCode > 31 && (charCode < 48 || charCode > 57))
        return false;
        //return true;
    });

    $('#publish').on('click', function(){

        $("#btngrdr").attr("value",1);
    });

    function MM_openBrWindow(theURL,winName,features) { //v2.0
      window.open(theURL,winName,features);
    }

</script>


@endsection