@extends('master')
@section('content')

<!--BREADCRUMB-->
<div class="row">
                
    <!--Sección-->
    <div class="col-md-9">
        <div id="page-title">
            <h2>Avisos</h2>
            <p>Revisa los avisos importantes de tu colonia</p>
        </div>
    </div>
                
    @include('date')
</div><!--BREADCRUMB END-->


@include('sessionmessage')
@if ($errors->has('error'))
    <div class="alert alert-danger">
        <ul>    
            <li>{{ $errors->first('error') }}</li>         
        </ul>
    </div>                                             
@endif

<div class="panel">
    <div class="panel-body">
        <h3 class="title-hero">
            Editar aviso
            
        </h3>
                    
        <div class="example-box-wrapper">
            <div class="row">
                {!! Form::model($message , ['method' => 'PATCH', 'enctype' => 'multipart/form-data', 'action' => ['MessageController@update', $message->id]]) !!}
                <div class="col-md-12">
    
                        <div class="">
                            <div class="form-horizontal pad15L pad15R bordered-row">

                                <div class="form-group remove-border">

                                    <div class="col-md-6">
                                        <div class="row">
                                            <label class="col-sm-4 control-label">
                                                Asunto:*
                                            </label>
                                            <div class="col-sm-8 form-group{{ $errors->has('subject') ? ' has-error' : '' }}">
                                                <input type="text" autocomplete="off" class="form-control" id="" name="subject" maxlength="40" value="{{$message->subject}}" required>
                                                @if ($errors->has('subject'))
                                                  <span class="help-block">
                                                    <strong>{{ $errors->first('subject') }}</strong>
                                                  </span>
                                                @endif
                                            </div>
                                        </div>
                                    </div>
                                                
                                </div>
                                            
                                <div class="form-group remove-border">
                                                
                                    <div class="col-md-6">
                                        <div class="row">
                                            <label class="col-sm-4 control-label">
                                                Mensaje:*
                                            </label>
                                            <div class="col-sm-8 form-group{{ $errors->has('body') ? ' has-error' : '' }}">
                                                <textarea  rows="3" id="body" name="body" class="form-control textarea-no-resize" required>{{$message->body}}</textarea>
                                                @if ($errors->has('body'))
                                                  <span class="help-block">
                                                    <strong>{{ $errors->first('body') }}</strong>
                                                  </span>
                                                @endif
                                            </div>
                                        </div>
                                    </div>

                                    <div class="col-md-4">
                                        <div class="row">
                                            <div class="col-sm-8 form-group{{ $errors->has('file') ? ' has-error' : '' }}">
                                                <div class="fileinput fileinput-new" data-provides="fileinput" style="display:inline-block;">
                                                    <span class="btn btn-default btn-file">
                                                        <span class="fileinput-new"><i class="glyph-icon icon-paperclip"></i> Adjuntar archivo</span>
                                                        <span class="fileinput-exists">Cambiar</span>
                                                        <input type="file" id="file" name="file" accept="application/pdf,image/jpg,image/jpeg,image/png">
                                                    </span>
                                                    <span class="fileinput-filename"></span>
                                                        <a href="#" class="close fileinput-exists" data-dismiss="fileinput" style="float: none">×</a>
                                                </div>
                                                <div style="display:inline-block;">
                                                    <span class="bs-badge badge-info tooltip-button" data-toggle="tooltip" data-placement="top" title="Se pueden subir archivos: jpg, jpeg ,png y pdf.Tamaño maximo del archivo 5 mb.">?</span>
                                                </div>
                                                @if ($errors->has('file'))
                                                  <span class="help-block">
                                                    <strong>{{ $errors->first('file') }}</strong>
                                                  </span>
                                                @endif
                                            </div>
                                            
                                        </div>
                                    </div>

                                    <input type="hidden" id="imageName" name="imageName" value=""/>
                                    <input type="hidden" id="contentType" name="contentType" value=""/>
                                    <input type="hidden" id="imageData" name="imageData" value=""/>
                                    <input type="hidden" id="sizeData" name="sizeData" value=""/>

                                </div>

                            </div>

                             <div class="row" >
                                <div class="col-md-12">
                                    <p style="font-size:12px;"><em>(*) Estos campos son requeridos.</em></p>
                                </div>
                            </div>

                            <div class="button-pane mrg20T">
                                <input type="hidden" id="btngrdr" name="btngrdr" value="">
                                <a href="{{url('messages')}}" class="btn btn-default">Cancelar</a>
                                <button class="btn btn-warning">Borrador</button>
                                <button class="btn btn-success" id="publish">Publicar</button>
                            </div>
                        </div>

                    <!--</div>-->
                </div>
                {!! Form::close() !!}
            </div>
        </div>
    </div>
</div>
@include('footer')  

{!! Html::script('js/message.js') !!}
{!! Html::script('vendor/compress.js/src/Compress.js') !!}
{!! Html::script('vendor/compress.js/index.js') !!}
{!! Html::script('js/validaciones.js') !!}

<script>

$(document).ready(function() { 
    comprimirImagen('file');
});

</script>

@endsection