@extends('master')
@section('content')

<link rel="stylesheet" type="text/css" href="assets/applications/mailbox.css">
<style>

@media only screen and (max-width: 1000px) {
    .remove-columns2 table,
    .remove-columns2 thead,
    .remove-columns2 tbody,
    .remove-columns2 .table th,
    .remove-columns2 .table td,
    .remove-columns2 .table tr {
        display: block;
    }
    .remove-columns2 thead tr {
        position: absolute;
        top: -9999px;
        left: -9999px;
    }
    .remove-columns2 .table tr {
        border: 1px solid #dfe8f1;
    }
    .remove-columns2 .table td {
        border: none;
        border-bottom: 1px solid #eee;
        position: relative;
        /*padding-left: 50%;*/
        white-space: normal;
        text-align: left;
    }
    .remove-columns2 .table td:before {
        position: absolute;
        top: 6px;
        left: 6px;
        width: 45%;
        padding-right: 10px;
        white-space: nowrap;
        text-align: left;
        font-weight: bold;
    }
    .remove-columns2 .table td:before {
        content: attr(data-title);
    }
}
</style>
<!--BREADCRUMB-->
<div class="row">
                
    <!--Sección-->
    <div class="col-md-9">
        <div id="page-title">
            <h2>Avisos</h2>
            <p>Crea avisos importantes para el residencial</p>
        </div>
    </div>
                
    @include('date')
</div><!--BREADCRUMB END-->


@include('sessionmessage')
@if ($errors->has('error'))
    <div class="alert alert-danger">
        <ul>    
            <li>{{ $errors->first('error') }}</li>         
        </ul>
    </div>                                             
@endif
@if ($errors->has('error2'))
    <div class="alert alert-danger">
        <ul>    
            <li>{{ $errors->first('error2') }}</li>         
        </ul>
    </div>                                             
@endif
                            
<div class="panel">
    <div class="panel-body">
        <h3 class="title-hero">
            Nuevo aviso
            <div class="header-buttons" style="padding-top:5px;">
                @if($errors->has('subject') || $errors->has('body') || $errors->has('file') || $errors->has('error'))
                    <a href="#" id="btnabrir" class="btn btn-md btn-danger" data-toggle="collapse" data-target="#demo-2" aria-expanded="true"><i id="iconagregar" class="glyph-icon icon-minus"></i></a>
                @else
                    <a href="#" id="btnabrir" class="btn btn-md btn-danger collapsed" data-toggle="collapse" data-target="#demo-2" aria-expanded="true"><i id="iconagregar" class="glyph-icon icon-plus"></i></a>
                @endif
            </div>
        </h3>
                    
        <div class="example-box-wrapper">
            <div class="row">
                {!! Form::open(['method' => 'POST', 'action' => 'MessageController@store', 'enctype' => 'multipart/form-data', 'id' => 'formmessage']) !!}
                <div class="col-md-12">
                    @if($errors->has('subject') || $errors->has('body') || $errors->has('file') || $errors->has('error'))
                        <div id="demo-2" class="collapse in" aria-expanded="true">
                    @else
                        <div id="demo-2" class="collapse" aria-expanded="true">
                    @endif
                                
                        <div class="">
                            <div class="form-horizontal pad15L pad15R bordered-row">

                                <div class="form-group remove-border">

                                    <div class="col-md-6">
                                        <div class="row">
                                            <label class="col-sm-4 control-label">
                                                Asunto:*
                                            </label>
                                            <div class="col-sm-8 form-group{{ $errors->has('subject') ? ' has-error' : '' }}">
                                                <input type="text" autocomplete="off" class="form-control" id="" name="subject" value="{{old('subject')}}" maxlength="40" placeholder="Asunto..." required>
                                                @if ($errors->has('subject'))
                                                  <span class="help-block">
                                                    <strong>{{ $errors->first('subject') }}</strong>
                                                  </span>
                                                @endif
                                            </div>
                                        </div>
                                    </div>
                                                
                                </div>
                                            
                                <div class="form-group remove-border">
                                                
                                    <div class="col-md-6">
                                        <div class="row">
                                            <label class="col-sm-4 control-label">
                                                Mensaje:*
                                            </label>
                                            <div class="col-sm-8 form-group{{ $errors->has('body') ? ' has-error' : '' }}">
                                                <textarea  rows="3" id="body" name="body" class="form-control textarea-no-resize" value="{{old('body')}}" maxlength="380" required>{{ old('body') }}</textarea>
                                                @if ($errors->has('body'))
                                                  <span class="help-block">
                                                    <strong>{{ $errors->first('body') }}</strong>
                                                  </span>
                                                @endif
                                            </div>
                                        </div>
                                    </div>

                                    <div class="col-md-6">
                                        <div class="row">

                                            <div class="col-sm-7 form-group{{ $errors->has('file') ? ' has-error' : '' }}">
                                                
                                                <div class="fileinput fileinput-new" data-provides="fileinput" style="display:inline-block;">
                                                    <span class="btn btn-default btn-file ">
                                                        <span class="fileinput-new"><i class="glyph-icon icon-paperclip"></i> Adjuntar archivo</span>
                                                        <span class="fileinput-exists">Cambiar</span>
                                                        <input type="file" id="file" name="file" value="{{old('file')}}" accept="application/pdf,image/jpg,image/jpeg,image/png">
                                                    </span>
                                                    <span class="fileinput-filename "></span>
                                                        <a href="#" class="close fileinput-exists" data-dismiss="fileinput" style="float: none">×</a>
                                                </div>
                                                <div  style="display:inline-block;">
                                                    <span class="bs-badge badge-info tooltip-button" data-toggle="tooltip" data-placement="top" title="Se pueden subir archivos: jpg, jpeg ,png y pdf.Tamaño maximo del archivo 5 mb.">?</span>
                                                </div>
                                                
                                                @if ($errors->has('file'))
                                                  <span class="help-block">
                                                    <strong>{{ $errors->first('file') }}</strong>
                                                  </span>
                                                @endif
                                            </div>
                                            

                                        </div>
                                    </div>
                                    <input type="hidden" id="imageName" name="imageName" value=""/>
                                    <input type="hidden" id="contentType" name="contentType" value=""/>
                                    <input type="hidden" id="imageData" name="imageData" value=""/>
                                    <input type="hidden" id="sizeData" name="sizeData" value=""/>

                                </div>

                            </div>
                            <div class="row" >
                                <div class="col-md-12">
                                    <p style="font-size:12px;"><em>(*) Estos campos son requeridos.</em></p>
                                </div>
                            </div>

                            <div class="button-pane mrg20T">
                                <input type="hidden" id="btngrdr" name="btngrdr" value="">
                                <button class="btn btn-warning">Borrador</button>
                                <button class="btn btn-success" id="publish">Publicar</button>
                            </div>
                        </div>

                    </div>
                </div>
                {!! Form::close() !!}
            </div>
        </div>
    </div>
</div>
            
<div class="row mailbox-wrapper">
    <div class="col-md-12">
        <div class="content-box">
                    
            <div class="mail-toolbar clearfix">

                <div class="pagination"> {!! $message->render() !!}</div>
            </div>
            <div class="remove-columns2">        
                <table class="table table-hover text-center">
                    <tbody>
                        @foreach($message as $messages)
                            <tr id="trmessage">
                                <td class="email-title" >
                                    @if($messages->draft == 1)
                                        <span class="bs-label label-warning">Borrador</span>
                                    @else
                                        <span class="bs-label label-info">Publicado</span>
                                    @endif
                                </td>
                                <td>
                                    @if($messages->draft == 1)
                                        @can('edit', App\Income::class)
                                            <a href="{{ action('MessageController@edit', $messages->id)}}"><i class="glyph-icon icon-pencil"></i></a>                      
                                        @endcan
                                    @else
                                    @endif         
                                </td>
                                <td class="email-title">
                                    {{$messages->subject}}
                                </td>
                                <td class="email-body" style="word-break:break-all">
                                    {{$messages->body}}
                                </td>
                                <td>
                                    {!! date_format($messages->created_at, 'd/m/y'); !!}
                                 
                                </td>
                                <td>
                                    @if(empty($messages->url_file))
                                    @else
                                        <a href="javascript:;" onClick="MM_openBrWindow('{{$messages->url_file}}','','scrollbars=yes,resizable=yes,width=800,height=600')"><i class="glyph-icon icon-paperclip"></i></a>
                                    @endif
                                    </td>
                                <td>
                                    <a id="btndeletemessage{{$a++}}" value="{{$messages->id}}" data-toggle="modal" data-target="#deletemessage" href="#"><i class="glyph-icon icon-trash pad20R"></i></a>
                                </td>
                            </tr>
                        @endforeach 
                    </tbody>
                </table>
            </div>

        </div>
    </div>
</div>

@include('footer')

<!--========= MODAL COMFIRMACIÓN PARA ELIMINAR =========================================================================== -->
<div id="deletemessage" class="modal fade" role="dialog" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
        
            <div class="modal-header">
                <button type="button" id="" class="close" data-dismiss="modal" aria-hidden="true">&times;</button> 
                <h4 class="modal-title" id="mySmallModalLabel"><span>Eliminar aviso</span></h4>
            </div>
            
            <div class="modal-body">
               
                <!-- Contenido -->
                <div class="row" id="contentindex">
                    <p style="padding-left:20px; padding-right:20px;">¿Esta seguro que desea eliminar este aviso?</p>
                    @if(empty($messages))

                    @else
                    {!! Form::open(['method' => 'DELETE', 'action' => ['MessageController@destroy', $messages->id]]) !!}
                    <input type="hidden" id="deletemessageid" name="id" value="">                                    
                </div>
            
            </div>

            <div class="modal-footer">
                <button type="submit" id="aceptareliminar" class="btn btn-eliminar">Eliminar</button>
                {!!Form::close()!!}
                @endif
            </div>
            
        </div>
    </div>
</div>

<script type="text/javascript" src="../../../assets/widgets/uniform/uniform.js"></script>
<script type="text/javascript" src="../../../assets/widgets/uniform/uniform-demo.js"></script>
{!! Html::script('js/message.js') !!}
{!! Html::script('vendor/compress.js/src/Compress.js') !!}
{!! Html::script('vendor/compress.js/index.js') !!}
{!! Html::script('js/validaciones.js') !!}

<script>

    function MM_openBrWindow(theURL,winName,features) { //v2.0
      window.open(theURL,winName,features);
    }
$(document).ready(function() { 

    comprimirImagen('file');
});

</script>



@endsection

